/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.recording;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.recording.Event;
import org.neo4j.io.pagecache.tracing.recording.RecordingPageCursorTracer;
import org.neo4j.io.pagecache.tracing.recording.RecordingTracer;

public class RecordingPageCacheTracer
extends RecordingTracer
implements PageCacheTracer {
    private final AtomicLong pins = new AtomicLong();
    private final AtomicLong faults = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();

    public RecordingPageCacheTracer() {
        super(Evict.class);
    }

    public PageFileSwapperTracer createFileSwapperTracer() {
        return PageFileSwapperTracer.NULL;
    }

    public PageCursorTracer createPageCursorTracer(String tag) {
        return new RecordingPageCursorTracer(this, tag);
    }

    public void mappedFile(int swapperId, PagedFile pagedFile) {
    }

    public void unmappedFile(int swapperId, PagedFile pagedFile) {
    }

    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.getEvictionRunEvent();
    }

    public EvictionRunEvent beginEviction() {
        return this.getEvictionRunEvent();
    }

    private EvictionRunEvent getEvictionRunEvent() {
        return new EvictionRunEvent(){

            public void freeListSize(int size) {
            }

            public EvictionEvent beginEviction(long cachePageId) {
                return new RecordingEvictionEvent();
            }

            public void close() {
            }
        };
    }

    public FileFlushEvent beginFileFlush(PageSwapper swapper) {
        return FileFlushEvent.NULL;
    }

    public FileFlushEvent beginFileFlush() {
        return FileFlushEvent.NULL;
    }

    public DatabaseFlushEvent beginDatabaseFlush() {
        return DatabaseFlushEvent.NULL;
    }

    public long faults() {
        return this.faults.get();
    }

    public long failedFaults() {
        return 0L;
    }

    public long noFaults() {
        return 0L;
    }

    public long vectoredFaults() {
        return 0L;
    }

    public long failedVectoredFaults() {
        return 0L;
    }

    public long noPinFaults() {
        return 0L;
    }

    public long pins() {
        return this.pins.get();
    }

    public long evictions() {
        return 0L;
    }

    public long cooperativeEvictions() {
        return 0L;
    }

    public long unpins() {
        return 0L;
    }

    public long hits() {
        return 0L;
    }

    public long flushes() {
        return 0L;
    }

    public long merges() {
        return 0L;
    }

    public long bytesRead() {
        return 0L;
    }

    public long bytesWritten() {
        return 0L;
    }

    public long bytesTruncated() {
        return 0L;
    }

    public long filesMapped() {
        return 0L;
    }

    public long filesUnmapped() {
        return 0L;
    }

    public long filesTruncated() {
        return 0L;
    }

    public long evictionExceptions() {
        return 0L;
    }

    public double hitRatio() {
        return 0.0;
    }

    public double usageRatio() {
        return 0.0;
    }

    public long maxPages() {
        return 0L;
    }

    public long iopqPerformed() {
        return 0L;
    }

    public long ioLimitedTimes() {
        return 0L;
    }

    public long ioLimitedMillis() {
        return 0L;
    }

    public long openedCursors() {
        return 0L;
    }

    public long closedCursors() {
        return 0L;
    }

    public long copiedPages() {
        return 0L;
    }

    public long snapshotsLoaded() {
        return 0L;
    }

    public void pins(long pins) {
        this.pins.getAndAdd(pins);
    }

    public void unpins(long unpins) {
    }

    public void hits(long hits) {
    }

    public void faults(long faults) {
        this.faults.getAndAdd(faults);
    }

    public void noFaults(long noFaults) {
    }

    public void failedFaults(long failedFaults) {
    }

    public void vectoredFaults(long faults) {
    }

    public void failedVectoredFaults(long failedFaults) {
    }

    public void noPinFaults(long faults) {
    }

    public void bytesRead(long bytesRead) {
    }

    public void evictions(long evictions) {
        this.evictions.getAndAdd(evictions);
    }

    public void cooperativeEvictions(long evictions) {
    }

    public void evictionExceptions(long evictionExceptions) {
    }

    public void bytesWritten(long bytesWritten) {
    }

    public void flushes(long flushes) {
    }

    public void snapshotsLoaded(long snapshotsLoaded) {
    }

    public void merges(long merges) {
    }

    public void maxPages(long maxPages, long pageSize) {
    }

    public void iopq(long iopq) {
    }

    public void limitIO(long millis) {
    }

    public void pagesCopied(long copiesCreated) {
    }

    public void filesTruncated(long truncatedFiles) {
    }

    public void bytesTruncated(long bytesTruncated) {
    }

    public void openedCursors(long openedCursors) {
    }

    public void closedCursors(long closedCursors) {
    }

    private void evicted(long filePageId, PageSwapper swapper) {
        this.record(new Evict(swapper, filePageId));
    }

    public static class Evict
    extends Event {
        private Evict(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }

    private class RecordingEvictionEvent
    implements EvictionEvent {
        private long filePageId;
        private PageSwapper swapper;

        private RecordingEvictionEvent() {
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.swapper = swapper;
        }

        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageTranslator) {
            return FlushEvent.NULL;
        }

        public void setException(IOException exception) {
        }

        public void close() {
            RecordingPageCacheTracer.this.evicted(this.filePageId, this.swapper);
        }
    }
}

