/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.WebContainerHelper;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class NeoWebServerJAXRSIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    NeoWebServerJAXRSIT() {
    }

    @AfterEach
    void stopServer() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    @Test
    void shouldMakeJAXRSClassesAvailableViaHTTP() throws Exception {
        CommunityWebContainerBuilder serverBuilder = CommunityWebContainerBuilder.builder();
        this.testWebContainer = WebContainerHelper.createNonPersistentContainer(serverBuilder);
        FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper(this.testWebContainer);
        HttpRequest request = HttpRequest.newBuilder(functionalTestHelper.baseUri()).GET().build();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        HttpResponse<Void> response = httpClient.send(request, HttpResponse.BodyHandlers.discarding());
        Assertions.assertEquals((int)200, (int)response.statusCode());
    }

    @Test
    void shouldLoadThirdPartyJaxRsClasses() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withThirdPartyJaxRsPackage("org.dummy.web.service", "/dummy").usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).build();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        URI thirdPartyServiceUri = new URI(this.testWebContainer.getBaseUri() + "/dummy").normalize();
        HttpRequest request = HttpRequest.newBuilder(thirdPartyServiceUri).GET().build();
        String response = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
        Assertions.assertEquals((Object)"hello", (Object)response);
        int nodesCreated = NeoWebServerJAXRSIT.createSimpleDatabase((GraphDatabaseAPI)this.testWebContainer.getDefaultDatabase());
        thirdPartyServiceUri = new URI(this.testWebContainer.getBaseUri() + "/dummy/inject-test").normalize();
        request = HttpRequest.newBuilder(thirdPartyServiceUri).GET().build();
        response = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
        Assertions.assertEquals((Object)String.valueOf(nodesCreated), (Object)response, (String)response);
    }

    private static int createSimpleDatabase(GraphDatabaseAPI graph) {
        int numberOfNodes = 10;
        new Transactor((GraphDatabaseService)graph, tx -> {
            for (int i = 0; i < 10; ++i) {
                tx.createNode();
            }
            try (ResourceIterable allNodes1 = tx.getAllNodes();){
                for (Node node1 : allNodes1) {
                    ResourceIterable allNodes2 = tx.getAllNodes();
                    try {
                        for (Node node2 : allNodes2) {
                            if (node1.equals(node2)) continue;
                            node1.createRelationshipTo(node2, RelationshipType.withName((String)"REL"));
                        }
                    }
                    finally {
                        if (allNodes2 == null) continue;
                        allNodes2.close();
                    }
                }
            }
        }).execute();
        return 10;
    }
}

