/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.WebContainerTestUtils;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;
import org.neo4j.util.Preconditions;

public class CommunityWebContainerBuilder {
    private static final SocketAddress ANY_ADDRESS = new SocketAddress("localhost", 0);
    private final InternalLogProvider logProvider;
    private SocketAddress address = new SocketAddress("localhost", 7474);
    private SocketAddress httpsAddress = new SocketAddress("localhost", 7473);
    private String maxThreads;
    private String dataDir;
    private String dbUri = "/db";
    private final Map<String, String> thirdPartyPackages = new HashMap<String, String>();
    private final Properties arbitraryProperties = new Properties();
    private boolean persistent;
    private boolean httpEnabled = true;
    private boolean httpsEnabled;
    private DependencyResolver dependencies = new Dependencies();

    public static CommunityWebContainerBuilder builder(InternalLogProvider logProvider) {
        return new CommunityWebContainerBuilder(logProvider);
    }

    public static CommunityWebContainerBuilder builder() {
        return new CommunityWebContainerBuilder((InternalLogProvider)NullLogProvider.getInstance());
    }

    public static CommunityWebContainerBuilder serverOnRandomPorts(InternalLogProvider logProvider) {
        return CommunityWebContainerBuilder.builder(logProvider).onRandomPorts();
    }

    public static CommunityWebContainerBuilder serverOnRandomPorts() {
        return CommunityWebContainerBuilder.builder().onRandomPorts();
    }

    public TestWebContainer build() throws IOException {
        Preconditions.checkState((this.dataDir != null || !this.persistent ? 1 : 0) != 0, (String)"Must specify path");
        Path configFile = this.createConfigFiles();
        InternalLog log = this.logProvider.getLog(this.getClass());
        Config config = Config.newBuilder().setDefaults(GraphDatabaseSettings.SERVER_DEFAULTS).fromFile(configFile).build();
        config.setLogger(log);
        return new TestWebContainer(this.build(config), this.logProvider);
    }

    private DatabaseManagementService build(Config config) {
        TestDatabaseManagementServiceBuilder managementServiceBuilder = this.createManagementServiceBuilder();
        if (!this.persistent) {
            managementServiceBuilder = managementServiceBuilder.impermanent();
        } else {
            managementServiceBuilder.setDatabaseRootDirectory(Path.of(this.dataDir, new String[0]));
        }
        return managementServiceBuilder.setConfig(config).setInternalLogProvider(this.logProvider).setExternalDependencies(this.dependencies).build();
    }

    protected TestDatabaseManagementServiceBuilder createManagementServiceBuilder() {
        return new TestDatabaseManagementServiceBuilder();
    }

    private Path createConfigFiles() throws IOException {
        Path testFolder = this.persistent ? Path.of(this.dataDir, new String[0]) : WebContainerTestUtils.createTempDir();
        Path temporaryConfigFile = WebContainerTestUtils.createTempConfigFile((Path)testFolder);
        WebContainerTestUtils.writeConfigToFile(this.createConfiguration(testFolder), (Path)temporaryConfigFile);
        return temporaryConfigFile;
    }

    public Map<String, String> createConfiguration(Path temporaryFolder) {
        Map properties = MapUtil.stringMap((String[])new String[]{ServerSettings.db_api_path.name(), this.dbUri});
        WebContainerTestUtils.addDefaultRelativeProperties((Map)properties, (Path)temporaryFolder);
        if (this.dataDir != null) {
            properties.put(GraphDatabaseSettings.data_directory.name(), this.dataDir);
        }
        if (this.maxThreads != null) {
            properties.put(ServerSettings.webserver_max_threads.name(), this.maxThreads);
        }
        if (this.thirdPartyPackages.keySet().size() > 0) {
            properties.put(ServerSettings.third_party_packages.name(), WebContainerTestUtils.asOneLine(this.thirdPartyPackages));
        }
        properties.put(HttpConnector.enabled.name(), String.valueOf(this.httpEnabled));
        properties.put(HttpConnector.listen_address.name(), this.address.toString());
        properties.put(HttpConnector.advertised_address.name(), ":" + this.address.getPort());
        properties.put(HttpsConnector.enabled.name(), String.valueOf(this.httpsEnabled));
        properties.put(HttpsConnector.listen_address.name(), this.httpsAddress.toString());
        properties.put(HttpsConnector.advertised_address.name(), ":" + this.httpsAddress.getPort());
        properties.put(GraphDatabaseSettings.neo4j_home.name(), temporaryFolder.toAbsolutePath().toString());
        properties.put(GraphDatabaseSettings.auth_enabled.name(), "false");
        if (this.httpsEnabled) {
            Path certificates = temporaryFolder.resolve("certificates");
            SelfSignedCertificateFactory.create((FileSystemAbstraction)new DefaultFileSystemAbstraction(), (Path)certificates);
            SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS);
            properties.put(policy.enabled.name(), Boolean.TRUE.toString());
            properties.put(policy.base_directory.name(), certificates.toAbsolutePath().toString());
            properties.put(policy.trust_all.name(), "true");
            properties.put(policy.client_auth.name(), ClientAuth.NONE.name());
        }
        properties.put(GraphDatabaseSettings.logs_directory.name(), temporaryFolder.resolve("logs").toAbsolutePath().toString());
        properties.put(GraphDatabaseSettings.transaction_logs_root_path.name(), temporaryFolder.resolve("transaction-logs").toAbsolutePath().toString());
        properties.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        properties.put(GraphDatabaseSettings.shutdown_transaction_end_timeout.name(), "0s");
        for (Object key : this.arbitraryProperties.keySet()) {
            properties.put(String.valueOf(key), String.valueOf(this.arbitraryProperties.get(key)));
        }
        return properties;
    }

    protected CommunityWebContainerBuilder(InternalLogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public CommunityWebContainerBuilder withDependencies(DependencyResolver dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public CommunityWebContainerBuilder persistent() {
        this.persistent = true;
        return this;
    }

    public CommunityWebContainerBuilder withMaxJettyThreads(int maxThreads) {
        this.maxThreads = String.valueOf(maxThreads);
        return this;
    }

    public CommunityWebContainerBuilder usingDataDir(String dataDir) {
        this.dataDir = dataDir;
        return this;
    }

    public CommunityWebContainerBuilder withRelativeDatabaseApiPath(String uri) {
        this.dbUri = CommunityWebContainerBuilder.getPath(uri);
        return this;
    }

    public CommunityWebContainerBuilder withThirdPartyJaxRsPackage(String packageName, String mountPoint) {
        this.thirdPartyPackages.put(packageName, mountPoint);
        return this;
    }

    public CommunityWebContainerBuilder onRandomPorts() {
        this.onHttpsAddress(ANY_ADDRESS);
        this.onAddress(ANY_ADDRESS);
        return this;
    }

    public CommunityWebContainerBuilder onAddress(SocketAddress address) {
        this.address = address;
        return this;
    }

    public CommunityWebContainerBuilder onHttpsAddress(SocketAddress address) {
        this.httpsAddress = address;
        return this;
    }

    public CommunityWebContainerBuilder withHttpsEnabled() {
        this.httpsEnabled = true;
        return this;
    }

    public CommunityWebContainerBuilder withHttpDisabled() {
        this.httpEnabled = false;
        return this;
    }

    public CommunityWebContainerBuilder withProperty(String key, String value) {
        this.arbitraryProperties.put(key, value);
        return this;
    }

    private static String getPath(String uri) {
        URI theUri = URI.create(uri);
        if (theUri.isAbsolute()) {
            return theUri.getPath();
        }
        return theUri.toString();
    }

    static {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }
}

