/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.http.cypher.integration.TransactionConditions;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

public class RowFormatMetaFieldTestIT
extends AbstractRestFunctionalTestBase {
    private String commitResource;

    @BeforeEach
    public void setUp() {
        HTTP.Response begin = this.http.POST(RowFormatMetaFieldTestIT.txUri());
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        RowFormatMetaFieldTestIT.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.stringFromContent("commit");
        }
        catch (JsonParseException e) {
            org.junit.jupiter.api.Assertions.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        Assertions.assertThat((String)this.commitResource).isEqualTo(begin.location() + "/commit");
    }

    @AfterEach
    public void tearDown() {
        this.executeTransactionally("MATCH (n) DETACH DELETE n");
    }

    @Test
    public void metaFieldShouldGetCorrectIndex() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, RowFormatMetaFieldTestIT.queryAsJsonRow("MATCH (s:Start)-[r:R]->(e:End) RETURN s, r, 1, e"));
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.rowContainsMetaNodesAtIndex((int[])new int[]{0, 3})});
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.rowContainsMetaRelsAtIndex((int[])new int[]{1})});
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
    }

    @Test
    public void metaFieldShouldGivePathInfoInList() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, RowFormatMetaFieldTestIT.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) RETURN p"));
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.rowContainsAMetaListAtIndex((int)0)});
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
    }

    @Test
    public void metaFieldShouldPutPathListAtCorrectIndex() {
        this.executeTransactionally("CREATE (:Start)-[:R]->(:End)");
        HTTP.Response commit = this.http.POST(this.commitResource, RowFormatMetaFieldTestIT.queryAsJsonRow("MATCH p=(s)-[r:R]->(e) RETURN 10, p"));
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.containsNoErrors()});
        Assertions.assertThat((Object)commit).satisfies(new Consumer[]{TransactionConditions.rowContainsAMetaListAtIndex((int)1)});
        Assertions.assertThat((int)commit.status()).isEqualTo(200);
    }

    private void executeTransactionally(String query) {
        GraphDatabaseService database = this.graphdb();
        try (Transaction transaction = database.beginTx();){
            transaction.execute(query);
            transaction.commit();
        }
    }

    private static HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "', 'resultDataContents': [ 'row' ] } ] }"));
    }
}

