/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import org.eclipse.jetty.io.ByteBufferPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;

class Jetty9WebServerIT
extends ExclusiveWebContainerTestBase {
    private Jetty9WebServer webServer;

    Jetty9WebServerIT() {
    }

    @Test
    void shouldBeAbleToUsePortZero() throws Exception {
        this.webServer = new Jetty9WebServer((InternalLogProvider)NullLogProvider.getInstance(), Config.defaults(), NetworkConnectionTracker.NO_OP, (ByteBufferPool)Mockito.mock(ByteBufferPool.class));
        this.webServer.setHttpAddress(new SocketAddress("localhost", 0));
        this.webServer.start();
    }

    @Test
    void shouldBeAbleToRestart() throws Throwable {
        this.webServer = new Jetty9WebServer((InternalLogProvider)NullLogProvider.getInstance(), Config.defaults(), NetworkConnectionTracker.NO_OP, (ByteBufferPool)Mockito.mock(ByteBufferPool.class));
        this.webServer.setHttpAddress(new SocketAddress("127.0.0.1", 7878));
        this.webServer.start();
        this.webServer.stop();
        this.webServer.start();
    }

    @Test
    void shouldStopCleanlyEvenWhenItHasntBeenStarted() {
        new Jetty9WebServer((InternalLogProvider)NullLogProvider.getInstance(), Config.defaults(), NetworkConnectionTracker.NO_OP, (ByteBufferPool)Mockito.mock(ByteBufferPool.class)).stop();
    }

    @AfterEach
    void cleanup() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }
}

