/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.TransactionWriter;
import org.neo4j.consistency.internal.SchemaIndexExtensionLoader;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.schema.SchemaRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.ConfigurablePageCacheRule;
import org.neo4j.test.rule.TestDirectory;

public abstract class GraphStoreFixture
extends ConfigurablePageCacheRule
implements TestRule {
    private DirectStoreAccess directStoreAccess;
    private Statistics statistics;
    private final boolean keepStatistics;
    private NeoStores neoStore;
    private File directory;
    private long schemaId;
    private long nodeId;
    private int labelId;
    private long nodeLabelsId;
    private long relId;
    private long relGroupId;
    private int propId;
    private long stringPropId;
    private long arrayPropId;
    private int relTypeId;
    private int propKeyId;
    private DefaultFileSystemAbstraction fileSystem;
    private final LifeSupport life = new LifeSupport();
    private String formatName = "";

    private GraphStoreFixture(boolean keepStatistics, String formatName) {
        this.keepStatistics = keepStatistics;
        this.formatName = formatName;
    }

    protected GraphStoreFixture(String formatName) {
        this(false, formatName);
    }

    protected void after(boolean success) {
        super.after(success);
        this.life.shutdown();
        if (this.fileSystem != null) {
            try {
                this.fileSystem.close();
            }
            catch (IOException e) {
                throw new AssertionError("Failed to stop file system after test", e);
            }
        }
    }

    public void apply(Transaction transaction) throws TransactionFailureException {
        this.applyTransaction(transaction);
    }

    public DirectStoreAccess directStoreAccess() {
        if (this.directStoreAccess == null) {
            StoreAccess nativeStores;
            this.life.start();
            this.fileSystem = new DefaultFileSystemAbstraction();
            PageCache pageCache = this.getPageCache((FileSystemAbstraction)this.fileSystem);
            NullLogProvider logProvider = NullLogProvider.getInstance();
            Config config = Config.defaults();
            DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fileSystem);
            StoreFactory storeFactory = new StoreFactory(this.directory, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)this.fileSystem, (LogProvider)logProvider, EmptyVersionContextSupplier.EMPTY);
            this.neoStore = storeFactory.openAllNeoStores();
            if (this.keepStatistics) {
                AccessStatistics accessStatistics = new AccessStatistics();
                this.statistics = new VerboseStatistics(accessStatistics, (Counts)new DefaultCounts(ConsistencyCheckService.defaultConsistencyCheckThreadsNumber()), (Log)NullLog.getInstance());
                nativeStores = new AccessStatsKeepingStoreAccess(this.neoStore, accessStatistics);
            } else {
                this.statistics = Statistics.NONE;
                nativeStores = new StoreAccess(this.neoStore);
            }
            nativeStores.initialize();
            NeoStoreIndexStoreView indexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, nativeStores.getRawNeoStores());
            Monitors monitors = new Monitors();
            LabelScanStore labelScanStore = this.startLabelScanStore(pageCache, (IndexStoreView)indexStoreView, monitors);
            IndexProviderMap indexes = this.createIndexes(pageCache, (FileSystemAbstraction)this.fileSystem, this.directory, config, (LogProvider)logProvider, monitors);
            this.directStoreAccess = new DirectStoreAccess(nativeStores, labelScanStore, indexes);
        }
        return this.directStoreAccess;
    }

    private LabelScanStore startLabelScanStore(PageCache pageCache, IndexStoreView indexStoreView, Monitors monitors) {
        NativeLabelScanStore labelScanStore = new NativeLabelScanStore(pageCache, this.directory, (FileSystemAbstraction)this.fileSystem, (FullStoreChangeStream)new FullLabelStream(indexStoreView), false, monitors, RecoveryCleanupWorkCollector.IMMEDIATE);
        try {
            labelScanStore.init();
            labelScanStore.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return labelScanStore;
    }

    private IndexProviderMap createIndexes(PageCache pageCache, FileSystemAbstraction fileSystem, File storeDir, Config config, LogProvider logProvider, Monitors monitors) {
        SimpleLogService logService = new SimpleLogService(logProvider, logProvider);
        KernelExtensions extensions = (KernelExtensions)this.life.add((Lifecycle)SchemaIndexExtensionLoader.instantiateKernelExtensions((File)storeDir, (FileSystemAbstraction)fileSystem, (Config)config, (LogService)logService, (PageCache)pageCache, (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.IGNORE, (DatabaseInfo)DatabaseInfo.COMMUNITY, (Monitors)monitors));
        return SchemaIndexExtensionLoader.loadIndexProviders((KernelExtensions)extensions);
    }

    public File directory() {
        return this.directory;
    }

    public Statistics getAccessStatistics() {
        return this.statistics;
    }

    public IdGenerator idGenerator() {
        return new IdGenerator();
    }

    protected abstract void generateInitialData(GraphDatabaseService var1);

    protected void start(File storeDir) {
    }

    protected void stop() throws Throwable {
        if (this.directStoreAccess != null) {
            this.neoStore.close();
            this.directStoreAccess.close();
            this.directStoreAccess = null;
        }
    }

    private int myId() {
        return 1;
    }

    private int masterId() {
        return -1;
    }

    public Applier createApplier() {
        return new Applier();
    }

    private void applyTransaction(Transaction transaction) throws TransactionFailureException {
        try (Applier applier = this.createApplier();){
            applier.apply(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateInitialData() {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory);
        GraphDatabaseAPI graphDb = (GraphDatabaseAPI)builder.setConfig(GraphDatabaseSettings.record_format, this.formatName).setConfig(GraphDatabaseSettings.label_block_size, "60").setConfig("dbms.backup.enabled", "false").newGraphDatabase();
        try {
            this.generateInitialData((GraphDatabaseService)graphDb);
            StoreAccess stores = new StoreAccess(((RecordStorageEngine)graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores()).initialize();
            this.schemaId = stores.getSchemaStore().getHighId();
            this.nodeId = stores.getNodeStore().getHighId();
            this.labelId = (int)stores.getLabelTokenStore().getHighId();
            this.nodeLabelsId = stores.getNodeDynamicLabelStore().getHighId();
            this.relId = stores.getRelationshipStore().getHighId();
            this.relGroupId = stores.getRelationshipGroupStore().getHighId();
            this.propId = (int)stores.getPropertyStore().getHighId();
            this.stringPropId = stores.getStringStore().getHighId();
            this.arrayPropId = stores.getArrayStore().getHighId();
            this.relTypeId = (int)stores.getRelationshipTypeTokenStore().getHighId();
            this.propKeyId = (int)stores.getPropertyKeyNameStore().getHighId();
        }
        finally {
            graphDb.shutdown();
        }
    }

    public Statement apply(final Statement base, Description description) {
        final TestDirectory directory = TestDirectory.testDirectory((Class)description.getTestClass());
        return super.apply(directory.apply(new Statement(){

            public void evaluate() throws Throwable {
                GraphStoreFixture.this.directory = directory.graphDbDir();
                try {
                    GraphStoreFixture.this.generateInitialData();
                    GraphStoreFixture.this.start(GraphStoreFixture.this.directory);
                    try {
                        base.evaluate();
                    }
                    finally {
                        GraphStoreFixture.this.stop();
                    }
                }
                finally {
                    GraphStoreFixture.this.directory = null;
                }
            }
        }, description), description);
    }

    public class Applier
    implements AutoCloseable {
        private final GraphDatabaseAPI database;
        private final TransactionRepresentationCommitProcess commitProcess;
        private final TransactionIdStore transactionIdStore;
        private final NeoStores neoStores;

        Applier() {
            this.database = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(GraphStoreFixture.this.directory).setConfig("dbms.backup.enabled", "false").newGraphDatabase();
            DependencyResolver dependencyResolver = this.database.getDependencyResolver();
            this.commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)dependencyResolver.resolveDependency(TransactionAppender.class), (StorageEngine)dependencyResolver.resolveDependency(StorageEngine.class));
            this.transactionIdStore = (TransactionIdStore)this.database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
            this.neoStores = ((RecordStorageEngine)this.database.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        }

        public void apply(Transaction transaction) throws TransactionFailureException {
            TransactionRepresentation representation = transaction.representation(GraphStoreFixture.this.idGenerator(), GraphStoreFixture.this.masterId(), GraphStoreFixture.this.myId(), this.transactionIdStore.getLastCommittedTransactionId(), this.neoStores);
            this.commitProcess.commit(new TransactionToApply(representation), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        }

        @Override
        public void close() {
            this.database.shutdown();
        }
    }

    public static final class TransactionDataBuilder {
        private final TransactionWriter writer;
        private final NodeStore nodes;

        TransactionDataBuilder(TransactionWriter writer, NodeStore nodes) {
            this.writer = writer;
            this.nodes = nodes;
        }

        public void createSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords, SchemaRule rule) {
            this.writer.createSchema(beforeRecords, afterRecords, rule);
        }

        public void propertyKey(int id, String key) {
            this.writer.propertyKey(id, key, id + 1);
        }

        public void nodeLabel(int id, String name) {
            this.writer.label(id, name, id + 1);
        }

        public void relationshipType(int id, String relationshipType) {
            this.writer.relationshipType(id, relationshipType, id + 1);
        }

        public void update(NeoStoreRecord before, NeoStoreRecord after) {
            this.writer.update(before, after);
        }

        public void create(NodeRecord node) {
            this.updateCounts(node, 1);
            this.writer.create(node);
        }

        public void update(NodeRecord before, NodeRecord after) {
            this.updateCounts(before, -1);
            this.updateCounts(after, 1);
            this.writer.update(before, after);
        }

        public void delete(NodeRecord node) {
            this.updateCounts(node, -1);
            this.writer.delete(node);
        }

        public void create(RelationshipRecord relationship) {
            this.writer.create(relationship);
        }

        public void update(RelationshipRecord before, RelationshipRecord after) {
            this.writer.update(before, after);
        }

        public void delete(RelationshipRecord relationship) {
            this.writer.delete(relationship);
        }

        public void create(RelationshipGroupRecord group) {
            this.writer.create(group);
        }

        public void update(RelationshipGroupRecord before, RelationshipGroupRecord after) {
            this.writer.update(before, after);
        }

        public void delete(RelationshipGroupRecord group) {
            this.writer.delete(group);
        }

        public void create(PropertyRecord property) {
            this.writer.create(property);
        }

        public void update(PropertyRecord before, PropertyRecord property) {
            this.writer.update(before, property);
        }

        public void delete(PropertyRecord before, PropertyRecord property) {
            this.writer.delete(before, property);
        }

        private void updateCounts(NodeRecord node, int delta) {
            this.writer.incrementNodeCount(-1, delta);
            for (long label : NodeLabelsField.parseLabelsField((NodeRecord)node).get(this.nodes)) {
                this.writer.incrementNodeCount((int)label, delta);
            }
        }

        public void incrementNodeCount(int labelId, long delta) {
            this.writer.incrementNodeCount(labelId, delta);
        }

        public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
            this.writer.incrementRelationshipCount(startLabelId, typeId, endLabelId, delta);
        }
    }

    public class IdGenerator {
        public long schema() {
            return GraphStoreFixture.this.schemaId++;
        }

        public long node() {
            return GraphStoreFixture.this.nodeId++;
        }

        public int label() {
            return GraphStoreFixture.this.labelId++;
        }

        public long nodeLabel() {
            return GraphStoreFixture.this.nodeLabelsId++;
        }

        public long relationship() {
            return GraphStoreFixture.this.relId++;
        }

        public long relationshipGroup() {
            return GraphStoreFixture.this.relGroupId++;
        }

        public long property() {
            return GraphStoreFixture.this.propId++;
        }

        public long stringProperty() {
            return GraphStoreFixture.this.stringPropId++;
        }

        public long arrayProperty() {
            return GraphStoreFixture.this.arrayPropId++;
        }

        public int relationshipType() {
            return GraphStoreFixture.this.relTypeId++;
        }

        public int propertyKey() {
            return GraphStoreFixture.this.propKeyId++;
        }

        void updateCorrespondingIdGenerators(NeoStores neoStores) {
            neoStores.getNodeStore().setHighestPossibleIdInUse(GraphStoreFixture.this.nodeId);
            neoStores.getRelationshipStore().setHighestPossibleIdInUse(GraphStoreFixture.this.relId);
            neoStores.getRelationshipGroupStore().setHighestPossibleIdInUse(GraphStoreFixture.this.relGroupId);
        }
    }

    public static abstract class Transaction {
        final long startTimestamp = System.currentTimeMillis();

        protected abstract void transactionData(TransactionDataBuilder var1, IdGenerator var2);

        public TransactionRepresentation representation(IdGenerator idGenerator, int masterId, int authorId, long lastCommittedTx, NeoStores neoStores) {
            TransactionWriter writer = new TransactionWriter(neoStores);
            this.transactionData(new TransactionDataBuilder(writer, neoStores.getNodeStore()), idGenerator);
            idGenerator.updateCorrespondingIdGenerators(neoStores);
            return writer.representation(new byte[0], masterId, authorId, this.startTimestamp, lastCommittedTx, System.currentTimeMillis());
        }
    }
}

