/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ConsistencyCheckToolTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fs);

    @Test
    public void runsConsistencyCheck() throws Exception {
        File storeDir = this.testDirectory.directory();
        String[] args = new String[]{storeDir.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        this.runConsistencyCheckToolWith(service, args);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)storeDir), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.anyBoolean(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void consistencyCheckerLogUseSystemTimezoneIfConfigurable() throws Exception {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        try {
            ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
            Mockito.when((Object)service.runFullConsistencyCheck((File)ArgumentMatchers.any(File.class), (Config)ArgumentMatchers.any(Config.class), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.eq((boolean)false), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class))).then(invocationOnMock -> {
                LogProvider provider = (LogProvider)invocationOnMock.getArgument(3);
                provider.getLog("test").info("testMessage");
                return ConsistencyCheckService.Result.success((File)new File(""));
            });
            File storeDir = this.testDirectory.directory();
            File configFile = this.testDirectory.file("neo4j.conf");
            Properties properties = new Properties();
            properties.setProperty(GraphDatabaseSettings.db_timezone.name(), LogTimeZone.SYSTEM.name());
            properties.store(new FileWriter(configFile), null);
            String[] args = new String[]{storeDir.getPath(), "-config", configFile.getPath()};
            this.checkLogRecordTimeZone(service, args, 5, "+0500");
            this.checkLogRecordTimeZone(service, args, -5, "-0500");
        }
        finally {
            TimeZone.setDefault(defaultTimeZone);
        }
    }

    @Test
    public void appliesDefaultTuningConfigurationForConsistencyChecker() throws Exception {
        File storeDir = this.testDirectory.directory();
        String[] args = new String[]{storeDir.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        this.runConsistencyCheckToolWith(service, args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)storeDir), (Config)config.capture(), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.anyBoolean(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
        Assert.assertFalse((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void passesOnConfigurationIfProvided() throws Exception {
        File storeDir = this.testDirectory.directory();
        File configFile = this.testDirectory.file("neo4j.conf");
        Properties properties = new Properties();
        properties.setProperty(ConsistencyCheckSettings.consistency_check_property_owners.name(), "true");
        properties.store(new FileWriter(configFile), null);
        String[] args = new String[]{storeDir.getPath(), "-config", configFile.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        this.runConsistencyCheckToolWith(service, args);
        ArgumentCaptor config = ArgumentCaptor.forClass(Config.class);
        ((ConsistencyCheckService)Mockito.verify((Object)service)).runFullConsistencyCheck((File)ArgumentMatchers.eq((Object)storeDir), (Config)config.capture(), (ProgressMonitorFactory)ArgumentMatchers.any(ProgressMonitorFactory.class), (LogProvider)ArgumentMatchers.any(LogProvider.class), (FileSystemAbstraction)ArgumentMatchers.any(FileSystemAbstraction.class), ArgumentMatchers.anyBoolean(), (ConsistencyFlags)ArgumentMatchers.any(ConsistencyFlags.class));
        Assert.assertTrue((boolean)((Boolean)((Config)config.getValue()).get(ConsistencyCheckSettings.consistency_check_property_owners)));
    }

    @Test
    public void exitWithFailureIndicatingCorrectUsageIfNoArgumentsSupplied() throws Exception {
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        String[] args = new String[]{};
        try {
            this.runConsistencyCheckToolWith(service, args);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConsistencyCheckTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"USAGE:"));
        }
    }

    @Test
    public void exitWithFailureIfConfigSpecifiedButConfigFileDoesNotExist() throws Exception {
        File configFile = this.testDirectory.file("nonexistent_file");
        String[] args = new String[]{this.testDirectory.directory().getPath(), "-config", configFile.getPath()};
        ConsistencyCheckService service = (ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class);
        try {
            this.runConsistencyCheckToolWith(service, args);
            Assert.fail((String)"should have thrown exception");
        }
        catch (ConsistencyCheckTool.ToolFailureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Could not read configuration file"));
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(IOException.class));
        }
        Mockito.verifyZeroInteractions((Object[])new Object[]{service});
    }

    @Test(expected=ConsistencyCheckTool.ToolFailureException.class)
    public void failWhenStoreWasNonCleanlyShutdown() throws Exception {
        this.createGraphDbAndKillIt(Config.defaults());
        this.runConsistencyCheckToolWith(this.fs.get(), this.testDirectory.graphDbDir().getAbsolutePath());
    }

    @Test(expected=ConsistencyCheckTool.ToolFailureException.class)
    public void failOnNotCleanlyShutdownStoreWithLogsInCustomRelativeLocation() throws Exception {
        File customConfigFile = this.testDirectory.file("customConfig");
        Config customConfig = Config.defaults((Setting)GraphDatabaseSettings.logical_logs_location, (String)"otherLocation");
        this.createGraphDbAndKillIt(customConfig);
        MapUtil.store((Map)customConfig.getRaw(), (File)customConfigFile);
        String[] args = new String[]{this.testDirectory.graphDbDir().getPath(), "-config", customConfigFile.getPath()};
        this.runConsistencyCheckToolWith(this.fs.get(), args);
    }

    @Test(expected=ConsistencyCheckTool.ToolFailureException.class)
    public void failOnNotCleanlyShutdownStoreWithLogsInCustomAbsoluteLocation() throws Exception {
        File customConfigFile = this.testDirectory.file("customConfig");
        File otherLocation = this.testDirectory.directory("otherLocation");
        Config customConfig = Config.defaults((Setting)GraphDatabaseSettings.logical_logs_location, (String)otherLocation.getAbsolutePath());
        this.createGraphDbAndKillIt(customConfig);
        MapUtil.store((Map)customConfig.getRaw(), (File)customConfigFile);
        String[] args = new String[]{this.testDirectory.graphDbDir().getPath(), "-config", customConfigFile.getPath()};
        this.runConsistencyCheckToolWith(this.fs.get(), args);
    }

    private void checkLogRecordTimeZone(ConsistencyCheckService service, String[] args, int hoursShift, String timeZoneSuffix) throws ConsistencyCheckTool.ToolFailureException, IOException {
        TimeZone.setDefault(TimeZone.getTimeZone(ZoneOffset.ofHours(hoursShift)));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        this.runConsistencyCheckToolWith(service, printStream, args);
        String logLine = this.readLogLine(outputStream);
        Assert.assertTrue((String)logLine, (boolean)logLine.contains(timeZoneSuffix));
    }

    private String readLogLine(ByteArrayOutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        return bufferedReader.readLine();
    }

    private void createGraphDbAndKillIt(Config config) throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(config.getRaw()).newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{Label.label((String)"FOO")});
            db.createNode(new Label[]{Label.label((String)"BAR")});
            tx.success();
        }
        this.fs.snapshot(() -> ((GraphDatabaseService)db).shutdown());
    }

    private void runConsistencyCheckToolWith(FileSystemAbstraction fileSystem, String ... args) throws ConsistencyCheckTool.ToolFailureException {
        new ConsistencyCheckTool((ConsistencyCheckService)Mockito.mock(ConsistencyCheckService.class), fileSystem, (PrintStream)Mockito.mock(PrintStream.class), (PrintStream)Mockito.mock(PrintStream.class)).run(args);
    }

    private void runConsistencyCheckToolWith(ConsistencyCheckService consistencyCheckService, String ... args) throws ConsistencyCheckTool.ToolFailureException, IOException {
        this.runConsistencyCheckToolWith(consistencyCheckService, (PrintStream)Mockito.mock(PrintStream.class), args);
    }

    private void runConsistencyCheckToolWith(ConsistencyCheckService consistencyCheckService, PrintStream printStream, String ... args) throws ConsistencyCheckTool.ToolFailureException, IOException {
        try (DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();){
            new ConsistencyCheckTool(consistencyCheckService, (FileSystemAbstraction)fileSystemAbstraction, printStream, printStream).run(args);
        }
    }
}

