/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.Property;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class ConsistencyCheckServiceIntegrationTest {
    private final GraphStoreFixture fixture = new GraphStoreFixture(this.getRecordFormatName()){

        @Override
        protected void generateInitialData(GraphDatabaseService graphDb) {
            try (Transaction tx = graphDb.beginTx();){
                Node node1 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[0]);
                Node node2 = (Node)Property.set((PropertyContainer)graphDb.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"exampleValue")});
                node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                tx.success();
            }
        }
    };
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final RuleChain chain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fixture);

    @Test
    public void reportNotUsedRelationshipReferencedInChain() throws Exception {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.defaults(this.settings(new String[0]));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertFalse((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        Assert.assertTrue((String)"Consistency check report file should be generated.", (boolean)reportFile.exists());
        Assert.assertThat((String)"Expected to see report about not deleted relationship record present as part of a chain", (Object)Files.readAllLines(reportFile.toPath()).toString(), (Matcher)Matchers.containsString((String)"The relationship record is not in use, but referenced from relationships chain."));
    }

    @Test
    public void shouldSucceedIfStoreIsConsistent() throws Exception {
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.defaults(this.settings(new String[0]));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertTrue((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        Assert.assertFalse((String)("Unexpected generation of consistency check report file: " + reportFile), (boolean)reportFile.exists());
    }

    @Test
    public void shouldFailIfTheStoreInNotConsistent() throws Exception {
        this.breakNodeStore();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        String logsDir = this.testDirectory.directory().getPath();
        Config configuration = Config.defaults(this.settings(GraphDatabaseSettings.logs_directory.name(), logsDir));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertFalse((boolean)result.isSuccessful());
        String reportFile = String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(timestamp));
        Assert.assertEquals((Object)new File(logsDir, reportFile), (Object)result.reportFile());
        Assert.assertTrue((String)"Inconsistency report file not generated", (boolean)result.reportFile().exists());
    }

    @Test
    public void shouldNotReportDuplicateForHugeLongValues() throws Exception {
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings(new String[0]));
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(GraphDatabaseSettings.record_format, this.getRecordFormatName()).setConfig("dbms.backup.enabled", "false").newGraphDatabase();
        String propertyKey = "itemId";
        Label label = Label.label((String)"Item");
        try (Transaction tx = db.beginTx();){
            db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
        tx = db.beginTx();
        var7_7 = null;
        try {
            Property.set((PropertyContainer)db.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596880L)});
            Property.set((PropertyContainer)db.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596864L)});
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    public void shouldAllowGraphCheckDisabled() throws ConsistencyCheckIncompleteException {
        GraphDatabaseService gds = this.getGraphDatabaseService();
        try (Transaction tx = gds.beginTx();){
            gds.createNode();
            tx.success();
        }
        gds.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings(ConsistencyCheckSettings.consistency_check_graph.name(), "false"));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    public void shouldReportMissingSchemaIndex() throws Exception {
        File storeDir = this.testDirectory.absolutePath();
        GraphDatabaseService gds = this.getGraphDatabaseService(storeDir);
        Label label = Label.label((String)"label");
        String propKey = "propKey";
        ConsistencyCheckServiceIntegrationTest.createIndex(gds, label, propKey);
        gds.shutdown();
        File schemaDir = ConsistencyCheckServiceIntegrationTest.findFile("schema", storeDir);
        FileUtils.deleteRecursively((File)schemaDir);
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings(new String[0]));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration, storeDir);
        Assert.assertTrue((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        Assert.assertTrue((String)"Consistency check report file should be generated.", (boolean)reportFile.exists());
        Assert.assertThat((String)"Expected to see report about schema index not being online", (Object)Files.readAllLines(reportFile.toPath()).toString(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"schema rule"), (Matcher)Matchers.containsString((String)"not online")));
    }

    @Test
    public void oldLuceneSchemaIndexShouldBeConsideredConsistentWithFusionProvider() throws Exception {
        File storeDir = this.testDirectory.graphDbDir();
        String defaultSchemaProvider = GraphDatabaseSettings.default_schema_provider.name();
        Label label = Label.label((String)"label");
        String propKey = "propKey";
        GraphDatabaseService db = this.getGraphDatabaseService(storeDir, defaultSchemaProvider, GraphDatabaseSettings.SchemaIndex.LUCENE10.providerName());
        ConsistencyCheckServiceIntegrationTest.createIndex(db, label, propKey);
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{label}).setProperty(propKey, (Object)1);
            db.createNode(new Label[]{label}).setProperty(propKey, (Object)"string");
            tx.success();
        }
        db.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings(defaultSchemaProvider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName()));
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration, storeDir);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    private static void createIndex(GraphDatabaseService gds, Label label, String propKey) {
        IndexDefinition indexDefinition;
        try (Transaction tx = gds.beginTx();){
            indexDefinition = gds.schema().indexFor(label).on(propKey).create();
            tx.success();
        }
        tx = gds.beginTx();
        var5_4 = null;
        try {
            gds.schema().awaitIndexOnline(indexDefinition, 1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static File findFile(String targetFile, File directory) {
        File file = new File(directory, targetFile);
        if (!file.exists()) {
            Assert.fail((String)("Could not find file " + targetFile));
        }
        return file;
    }

    private GraphDatabaseService getGraphDatabaseService() {
        return this.getGraphDatabaseService(this.testDirectory.absolutePath());
    }

    private GraphDatabaseService getGraphDatabaseService(File storeDir) {
        return this.getGraphDatabaseService(storeDir, new String[0]);
    }

    private GraphDatabaseService getGraphDatabaseService(File storeDir, String ... settings) {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir);
        builder.setConfig(this.settings(settings));
        return builder.newGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDbWithDeletedRelationshipPartOfTheChain() {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(GraphDatabaseSettings.record_format, this.getRecordFormatName()).setConfig("dbms.backup.enabled", "false").newGraphDatabase();
        try {
            RelationshipType relationshipType = RelationshipType.withName((String)"testRelationshipType");
            try (Transaction tx = db.beginTx();){
                Node node1 = (Node)Property.set((PropertyContainer)db.createNode(), (Property[])new Property[0]);
                Node node2 = (Node)Property.set((PropertyContainer)db.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                tx.success();
            }
            RecordStorageEngine recordStorageEngine = (RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = recordStorageEngine.testAccessNeoStores();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
            RelationshipRecord record = (RelationshipRecord)relationshipStore.getRecord(4L, (AbstractBaseRecord)relationshipRecord, RecordLoad.FORCE);
            record.setInUse(false);
            relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord);
        }
        finally {
            db.shutdown();
        }
    }

    protected Map<String, String> settings(String ... strings) {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put(GraphDatabaseSettings.pagecache_memory.name(), "8m");
        defaults.put(GraphDatabaseSettings.record_format.name(), this.getRecordFormatName());
        defaults.put("dbms.backup.enabled", "false");
        return MapUtil.stringMap(defaults, (String[])strings);
    }

    private void breakNodeStore() throws TransactionFailureException {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node(), false, next.relationship(), -1L));
            }
        });
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(service, configuration, this.fixture.directory());
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration, File storeDir) throws ConsistencyCheckIncompleteException {
        return service.runFullConsistencyCheck(storeDir, configuration, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
    }

    protected String getRecordFormatName() {
        return "";
    }
}

