/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.consistency.repair.RelationshipChainExplorer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RelationshipChainExplorerTest {
    private static final int degreeTwoNodes = 10;
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fileSystemRule);
    private StoreAccess store;

    @Before
    public void setupStoreAccess() {
        this.store = this.createStoreWithOneHighDegreeNodeAndSeveralDegreeTwoNodes(10);
    }

    @After
    public void tearDownStoreAccess() {
        this.store.close();
    }

    @Test
    public void shouldLoadAllConnectedRelationshipRecordsAndTheirFullChainsOfRelationshipRecords() {
        RecordStore relationshipStore = this.store.getRelationshipStore();
        int relationshipIdInMiddleOfChain = 10;
        RecordSet records = new RelationshipChainExplorer(relationshipStore).exploreRelationshipRecordChainsToDepthTwo((RelationshipRecord)relationshipStore.getRecord((long)relationshipIdInMiddleOfChain, relationshipStore.newRecord(), RecordLoad.NORMAL));
        Assert.assertEquals((long)20L, (long)records.size());
    }

    @Test
    public void shouldCopeWithAChainThatReferencesNotInUseZeroValueRecords() {
        RecordStore relationshipStore = this.store.getRelationshipStore();
        RelationshipChainExplorerTest.breakTheChain((RecordStore<RelationshipRecord>)relationshipStore);
        int relationshipIdInMiddleOfChain = 10;
        RecordSet records = new RelationshipChainExplorer(relationshipStore).exploreRelationshipRecordChainsToDepthTwo((RelationshipRecord)relationshipStore.getRecord((long)relationshipIdInMiddleOfChain, relationshipStore.newRecord(), RecordLoad.NORMAL));
        int recordsInaccessibleBecauseOfBrokenChain = 3;
        Assert.assertEquals((long)(20 - recordsInaccessibleBecauseOfBrokenChain), (long)records.size());
    }

    private static void breakTheChain(RecordStore<RelationshipRecord> relationshipStore) {
        int relationshipTowardsEndOfChain = 16;
        relationshipStore.updateRecord((AbstractBaseRecord)new RelationshipRecord((long)relationshipTowardsEndOfChain, 0L, 0L, 0));
    }

    private StoreAccess createStoreWithOneHighDegreeNodeAndSeveralDegreeTwoNodes(int nDegreeTwoNodes) {
        File storeDirectory = this.testDirectory.databaseDir();
        GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDirectory).setConfig(GraphDatabaseSettings.record_format, this.getRecordFormatName()).setConfig("dbms.backup.enabled", "false").newGraphDatabase();
        try (Transaction transaction = database.beginTx();){
            Node denseNode = database.createNode();
            for (int i = 0; i < nDegreeTwoNodes; ++i) {
                Node degreeTwoNode = database.createNode();
                Node leafNode = database.createNode();
                if (i % 2 == 0) {
                    denseNode.createRelationshipTo(degreeTwoNode, (RelationshipType)TestRelationshipType.CONNECTED);
                } else {
                    degreeTwoNode.createRelationshipTo(denseNode, (RelationshipType)TestRelationshipType.CONNECTED);
                }
                degreeTwoNode.createRelationshipTo(leafNode, (RelationshipType)TestRelationshipType.CONNECTED);
            }
            transaction.success();
        }
        database.shutdown();
        PageCache pageCache = pageCacheRule.getPageCache(this.fileSystemRule.get());
        StoreAccess storeAccess = new StoreAccess(this.fileSystemRule.get(), pageCache, this.testDirectory.databaseLayout(), Config.defaults());
        return storeAccess.initialize();
    }

    protected String getRecordFormatName() {
        return "";
    }

    static enum TestRelationshipType implements RelationshipType
    {
        CONNECTED;

    }
}

