/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public class AllNodesInStoreExistInLabelIndexTest {
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public final RandomRule random = new RandomRule();
    private final AssertableLogProvider log = new AssertableLogProvider();
    private static final Label[] LABEL_ALPHABET = new Label[]{TestLabels.LABEL_ONE, TestLabels.LABEL_TWO, TestLabels.LABEL_THREE};
    private static final Label EXTRA_LABEL = Label.label((String)"extra");
    private static final double DELETE_RATIO = 0.2;
    private static final double UPDATE_RATIO = 0.2;
    private static final int NODE_COUNT_BASELINE = 10;

    @Test
    public void mustReportSuccessfulForConsistentLabelScanStore() throws Exception {
        this.someData();
        this.db.shutdownAndKeepStore();
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertTrue((String)"Expected consistency check to succeed", (boolean)result.isSuccessful());
    }

    @Test
    public void reportNotCleanLabelIndex() throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData();
        ((CheckPointer)this.db.resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        File labelIndexFileCopy = databaseLayout.file("label_index_copy");
        FileUtils.copyFile((File)databaseLayout.labelScanStore(), (File)labelIndexFileCopy);
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
            tx.success();
        }
        this.db.shutdownAndKeepStore();
        FileUtils.copyFile((File)labelIndexFileCopy, (File)databaseLayout.labelScanStore());
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertFalse((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
        Assert.assertThat(this.readReport(result), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"WARN : Label index was not properly shutdown and rebuild is required.")));
    }

    @Test
    public void reportNotCleanLabelIndexWithCorrectData() throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData();
        ((CheckPointer)this.db.resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        File labelIndexFileCopy = databaseLayout.file("label_index_copy");
        FileUtils.copyFile((File)databaseLayout.labelScanStore(), (File)labelIndexFileCopy);
        this.db.shutdownAndKeepStore();
        FileUtils.copyFile((File)labelIndexFileCopy, (File)databaseLayout.labelScanStore());
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertTrue((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
        Assert.assertThat(this.readReport(result), (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)"WARN : Label index was not properly shutdown and rebuild is required.")));
    }

    @Test
    public void mustReportMissingNode() throws Exception {
        this.someData();
        File labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
            tx.success();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        this.db.shutdownAndKeepStore();
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertFalse((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
    }

    @Test
    public void mustReportMissingLabel() throws Exception {
        List<Pair<Long, Label[]>> nodesInStore = this.someData();
        File labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            this.addLabelToExistingNode(nodesInStore);
            tx.success();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        this.db.shutdownAndKeepStore();
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertFalse((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
    }

    @Test
    public void mustReportExtraLabelsOnExistingNode() throws Exception {
        List<Pair<Long, Label[]>> nodesInStore = this.someData();
        File labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            this.removeLabelFromExistingNode(nodesInStore);
            tx.success();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        this.db.shutdownAndKeepStore();
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertFalse((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
    }

    @Test
    public void mustReportExtraNode() throws Exception {
        List<Pair<Long, Label[]>> nodesInStore = this.someData();
        File labelIndexFileCopy = this.copyLabelIndexFile();
        try (Transaction tx = this.db.beginTx();){
            this.removeExistingNode(nodesInStore);
            tx.success();
        }
        this.replaceLabelIndexWithCopy(labelIndexFileCopy);
        this.db.shutdownAndKeepStore();
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        Assert.assertFalse((String)"Expected consistency check to fail", (boolean)result.isSuccessful());
    }

    private List<String> readReport(ConsistencyCheckService.Result result) throws IOException {
        return Files.readAllLines(result.reportFile().toPath());
    }

    private void removeExistingNode(List<Pair<Long, Label[]>> nodesInStore) {
        Node node;
        Pair<Long, Label[]> existingNode;
        Label[] labels;
        do {
            int targetIndex = this.random.nextInt(nodesInStore.size());
            existingNode = nodesInStore.get(targetIndex);
            node = this.db.getNodeById(((Long)existingNode.first()).longValue());
        } while ((labels = (Label[])existingNode.other()).length == 0);
        node.delete();
    }

    private void addLabelToExistingNode(List<Pair<Long, Label[]>> nodesInStore) {
        int targetIndex = this.random.nextInt(nodesInStore.size());
        Pair<Long, Label[]> existingNode = nodesInStore.get(targetIndex);
        Node node = this.db.getNodeById(((Long)existingNode.first()).longValue());
        node.addLabel(EXTRA_LABEL);
    }

    private void removeLabelFromExistingNode(List<Pair<Long, Label[]>> nodesInStore) {
        Node node;
        Pair<Long, Label[]> existingNode;
        do {
            int targetIndex = this.random.nextInt(nodesInStore.size());
            existingNode = nodesInStore.get(targetIndex);
            node = this.db.getNodeById(((Long)existingNode.first()).longValue());
        } while (((Label[])existingNode.other()).length == 0);
        node.removeLabel(((Label[])existingNode.other())[0]);
    }

    private void replaceLabelIndexWithCopy(File labelIndexFileCopy) throws IOException {
        this.db.restartDatabase((fs, directory) -> {
            DatabaseLayout databaseLayout = this.db.databaseLayout();
            fs.deleteFile(databaseLayout.labelScanStore());
            fs.copyFile(labelIndexFileCopy, databaseLayout.labelScanStore());
        }, new String[0]);
    }

    private File copyLabelIndexFile() throws IOException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        File labelIndexFileCopy = databaseLayout.file("label_index_copy");
        this.db.restartDatabase((fs, directory) -> fs.copyFile(databaseLayout.labelScanStore(), labelIndexFileCopy), new String[0]);
        return labelIndexFileCopy;
    }

    private List<Pair<Long, Label[]>> someData() {
        return this.someData(50);
    }

    private List<Pair<Long, Label[]>> someData(int numberOfModifications) {
        ArrayList<Pair<Long, Label[]>> existingNodes = new ArrayList<Pair<Long, Label[]>>();
        try (Transaction tx = this.db.beginTx();){
            this.randomModifications(existingNodes, numberOfModifications);
            tx.success();
        }
        return existingNodes;
    }

    private void randomModifications(List<Pair<Long, Label[]>> existingNodes, int numberOfModifications) {
        for (int i = 0; i < numberOfModifications; ++i) {
            double selectModification = this.random.nextDouble();
            if (existingNodes.size() < 10 || selectModification >= 0.4) {
                this.createNewNode(existingNodes);
                continue;
            }
            if (selectModification < 0.2) {
                this.deleteExistingNode(existingNodes);
                continue;
            }
            this.modifyLabelsOnExistingNode(existingNodes);
        }
    }

    private void createNewNode(List<Pair<Long, Label[]>> existingNodes) {
        Label[] labels = this.randomLabels();
        Node node = this.db.createNode(labels);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)node.getId(), (Object)labels));
    }

    private void modifyLabelsOnExistingNode(List<Pair<Long, Label[]>> existingNodes) {
        Label[] newLabels;
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        long nodeId = (Long)existingPair.first();
        Node node = this.db.getNodeById(nodeId);
        node.getLabels().forEach(arg_0 -> ((Node)node).removeLabel(arg_0));
        for (Label label : newLabels = this.randomLabels()) {
            node.addLabel(label);
        }
        existingNodes.remove(targetIndex);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)nodeId, (Object)newLabels));
    }

    private void deleteExistingNode(List<Pair<Long, Label[]>> existingNodes) {
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        Node node = this.db.getNodeById(((Long)existingPair.first()).longValue());
        node.delete();
        existingNodes.remove(targetIndex);
    }

    private Label[] randomLabels() {
        ArrayList<Label> labels = new ArrayList<Label>(3);
        for (Label label : LABEL_ALPHABET) {
            if (!this.random.nextBoolean()) continue;
            labels.add(label);
        }
        return labels.toArray(new Label[labels.size()]);
    }

    private ConsistencyCheckService.Result fullConsistencyCheck() throws ConsistencyCheckIncompleteException, IOException {
        try (DefaultFileSystemAbstraction fsa = new DefaultFileSystemAbstraction();){
            ConsistencyCheckService service = new ConsistencyCheckService();
            Config config = Config.defaults();
            ConsistencyCheckService.Result result = service.runFullConsistencyCheck(this.db.databaseLayout(), config, ProgressMonitorFactory.NONE, (LogProvider)this.log, (FileSystemAbstraction)fsa, true, new ConsistencyFlags(config));
            return result;
        }
    }
}

