/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class TransactionWriter {
    private final NeoStores neoStores;
    private final List<Command.NodeCommand> nodeCommands = new ArrayList<Command.NodeCommand>();
    private final List<Command.RelationshipCommand> relationshipCommands = new ArrayList<Command.RelationshipCommand>();
    private final List<Command.RelationshipGroupCommand> relationshipGroupCommands = new ArrayList<Command.RelationshipGroupCommand>();
    private final List<Command> otherCommands = new ArrayList<Command>();

    public TransactionWriter(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    public TransactionRepresentation representation(byte[] additionalHeader, int masterId, int authorId, long startTime, long lastCommittedTx, long committedTime) {
        this.prepareForCommit();
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(this.allCommands());
        representation.setHeader(additionalHeader, masterId, authorId, startTime, lastCommittedTx, committedTime, -1);
        return representation;
    }

    public void propertyKey(int id, String key, int ... dynamicIds) {
        PropertyKeyTokenRecord before = new PropertyKeyTokenRecord(id);
        PropertyKeyTokenRecord after = TransactionWriter.withName(new PropertyKeyTokenRecord(id), dynamicIds, key);
        this.otherCommands.add((Command)new Command.PropertyKeyTokenCommand(before, after));
    }

    public void label(int id, String name, int ... dynamicIds) {
        LabelTokenRecord before = new LabelTokenRecord((long)id);
        LabelTokenRecord after = TransactionWriter.withName(new LabelTokenRecord((long)id), dynamicIds, name);
        this.otherCommands.add((Command)new Command.LabelTokenCommand(before, after));
    }

    public void relationshipType(int id, String label, int ... dynamicIds) {
        RelationshipTypeTokenRecord before = new RelationshipTypeTokenRecord(id);
        RelationshipTypeTokenRecord after = TransactionWriter.withName(new RelationshipTypeTokenRecord(id), dynamicIds, label);
        this.otherCommands.add((Command)new Command.RelationshipTypeTokenCommand(before, after));
    }

    public void update(NeoStoreRecord before, NeoStoreRecord after) {
        this.otherCommands.add((Command)new Command.NeoStoreCommand(before, after));
    }

    public void update(LabelTokenRecord before, LabelTokenRecord after) {
        this.otherCommands.add((Command)new Command.LabelTokenCommand(before, after));
    }

    public void create(NodeRecord node) {
        node.setCreated();
        this.update(new NodeRecord(node.getId(), false, (long)Record.NO_PREV_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue()), node);
    }

    public void create(LabelTokenRecord labelToken) {
        labelToken.setCreated();
        this.update(new LabelTokenRecord((long)labelToken.getIntId()), labelToken);
    }

    public void create(PropertyKeyTokenRecord token) {
        token.setCreated();
        this.update(new PropertyKeyTokenRecord(token.getIntId()), token);
    }

    public void create(RelationshipGroupRecord group) {
        group.setCreated();
        this.update(new RelationshipGroupRecord(group.getId(), group.getType()), group);
    }

    public void update(NodeRecord before, NodeRecord node) {
        node.setInUse(true);
        this.add(before, node);
    }

    public void update(PropertyKeyTokenRecord before, PropertyKeyTokenRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(NodeRecord node) {
        node.setInUse(false);
        this.add(node, new NodeRecord(node.getId(), false, (long)Record.NO_PREV_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue()));
    }

    public void create(RelationshipRecord record) {
        record.setCreated();
        this.update(new RelationshipRecord(record.getId()), record);
    }

    public void delete(RelationshipGroupRecord group) {
        group.setInUse(false);
        this.add(group, new RelationshipGroupRecord(group.getId(), group.getType()));
    }

    public void createSchema(Collection<DynamicRecord> beforeRecord, Collection<DynamicRecord> afterRecord, SchemaRule rule) {
        for (DynamicRecord record : afterRecord) {
            record.setCreated();
        }
        this.updateSchema(beforeRecord, afterRecord, rule);
    }

    public void updateSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords, SchemaRule rule) {
        for (DynamicRecord record : afterRecords) {
            record.setInUse(true);
        }
        this.addSchema(beforeRecords, afterRecords, rule);
    }

    public void update(RelationshipRecord before, RelationshipRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void update(RelationshipGroupRecord before, RelationshipGroupRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(RelationshipRecord record) {
        record.setInUse(false);
        this.add(record, new RelationshipRecord(record.getId()));
    }

    public void create(PropertyRecord property) {
        property.setCreated();
        PropertyRecord before = new PropertyRecord(property.getId());
        if (property.isNodeSet()) {
            before.setNodeId(property.getNodeId());
        }
        if (property.isRelSet()) {
            before.setRelId(property.getRelId());
        }
        this.update(before, property);
    }

    public void update(PropertyRecord before, PropertyRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(PropertyRecord before, PropertyRecord after) {
        after.setInUse(false);
        this.add(before, after);
    }

    private void addSchema(Collection<DynamicRecord> beforeRecords, Collection<DynamicRecord> afterRecords, SchemaRule rule) {
        this.otherCommands.add((Command)new Command.SchemaRuleCommand(beforeRecords, afterRecords, rule));
    }

    public void add(NodeRecord before, NodeRecord after) {
        this.nodeCommands.add(new Command.NodeCommand(before, after));
    }

    public void add(RelationshipRecord before, RelationshipRecord after) {
        this.relationshipCommands.add(new Command.RelationshipCommand(before, after));
    }

    public void add(RelationshipGroupRecord before, RelationshipGroupRecord after) {
        this.relationshipGroupCommands.add(new Command.RelationshipGroupCommand(before, after));
    }

    public void add(PropertyRecord before, PropertyRecord property) {
        this.otherCommands.add((Command)new Command.PropertyCommand(before, property));
    }

    public void add(RelationshipTypeTokenRecord before, RelationshipTypeTokenRecord after) {
        this.otherCommands.add((Command)new Command.RelationshipTypeTokenCommand(before, after));
    }

    public void add(PropertyKeyTokenRecord before, PropertyKeyTokenRecord after) {
        this.otherCommands.add((Command)new Command.PropertyKeyTokenCommand(before, after));
    }

    public void add(NeoStoreRecord before, NeoStoreRecord after) {
        this.otherCommands.add((Command)new Command.NeoStoreCommand(before, after));
    }

    public void incrementNodeCount(int labelId, long delta) {
        this.otherCommands.add((Command)new Command.NodeCountsCommand(labelId, delta));
    }

    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        this.otherCommands.add((Command)new Command.RelationshipCountsCommand(startLabelId, typeId, endLabelId, delta));
    }

    private static <T extends TokenRecord> T withName(T record, int[] dynamicIds, String name) {
        if (dynamicIds == null || dynamicIds.length == 0) {
            throw new IllegalArgumentException("No dynamic records for storing the name.");
        }
        record.setInUse(true);
        byte[] data = PropertyStore.encodeString((String)name);
        if (data.length > dynamicIds.length * 30) {
            throw new IllegalArgumentException(String.format("[%s] is too long to fit in %d blocks", name, dynamicIds.length));
        }
        if (data.length <= (dynamicIds.length - 1) * 30) {
            throw new IllegalArgumentException(String.format("[%s] is to short to fill %d blocks", name, dynamicIds.length));
        }
        for (int i = 0; i < dynamicIds.length; ++i) {
            byte[] part = new byte[Math.min(30, data.length - i * 30)];
            System.arraycopy(data, i * 30, part, 0, part.length);
            DynamicRecord dynamicRecord = new DynamicRecord((long)dynamicIds[i]);
            dynamicRecord.setInUse(true);
            dynamicRecord.setData(part);
            dynamicRecord.setCreated();
            record.addNameRecord(dynamicRecord);
        }
        record.setNameId(dynamicIds[0]);
        return record;
    }

    private void prepareForCommit() {
        for (Command.NodeCommand nodeCommand : this.nodeCommands) {
            this.neoStores.getNodeStore().prepareForCommit(nodeCommand.getAfter());
        }
        for (Command.RelationshipCommand relationshipCommand : this.relationshipCommands) {
            this.neoStores.getRelationshipStore().prepareForCommit(relationshipCommand.getAfter());
        }
        for (Command.RelationshipGroupCommand relationshipGroupCommand : this.relationshipGroupCommands) {
            this.neoStores.getRelationshipGroupStore().prepareForCommit(relationshipGroupCommand.getAfter());
        }
    }

    private List<StorageCommand> allCommands() {
        ArrayList<StorageCommand> allCommands = new ArrayList<StorageCommand>();
        allCommands.addAll(this.nodeCommands);
        allCommands.addAll(this.relationshipCommands);
        allCommands.addAll(this.relationshipGroupCommands);
        allCommands.addAll(this.otherCommands);
        return allCommands;
    }
}

