/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.Race;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;

public class LabelScanStoreTxApplyRaceIT {
    private static final int NUMBER_OF_DELETORS = 2;
    private static final int NUMBER_OF_CREATORS = Integer.max(2, Runtime.getRuntime().availableProcessors() - 2);
    private static final float CHANCE_LARGE_TX = 0.1f;
    private static final float CHANCE_TO_DELETE_BY_SAME_THREAD = 0.9f;
    private static final int LARGE_TX_SIZE = 3000;
    private static final Label[] LABELS = TestLabels.values();
    @Rule
    public final EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void shouldStressIt() throws Throwable {
        Race race = new Race().withMaxDuration(5L, TimeUnit.SECONDS);
        AtomicReferenceArray<Node> nodeHeads = new AtomicReferenceArray<Node>(NUMBER_OF_CREATORS);
        for (int i = 0; i < NUMBER_OF_CREATORS; ++i) {
            race.addContestant(this.creator(nodeHeads, i));
        }
        race.addContestants(2, this.deleter(nodeHeads));
        race.go();
        DatabaseLayout dbLayout = this.db.databaseLayout();
        this.db.shutdownAndKeepStore();
        Assert.assertTrue((boolean)new ConsistencyCheckService().runFullConsistencyCheck(dbLayout, Config.defaults(), ProgressMonitorFactory.NONE, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), false, new ConsistencyFlags(true, true, true, true, false)).isSuccessful());
    }

    private Runnable creator(final AtomicReferenceArray<Node> nodeHeads, final int guy) {
        return new Runnable(){
            private final ThreadLocalRandom random = ThreadLocalRandom.current();

            @Override
            public void run() {
                Node node;
                if (this.random.nextFloat() < 0.1f) {
                    try (Transaction tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();){
                        for (int i = 0; i < 3000; ++i) {
                            LabelScanStoreTxApplyRaceIT.this.db.createNode(this.randomLabels()).setProperty("name", (Object)UUID.randomUUID().toString());
                        }
                        tx.success();
                    }
                }
                try (Transaction tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();){
                    node = LabelScanStoreTxApplyRaceIT.this.db.createNode(this.randomLabels());
                    nodeHeads.set(guy, node);
                    tx.success();
                }
                if (this.random.nextFloat() < 0.9f && nodeHeads.getAndSet(guy, null) != null) {
                    tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();
                    var3_8 = null;
                    try {
                        node.delete();
                        tx.success();
                    }
                    catch (Throwable throwable) {
                        var3_8 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (tx != null) {
                            if (var3_8 != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable) {
                                    var3_8.addSuppressed(throwable);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
            }

            private Label[] randomLabels() {
                Label[] labels = new Label[LABELS.length];
                int cursor = 0;
                for (int i = 0; i < labels.length; ++i) {
                    if (!this.random.nextBoolean()) continue;
                    labels[cursor++] = LABELS[i];
                }
                if (cursor == 0) {
                    labels[cursor++] = LABELS[0];
                }
                return Arrays.copyOf(labels, cursor);
            }
        };
    }

    private Runnable deleter(final AtomicReferenceArray<Node> nodeHeads) {
        return new Runnable(){
            ThreadLocalRandom random = ThreadLocalRandom.current();

            @Override
            public void run() {
                int guy = this.random.nextInt(NUMBER_OF_CREATORS);
                Node node = nodeHeads.getAndSet(guy, null);
                if (node != null) {
                    try (Transaction tx = LabelScanStoreTxApplyRaceIT.this.db.beginTx();){
                        node.delete();
                        tx.success();
                    }
                    catch (NotFoundException notFoundException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

