/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bouncycastle.util.Arrays;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBootstrapper;
import org.neo4j.index.internal.gbptree.GBPTreeCorruption;
import org.neo4j.index.internal.gbptree.GBPTreeInspection;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.InspectingVisitor;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.SchemaLayouts;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

public class ConsistencyCheckWithCorruptGBPTreeIT {
    private static final Label label = Label.label((String)"label");
    private static final String propKey1 = "key1";
    private PageCacheRule pageCacheRule = new PageCacheRule();
    private TestDirectory testDirectory = TestDirectory.testDirectory();
    private RandomRule random = new RandomRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.pageCacheRule).around((TestRule)this.random);

    @Test
    public void assertTreeHeightIsAsExpected() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject heightRef = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> heightRef.setValue((Object)inspection.getLastLevel()), indexFiles);
        int height = (Integer)heightRef.getValue();
        Assert.assertEquals((String)("This test assumes height of index tree is 2 but height for this index was " + height + ". This is most easily regulated by changing number of nodes in setup."), (long)2L, (long)height);
    }

    @Test
    public void shouldNotCheckIndexesIfConfiguredNotTo() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        Config config = ConsistencyCheckWithCorruptGBPTreeIT.config("false", "false");
        ConsistencyCheckService.Result result = this.runConsistencyCheck(config);
        Assert.assertTrue((String)"Expected store to be consistent when not checking indexes.", (boolean)result.isSuccessful());
    }

    @Test
    public void shouldCheckIndexStructureEvenIfNotCheckingIndexes() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        Config config = ConsistencyCheckWithCorruptGBPTreeIT.config("true", "false");
        ConsistencyCheckService.Result result = this.runConsistencyCheck(config);
        Assert.assertFalse((String)"Expected store to be inconsistent when checking index structure.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Page: " + targetNode.getValue() + " is not a tree node page");
    }

    @Test
    public void shouldNotCheckIndexStructureIfConfiguredNotToEvenIfCheckingIndexes() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.addFreelistEntry((long)5L));
        }, indexFiles);
        Config config = ConsistencyCheckWithCorruptGBPTreeIT.config("false", "true");
        ConsistencyCheckService.Result result = this.runConsistencyCheck(config);
        Assert.assertTrue((String)"Expected store to be consistent when not checking indexes.", (boolean)result.isSuccessful());
    }

    @Test
    public void shouldReportProgress() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        StringWriter writer = new StringWriter();
        ProgressMonitorFactory factory = ProgressMonitorFactory.textual((Writer)writer);
        ConsistencyCheckService.Result result = this.runConsistencyCheck(factory);
        Assert.assertTrue((String)"Expected new database to be clean.", (boolean)result.isSuccessful());
        Assert.assertTrue((boolean)((Object)writer).toString().contains("Index structure consistency check"));
    }

    @Test
    public void notATreeNode() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Page: " + targetNode.getValue() + " is not a tree node page.");
    }

    @Test
    public void unknownTreeNodeType() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.unknownTreeNodeType()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Page: " + targetNode.getValue() + " has an unknown tree node type:");
    }

    @Test
    public void siblingsDontPointToEachOther() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getLeafNodes().get(0));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointToNonExisting()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Sibling pointers misaligned.");
    }

    @Test
    public void rightmostNodeHasRightSibling() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long root = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)root, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setPointer((GBPTreePointerType)GBPTreePointerType.rightSibling(), (long)10L)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Expected rightmost node to have no right sibling but was 10");
    }

    @Test
    public void pointerToOldVersionOfTreeNode() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setPointer((GBPTreePointerType)GBPTreePointerType.successor(), (long)6L)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "We ended up on tree node " + targetNode.getValue() + " which has a newer generation, successor is: 6");
    }

    @Test
    public void pointerHasLowerGenerationThanNode() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        MutableObject rightSibling = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            ImmutableLongList leafNodes = inspection.getLeafNodes();
            targetNode.setValue((Object)leafNodes.get(0));
            rightSibling.setValue((Object)leafNodes.get(1));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointerHasTooLowGeneration()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, String.format("Pointer (%s) in tree node %d has pointer generation %d, but target node %d has a higher generation %d.", GBPTreePointerType.rightSibling(), targetNode.getValue(), 1, rightSibling.getValue(), 4));
    }

    @Test
    public void keysOutOfOrderInNode() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getLeafNodes().get(0));
            int keyCount = (Integer)inspection.getKeyCounts().get(targetNode.getValue());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.swapKeyOrderLeaf((int)0, (int)1, (int)keyCount)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, String.format("Keys in tree node %d are out of order.", targetNode.getValue()));
    }

    @Test
    public void keysLocatedInWrongNode() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long internalNode = ((ImmutableLongList)inspection.getNodesPerLevel().get(1)).get(0);
            int keyCount = (Integer)inspection.getKeyCounts().get(internalNode);
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)internalNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.swapChildOrder((int)0, (int)1, (int)keyCount)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Expected range for this tree node is");
    }

    @Test
    public void unusedPage() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            Long internalNode = ((ImmutableLongList)inspection.getNodesPerLevel().get(1)).get(0);
            int keyCount = (Integer)inspection.getKeyCounts().get(internalNode);
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)internalNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setKeyCount((int)(keyCount - 1))));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index has a leaked page that will never be reclaimed, pageId=");
    }

    @Test
    public void pageIdExceedLastId() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.decrementFreelistWritePos()), indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index has a leaked page that will never be reclaimed, pageId=");
    }

    @Test
    public void nodeMetaInconsistency() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)inspection.getRootNode(), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.decrementAllocOffsetInDynamicNode())), indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "has inconsistent meta data: Meta data for tree node is inconsistent");
    }

    @Test
    public void pageIdSeenMultipleTimes() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.addFreelistEntry((long)((Long)targetNode.getValue())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Page id seen multiple times, this means either active tree node is present in freelist or pointers in tree create a loop, pageId=" + targetNode.getValue());
    }

    @Test
    public void crashPointer() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(false, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.crashed((GBPTreePointerType)GBPTreePointerType.rightSibling())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Crashed pointer found in tree node " + targetNode.getValue());
    }

    @Test
    public void brokenPointer() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Broken pointer found in tree node " + targetNode.getValue());
    }

    @Test
    public void unreasonableKeyCount() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setKeyCount((int)Integer.MAX_VALUE)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Unexpected keyCount on pageId " + targetNode.getValue() + ", keyCount=" + Integer.MAX_VALUE);
    }

    @Test
    public void childNodeFoundAmongParentNodes() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long rootNode = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)rootNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setChild((int)0, (long)rootNode)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Circular reference, child tree node found among parent nodes. Parents:");
    }

    @Test
    public void exception() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long rootNode = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)rootNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setHighestReasonableKeyCount()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Caught exception during consistency check: org.neo4j.index.internal.gbptree.TreeInconsistencyException: Some internal problem causing out of bounds: pageId:");
    }

    @Test
    public void shouldIncludeIndexFileInConsistencyReport() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        File[] indexFiles = this.schemaIndexFiles();
        List<File> corruptedFiles = this.corruptIndexes(true, (tree, inspection) -> {
            long rootNode = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)rootNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((String)"Expected store to be considered inconsistent.", (boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index file: " + corruptedFiles.get(0).getAbsolutePath());
    }

    @Test
    public void multipleCorruptions() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject internalNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long leafNode = inspection.getLeafNodes().get(0);
            internalNode.setValue((Object)((ImmutableLongList)inspection.getNodesPerLevel().get(1)).get(1));
            Integer internalNodeKeyCount = (Integer)inspection.getKeyCounts().get(internalNode.getValue());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)leafNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointToNonExisting()));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)internalNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.swapChildOrder((int)0, (int)1, (int)internalNodeKeyCount)));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)internalNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        this.assertResultContainsMessage(result, "Index inconsistency: Sibling pointers misaligned.");
        this.assertResultContainsMessage(result, "Index inconsistency: Expected range for this tree node is");
        this.assertResultContainsMessage(result, "Index inconsistency: Broken pointer found in tree node " + internalNode.getValue() + ", pointerType='left sibling'");
        this.assertResultContainsMessage(result, "Index inconsistency: Pointer (left sibling) in tree node " + internalNode.getValue() + " has pointer generation 0, but target node 0 has a higher generation 4.");
    }

    @Test
    public void multipleCorruptionsInLabelScanStore() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
        MutableObject rootNode = new MutableObject();
        File labelScanStoreFile = this.labelScanStoreFile();
        this.corruptIndexes(true, (tree, inspection) -> {
            rootNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)rootNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, labelScanStoreFile);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        Assert.assertFalse((boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index inconsistency: Broken pointer found in tree node " + rootNode.getValue() + ", pointerType='left sibling'");
        this.assertResultContainsMessage(result, "Number of inconsistent LABEL_SCAN_DOCUMENT records: 1");
    }

    @Test
    public void multipleCorruptionsInFusionIndex() throws Exception {
        this.setup(GraphDatabaseSettings.SchemaIndex.NATIVE20, db -> {
            try (Transaction tx = db.beginTx();){
                for (int i = 0; i < 1000; ++i) {
                    Node node = db.createNode(new Label[]{label});
                    node.setProperty(propKey1, (Object)i);
                    Node secondNode = db.createNode(new Label[]{label});
                    secondNode.setProperty(propKey1, (Object)LocalDate.ofEpochDay(i));
                }
                tx.success();
            }
        });
        File[] indexFiles = this.schemaIndexFiles();
        List<File> files = this.corruptIndexes(true, (tree, inspection) -> {
            long leafNode = inspection.getLeafNodes().get(1);
            long internalNode = inspection.getInternalNodes().get(0);
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)leafNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointToNonExisting()));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)internalNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setChild((int)0, (long)internalNode)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck();
        for (File file : files) {
            this.assertResultContainsMessage(result, "Index file: " + file.getAbsolutePath());
        }
    }

    private void assertResultContainsMessage(ConsistencyCheckService.Result result, String expectedMessage) throws IOException {
        List<String> lines = Files.readAllLines(result.reportFile().toPath());
        boolean reportContainExpectedMessage = false;
        for (String line : lines) {
            if (!line.contains(expectedMessage)) continue;
            reportContainExpectedMessage = true;
            break;
        }
        String errorMessage = String.format("Expected consistency report to contain message `%s'. Real result was: %s%n", expectedMessage, String.join((CharSequence)System.lineSeparator(), lines));
        Assert.assertTrue((String)errorMessage, (boolean)reportContainExpectedMessage);
    }

    private ConsistencyCheckService.Result runConsistencyCheck() throws ConsistencyCheckIncompleteException {
        return this.runConsistencyCheck(ConsistencyCheckWithCorruptGBPTreeIT.config("true", "true"));
    }

    private ConsistencyCheckService.Result runConsistencyCheck(Config config) throws ConsistencyCheckIncompleteException {
        return this.runConsistencyCheck(ProgressMonitorFactory.NONE, config);
    }

    private ConsistencyCheckService.Result runConsistencyCheck(ProgressMonitorFactory progressFactory) throws ConsistencyCheckIncompleteException {
        return this.runConsistencyCheck(progressFactory, ConsistencyCheckWithCorruptGBPTreeIT.config("true", "true"));
    }

    private ConsistencyCheckService.Result runConsistencyCheck(ProgressMonitorFactory progressFactory, Config config) throws ConsistencyCheckIncompleteException {
        ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService();
        DatabaseLayout databaseLayout = DatabaseLayout.of((File)this.testDirectory.storeDir());
        NullLogProvider logProvider = NullLogProvider.getInstance();
        return consistencyCheckService.runFullConsistencyCheck(databaseLayout, config, progressFactory, (LogProvider)logProvider, false);
    }

    private static Config config(String checkStructure, String checkIndex) {
        return Config.defaults((Map)MapUtil.stringMap((String[])new String[]{ConsistencyCheckSettings.consistency_check_index_structure.name(), checkStructure, ConsistencyCheckSettings.consistency_check_indexes.name(), checkIndex}));
    }

    private void setup(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setup(schemaIndex, db -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup(GraphDatabaseSettings.SchemaIndex schemaIndex, Consumer<GraphDatabaseService> additionalSetup) {
        File dataDir = this.testDirectory.storeLayout().storeDirectory();
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dataDir).setConfig(GraphDatabaseSettings.default_schema_provider, schemaIndex.providerName()).newGraphDatabase();
        try {
            this.createAnIndex(db);
            additionalSetup.accept(db);
        }
        finally {
            db.shutdown();
        }
    }

    private File labelScanStoreFile() {
        File dataDir = this.testDirectory.storeLayout().storeDirectory();
        return new File(dataDir, DatabaseFile.LABEL_SCAN_STORE.getName());
    }

    private File[] schemaIndexFiles() throws IOException {
        FileSystemAbstraction fs = this.testDirectory.getFileSystem();
        File indexDir = new File(this.testDirectory.storeDir(), "schema/index/");
        return (File[])fs.streamFilesRecursive(indexDir).map(FileHandle::getFile).toArray(File[]::new);
    }

    private List<File> corruptIndexes(boolean readOnly, CorruptionInject corruptionInject, File ... targetFiles) throws Exception {
        ArrayList<File> treeFiles = new ArrayList<File>();
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.testDirectory.getFileSystem(), (JobScheduler)jobScheduler);){
            SchemaLayouts schemaLayouts = new SchemaLayouts();
            GBPTreeBootstrapper bootstrapper = new GBPTreeBootstrapper(pageCache, (LayoutBootstrapper)schemaLayouts, readOnly);
            for (File file : targetFiles) {
                GBPTreeBootstrapper.Bootstrap bootstrap = bootstrapper.bootstrapTree(file, "generic1");
                if (!bootstrap.isTree()) continue;
                treeFiles.add(file);
                try (GBPTree gbpTree = bootstrap.getTree();){
                    InspectingVisitor visitor = (InspectingVisitor)gbpTree.visit((GBPTreeVisitor)new InspectingVisitor());
                    corruptionInject.corrupt(gbpTree, visitor.get());
                }
            }
        }
        return treeFiles;
    }

    private void createAnIndex(GraphDatabaseService db) {
        String longString = this.longString();
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 40; ++i) {
                Node node = db.createNode(new Label[]{label});
                String value = longString + i;
                node.setProperty(propKey1, (Object)value);
            }
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            db.schema().indexFor(label).on(propKey1).create();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private String longString() {
        char[] chars = new char[1000];
        Arrays.fill((char[])chars, (char)'a');
        return new String(chars);
    }

    private static interface CorruptionInject {
        public void corrupt(GBPTree<?, ?> var1, GBPTreeInspection<?, ?> var2) throws IOException;
    }
}

