/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker.full;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.FullCheckIntegrationTest;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class ExperimentalFullCheckIntegrationTest
extends FullCheckIntegrationTest {
    private HashMap<Setting<?>, Object> extraSettings;

    @Override
    @BeforeEach
    protected void setUp() {
        this.extraSettings = new HashMap();
        super.setUp();
    }

    @Override
    protected Map<Setting<?>, Object> getSettings() {
        HashMap cfg = new HashMap(super.getSettings());
        cfg.put(GraphDatabaseSettings.experimental_consistency_checker, true);
        cfg.putAll(this.extraSettings);
        return cfg;
    }

    @Test
    void shouldOnlyReportFirstNodeInconsistencyOnFailFast() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node(), false, next.relationship(), -1L));
                tx.create(new NodeRecord(next.node(), false, next.relationship(), -1L));
            }
        });
        this.extraSettings.put(GraphDatabaseSettings.experimental_consistency_checker_stop_threshold, 1);
        ConsistencySummaryStatistics stats = this.check();
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldOnlyReportFirstRelationshipInconsistenciesOnFailFast() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new RelationshipRecord(next.relationship(), 1L, 2L, ExperimentalFullCheckIntegrationTest.this.C));
                tx.create(new RelationshipRecord(next.relationship(), 1L, 2L, ExperimentalFullCheckIntegrationTest.this.C));
            }
        });
        this.extraSettings.put(GraphDatabaseSettings.experimental_consistency_checker_stop_threshold, 1);
        ConsistencySummaryStatistics stats = this.check();
        int relationshipInconsistencies = stats.getInconsistencyCountForRecordType(RecordType.RELATIONSHIP);
        MatcherAssert.assertThat((Object)relationshipInconsistencies, (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)1), CoreMatchers.equalTo((Object)2)}));
        Assertions.assertEquals((long)stats.getTotalInconsistencyCount(), (long)relationshipInconsistencies);
    }

    @Test
    void shouldReportRelationshipGroupRelationshipDoesNotShareOwner() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(new NodeRecord(node, true, group, (long)Record.NO_NEXT_PROPERTY.intValue()));
                tx.create(new NodeRecord(otherNode, false, rel, (long)Record.NO_NEXT_PROPERTY.intValue()));
                tx.create(new RelationshipRecord(rel, otherNode, otherNode, ExperimentalFullCheckIntegrationTest.this.C));
                tx.create(ExperimentalFullCheckIntegrationTest.withOwner(ExperimentalFullCheckIntegrationTest.withRelationships(new RelationshipGroupRecord(group, ExperimentalFullCheckIntegrationTest.this.C), rel, rel, rel), node));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, ExperimentalFullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Override
    @Disabled(value="New checker checks the live graph, i.e. anything that can be reached from the used nodes/relationships")
    @Test
    protected void shouldReportOrphanedNodeDynamicLabelAsNodeInconsistency() throws Exception {
        super.shouldReportOrphanedNodeDynamicLabelAsNodeInconsistency();
    }
}

