/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class PropertyReaderIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;

    PropertyReaderIT() {
    }

    @Test
    void shouldDetectAndAbortPropertyChainLoadingOnCircularReference() throws IOException {
        PropertyStore propertyStore = this.getNeoStores().getPropertyStore();
        PropertyRecord record = propertyStore.newRecord();
        record.setId(1L);
        record.initialize(true, -1L, 2L);
        propertyStore.updateRecord((AbstractBaseRecord)record);
        record.setId(2L);
        record.initialize(true, 1L, 3L);
        propertyStore.updateRecord((AbstractBaseRecord)record);
        record.setId(3L);
        record.initialize(true, 2L, 4L);
        propertyStore.updateRecord((AbstractBaseRecord)record);
        record.setId(4L);
        record.initialize(true, 3L, 2L);
        propertyStore.updateRecord((AbstractBaseRecord)record);
        PropertyReader reader = new PropertyReader(new StoreAccess(this.getNeoStores()));
        PropertyReader.CircularPropertyRecordChainException e = (PropertyReader.CircularPropertyRecordChainException)Assertions.assertThrows(PropertyReader.CircularPropertyRecordChainException.class, () -> reader.getPropertyRecordChain(1L));
        Assertions.assertEquals((long)4L, (long)e.propertyRecordClosingTheCircle().getId());
    }

    private NeoStores getNeoStores() {
        return ((RecordStorageEngine)this.databaseAPI.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
    }
}

