/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.repair;

import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.repair.RecordSet;
import org.neo4j.consistency.repair.RelationshipChainExplorer;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;

@PageCacheExtension
@Neo4jLayoutExtension
public class RelationshipChainExplorerTest {
    private static final int degreeTwoNodes = 10;
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private DatabaseLayout databaseLayout;
    private StoreAccess store;

    @BeforeEach
    void setupStoreAccess() {
        this.store = this.createStoreWithOneHighDegreeNodeAndSeveralDegreeTwoNodes(10);
    }

    @AfterEach
    void tearDownStoreAccess() {
        this.store.close();
    }

    @Test
    void shouldLoadAllConnectedRelationshipRecordsAndTheirFullChainsOfRelationshipRecords() {
        RecordStore relationshipStore = this.store.getRelationshipStore();
        int relationshipIdInMiddleOfChain = 10;
        RecordSet records = new RelationshipChainExplorer(relationshipStore).exploreRelationshipRecordChainsToDepthTwo((RelationshipRecord)relationshipStore.getRecord((long)relationshipIdInMiddleOfChain, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.NORMAL));
        Assertions.assertEquals((int)20, (int)records.size());
    }

    @Test
    void shouldCopeWithAChainThatReferencesNotInUseZeroValueRecords() {
        RecordStore relationshipStore = this.store.getRelationshipStore();
        RelationshipChainExplorerTest.breakTheChain((RecordStore<RelationshipRecord>)relationshipStore);
        int relationshipIdInMiddleOfChain = 10;
        RecordSet records = new RelationshipChainExplorer(relationshipStore).exploreRelationshipRecordChainsToDepthTwo((RelationshipRecord)relationshipStore.getRecord((long)relationshipIdInMiddleOfChain, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.NORMAL));
        int recordsInaccessibleBecauseOfBrokenChain = 3;
        Assertions.assertEquals((int)(20 - recordsInaccessibleBecauseOfBrokenChain), (int)records.size());
    }

    private static void breakTheChain(RecordStore<RelationshipRecord> relationshipStore) {
        RelationshipRecord record = (RelationshipRecord)relationshipStore.getRecord(10L, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.NORMAL);
        long relationshipTowardsEndOfChain = record.getFirstNode();
        while (record.inUse() && !record.isFirstInFirstChain()) {
            record = (RelationshipRecord)relationshipStore.getRecord(relationshipTowardsEndOfChain, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.FORCE);
            relationshipTowardsEndOfChain = record.getFirstPrevRel();
        }
        relationshipStore.updateRecord((AbstractBaseRecord)new RelationshipRecord(relationshipTowardsEndOfChain, 0L, 0L, 0));
    }

    private StoreAccess createStoreWithOneHighDegreeNodeAndSeveralDegreeTwoNodes(int nDegreeTwoNodes) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setConfig(this.getConfig()).build();
        GraphDatabaseService database = managementService.database("neo4j");
        try (Transaction transaction = database.beginTx();){
            Node denseNode = transaction.createNode();
            for (int i = 0; i < nDegreeTwoNodes; ++i) {
                Node degreeTwoNode = transaction.createNode();
                Node leafNode = transaction.createNode();
                if (i % 2 == 0) {
                    denseNode.createRelationshipTo(degreeTwoNode, (RelationshipType)TestRelationshipType.CONNECTED);
                } else {
                    degreeTwoNode.createRelationshipTo(denseNode, (RelationshipType)TestRelationshipType.CONNECTED);
                }
                degreeTwoNode.createRelationshipTo(leafNode, (RelationshipType)TestRelationshipType.CONNECTED);
            }
            transaction.commit();
        }
        managementService.shutdown();
        StoreAccess storeAccess = new StoreAccess(this.fileSystem, this.pageCache, this.databaseLayout, Config.defaults());
        return storeAccess.initialize();
    }

    protected Map<Setting<?>, Object> getConfig() {
        return Map.of(GraphDatabaseSettings.record_format, this.getRecordFormatName());
    }

    protected String getRecordFormatName() {
        return "";
    }

    static enum TestRelationshipType implements RelationshipType
    {
        CONNECTED;

    }
}

