/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.io.File;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.DebugContext;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.TestDirectory;

@PageCacheExtension
class IndexCheckingSelectorTest {
    private static final Label label1 = Label.label((String)"Label1");
    private static final String property1 = "property1";
    private final StringJoiner output = new StringJoiner(System.lineSeparator());
    private final DebugContext debugContext = new DebugContext(){

        public boolean debugEnabled() {
            return true;
        }

        public void debug(String message) {
            IndexCheckingSelectorTest.this.output.add(message);
        }
    };
    private GraphStoreFixture fixture;
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DefaultFileSystemAbstraction fs;

    IndexCheckingSelectorTest() {
    }

    @AfterEach
    void tearDown() throws Exception {
        if (this.fixture != null) {
            this.fixture.close();
        }
    }

    @Test
    void checkLargeNodeIndexesWithIndexChecker() throws Exception {
        this.fixture = new GraphStoreFixture("", this.pageCache, this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService db) {
                try (Transaction tx = db.beginTx();){
                    Node node = tx.createNode(new Label[]{label1});
                    node.setProperty(IndexCheckingSelectorTest.property1, (Object)"value");
                    tx.commit();
                }
                tx = db.beginTx();
                try {
                    tx.schema().indexFor(label1).on(IndexCheckingSelectorTest.property1).create();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.experimental_consistency_checker, true});
            }
        };
        this.runConsistencyCheck();
        String outputString = this.output.toString();
        MatcherAssert.assertThat((Object)outputString, (Matcher)Matchers.containsString((String)"IndexChecker[entityType:NODE,indexesToCheck:1]"));
        MatcherAssert.assertThat((Object)outputString, (Matcher)Matchers.containsString((String)"NodeChecker[highId:1,indexesToCheck:0]"));
    }

    @Test
    void checkSmallNodeIndexesWithNodeChecker() throws Exception {
        this.fixture = new GraphStoreFixture("", this.pageCache, this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService db) {
                try (Transaction tx = db.beginTx();){
                    Node node = tx.createNode(new Label[]{label1});
                    node.setProperty(IndexCheckingSelectorTest.property1, (Object)"value");
                    for (int i = 0; i < 20; ++i) {
                        tx.createNode();
                    }
                    tx.commit();
                }
                tx = db.beginTx();
                try {
                    tx.schema().indexFor(label1).on(IndexCheckingSelectorTest.property1).create();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.experimental_consistency_checker, true});
            }
        };
        this.runConsistencyCheck();
        String outputString = this.output.toString();
        MatcherAssert.assertThat((Object)outputString, (Matcher)Matchers.containsString((String)"IndexChecker[entityType:NODE,indexesToCheck:0]"));
        MatcherAssert.assertThat((Object)outputString, (Matcher)Matchers.containsString((String)"NodeChecker[highId:21,indexesToCheck:1]"));
    }

    @Test
    void checkIndexesWithoutValuesWithNodeChecker() throws Exception {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setConfig(GraphDatabaseSettings.experimental_consistency_checker, (Object)true).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{label1});
            node.setProperty(property1, (Object)"value");
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.execute("CALL db.index.fulltext.createNodeIndex('indexName', ['Label1'], ['property1']);");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        managementService.shutdown();
        DatabaseLayout layout = Neo4jLayout.of((File)this.testDirectory.homeDir()).databaseLayout("neo4j");
        Config config = Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (Object)layout.databaseDirectory().toPath());
        config.set(GraphDatabaseSettings.experimental_consistency_checker, (Object)true);
        ConsistencyCheckService.Result result = new ConsistencyCheckService().runFullConsistencyCheck(layout, config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.nullLogProvider(), (FileSystemAbstraction)this.fs, this.pageCache, this.debugContext, layout.databaseDirectory(), ConsistencyFlags.DEFAULT);
        Assertions.assertTrue((boolean)result.isSuccessful());
        String outputString = this.output.toString();
        MatcherAssert.assertThat((Object)outputString, (Matcher)Matchers.containsString((String)"IndexChecker[entityType:NODE,indexesToCheck:0]"));
        MatcherAssert.assertThat((Object)outputString, (Matcher)Matchers.containsString((String)"NodeChecker[highId:1,indexesToCheck:1]"));
    }

    private void runConsistencyCheck() throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics result = this.checkIndex();
        Assertions.assertTrue((boolean)result.isConsistent());
    }

    private ConsistencySummaryStatistics checkIndex() throws ConsistencyCheckIncompleteException {
        FullCheck checker = new FullCheck(ProgressMonitorFactory.NONE, Statistics.NONE, ConsistencyCheckService.defaultConsistencyCheckThreadsNumber(), ConsistencyFlags.DEFAULT, Config.defaults((Setting)GraphDatabaseSettings.experimental_consistency_checker, (Object)true), this.debugContext, NodeBasedMemoryLimiter.DEFAULT);
        return checker.execute(this.pageCache, this.fixture.readOnlyDirectStoreAccess(), this.fixture.counts(), (Log)NullLog.getInstance());
    }
}

