/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import org.bouncycastle.util.Arrays;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBootstrapper;
import org.neo4j.index.internal.gbptree.GBPTreeCorruption;
import org.neo4j.index.internal.gbptree.GBPTreeInspection;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.GBPTreeUnsafe;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.InspectingVisitor;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.internal.counts.CountsLayout;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.SchemaLayouts;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.TestDirectory;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class ConsistencyCheckWithCorruptGBPTreeIT {
    private static final Label label = Label.label((String)"label");
    private static final String propKey1 = "key1";
    private static final File neo4jHome = new File("neo4j_home").getAbsoluteFile();
    private EphemeralFileSystemAbstraction sourceSnapshot;
    private DatabaseLayout databaseLayout;
    private EphemeralFileSystemAbstraction fs;

    ConsistencyCheckWithCorruptGBPTreeIT() {
    }

    @BeforeAll
    void createIndex() {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        fs.mkdirs(neo4jHome);
        this.dbmsAction(neo4jHome, (FileSystemAbstraction)fs, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10, db -> {
            this.indexWithStringData((GraphDatabaseService)db, label);
            this.databaseLayout = ((GraphDatabaseAPI)db).databaseLayout();
        });
        this.sourceSnapshot = fs.snapshot();
    }

    @BeforeEach
    void restoreSnapshot() {
        this.fs = this.sourceSnapshot.snapshot();
    }

    @Test
    void simpleTestWithNoSetup() throws Exception {
        MutableObject heightRef = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> heightRef.setValue((Object)inspection.getLastLevel()), indexFiles);
        int height = (Integer)heightRef.getValue();
        Assertions.assertEquals((int)2, (int)height, (String)("This test assumes height of index tree is 2 but height for this index was " + height + ". This is most easily regulated by changing number of nodes in setup."));
    }

    @Test
    void assertTreeHeightIsAsExpected() throws Exception {
        MutableObject heightRef = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> heightRef.setValue((Object)inspection.getLastLevel()), indexFiles);
        int height = (Integer)heightRef.getValue();
        Assertions.assertEquals((int)2, (int)height, (String)("This test assumes height of index tree is 2 but height for this index was " + height + ". This is most easily regulated by changing number of nodes in setup."));
    }

    @Test
    void shouldNotCheckIndexesIfConfiguredNotTo() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        ConsistencyFlags flags = new ConsistencyFlags(true, false, false, true, true);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance(), flags);
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected store to be consistent when not checking indexes.");
    }

    @Test
    void shouldCheckIndexStructureEvenIfNotCheckingIndexes() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        ConsistencyFlags flags = new ConsistencyFlags(true, false, true, true, true);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance(), flags);
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be inconsistent when checking index structure.");
        this.assertResultContainsMessage(result, "Page: " + targetNode.getValue() + " is not a tree node page");
    }

    @Test
    void shouldNotCheckIndexStructureIfConfiguredNotToEvenIfCheckingIndexes() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.addFreelistEntry((long)5L));
        }, indexFiles);
        ConsistencyFlags flags = new ConsistencyFlags(true, true, false, true, true);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance(), flags);
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected store to be consistent when not checking indexes.");
    }

    @Test
    void shouldReportProgress() throws Exception {
        StringWriter writer = new StringWriter();
        ProgressMonitorFactory factory = ProgressMonitorFactory.textual((Writer)writer);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance(), factory);
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected new database to be clean.");
        Assertions.assertTrue((boolean)((Object)writer).toString().contains("Index structure consistency check"));
    }

    @Test
    void notATreeNode() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Page: " + targetNode.getValue() + " is not a tree node page.");
    }

    @Test
    void unknownTreeNodeType() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.unknownTreeNodeType()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Page: " + targetNode.getValue() + " has an unknown tree node type:");
    }

    @Test
    void siblingsDontPointToEachOther() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getLeafNodes().get(0));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointToNonExisting()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Sibling pointers misaligned.");
    }

    @Test
    void rightmostNodeHasRightSibling() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long root = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)root, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setPointer((GBPTreePointerType)GBPTreePointerType.rightSibling(), (long)10L)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Expected rightmost node to have no right sibling but was 10");
    }

    @Test
    void pointerToOldVersionOfTreeNode() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setPointer((GBPTreePointerType)GBPTreePointerType.successor(), (long)6L)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "We ended up on tree node " + targetNode.getValue() + " which has a newer generation, successor is: 6");
    }

    @Test
    void pointerHasLowerGenerationThanNode() throws Exception {
        MutableObject targetNode = new MutableObject();
        MutableObject rightSibling = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            ImmutableLongList leafNodes = inspection.getLeafNodes();
            targetNode.setValue((Object)leafNodes.get(0));
            rightSibling.setValue((Object)leafNodes.get(1));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointerHasTooLowGeneration()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, String.format("Pointer (%s) in tree node %d has pointer generation %d, but target node %d has a higher generation %d.", GBPTreePointerType.rightSibling(), targetNode.getValue(), 1, rightSibling.getValue(), 4));
    }

    @Test
    void keysOutOfOrderInNode() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getLeafNodes().get(0));
            int keyCount = (Integer)inspection.getKeyCounts().get(targetNode.getValue());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.swapKeyOrderLeaf((int)0, (int)1, (int)keyCount)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, String.format("Keys in tree node %d are out of order.", targetNode.getValue()));
    }

    @Test
    void keysLocatedInWrongNode() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long internalNode = ((ImmutableLongList)inspection.getNodesPerLevel().get(1)).get(0);
            int keyCount = (Integer)inspection.getKeyCounts().get(internalNode);
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)internalNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.swapChildOrder((int)0, (int)1, (int)keyCount)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Expected range for this tree node is");
    }

    @Test
    void unusedPage() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long internalNode = ((ImmutableLongList)inspection.getNodesPerLevel().get(1)).get(0);
            int keyCount = (Integer)inspection.getKeyCounts().get(internalNode);
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)internalNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setKeyCount((int)(keyCount - 1))));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Index has a leaked page that will never be reclaimed, pageId=");
    }

    @Test
    void pageIdExceedLastId() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.decrementFreelistWritePos()), indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Index has a leaked page that will never be reclaimed, pageId=");
    }

    @Test
    void nodeMetaInconsistency() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)inspection.getRootNode(), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.decrementAllocOffsetInDynamicNode())), indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "has inconsistent meta data: Meta data for tree node is inconsistent");
    }

    @Test
    void pageIdSeenMultipleTimes() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.addFreelistEntry((long)((Long)targetNode.getValue())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Page id seen multiple times, this means either active tree node is present in freelist or pointers in tree create a loop, pageId=" + targetNode.getValue());
    }

    @Test
    void crashPointer() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(false, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.crashed((GBPTreePointerType)GBPTreePointerType.rightSibling())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Crashed pointer found in tree node " + targetNode.getValue());
    }

    @Test
    void brokenPointer() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Broken pointer found in tree node " + targetNode.getValue());
    }

    @Test
    void unreasonableKeyCount() throws Exception {
        MutableObject targetNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            targetNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)targetNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setKeyCount((int)Integer.MAX_VALUE)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Unexpected keyCount on pageId " + targetNode.getValue() + ", keyCount=2147483647");
    }

    @Test
    void childNodeFoundAmongParentNodes() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long rootNode = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)rootNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setChild((int)0, (long)rootNode)));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Circular reference, child tree node found among parent nodes. Parents:");
    }

    @Test
    void exception() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long rootNode = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)rootNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setHighestReasonableKeyCount()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Caught exception during consistency check: org.neo4j.index.internal.gbptree.TreeInconsistencyException: Some internal problem causing out of bounds: pageId:");
    }

    @Test
    void shouldIncludeIndexFileInConsistencyReport() throws Exception {
        File[] indexFiles = this.schemaIndexFiles();
        List<File> corruptedFiles = this.corruptIndexes(true, (tree, inspection) -> {
            long rootNode = inspection.getRootNode();
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)rootNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.notATreeNode()));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected store to be considered inconsistent.");
        this.assertResultContainsMessage(result, "Index file: " + corruptedFiles.get(0).getAbsolutePath());
    }

    @Test
    void multipleCorruptions() throws Exception {
        MutableObject internalNode = new MutableObject();
        File[] indexFiles = this.schemaIndexFiles();
        this.corruptIndexes(true, (tree, inspection) -> {
            long leafNode = inspection.getLeafNodes().get(0);
            internalNode.setValue((Object)((ImmutableLongList)inspection.getNodesPerLevel().get(1)).get(0));
            Integer internalNodeKeyCount = (Integer)inspection.getKeyCounts().get(internalNode.getValue());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)leafNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointToNonExisting()));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)internalNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.swapChildOrder((int)0, (int)1, (int)internalNodeKeyCount)));
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)internalNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, indexFiles);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        this.assertResultContainsMessage(result, "Index inconsistency: Sibling pointers misaligned.");
        this.assertResultContainsMessage(result, "Index inconsistency: Expected range for this tree node is");
        this.assertResultContainsMessage(result, "Index inconsistency: Broken pointer found in tree node " + internalNode.getValue() + ", pointerType='left sibling'");
        this.assertResultContainsMessage(result, "Index inconsistency: Pointer (left sibling) in tree node ");
    }

    @Test
    void corruptionInLabelScanStore() throws Exception {
        MutableObject rootNode = new MutableObject();
        File labelScanStoreFile = this.labelScanStoreFile();
        this.corruptIndexes(true, (tree, inspection) -> {
            rootNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)rootNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, labelScanStoreFile);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index inconsistency: Broken pointer found in tree node " + rootNode.getValue() + ", pointerType='left sibling'");
        this.assertResultContainsMessage(result, "Number of inconsistent LABEL_SCAN_DOCUMENT records: 1");
    }

    @Test
    void corruptionInIndexStatisticsStore() throws Exception {
        MutableObject rootNode = new MutableObject();
        File indexStatisticsStoreFile = this.indexStatisticsStoreFile();
        this.corruptIndexes(true, (tree, inspection) -> {
            rootNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)rootNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, indexStatisticsStoreFile);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance());
        Assertions.assertFalse((boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index inconsistency: Broken pointer found in tree node " + rootNode.getValue() + ", pointerType='left sibling'");
        this.assertResultContainsMessage(result, "Number of inconsistent INDEX_STATISTICS records: 1");
    }

    @Test
    void corruptionInCountsStore() throws Exception {
        MutableObject rootNode = new MutableObject();
        File countsStoreFile = this.countsStoreFile();
        LayoutBootstrapper countsLayoutBootstrapper = (indexFile, pageCache, meta) -> new CountsLayout();
        this.corruptIndexes((FileSystemAbstraction)this.fs, true, (GBPTree<?, ?> tree, GBPTreeInspection<?, ?> inspection) -> {
            rootNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)rootNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, countsLayoutBootstrapper, countsStoreFile);
        ConsistencyFlags flags = new ConsistencyFlags(false, false, true, false, false);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance(), flags);
        Assertions.assertFalse((boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index inconsistency: Broken pointer found in tree node " + rootNode.getValue() + ", pointerType='left sibling'");
        this.assertResultContainsMessage(result, "Number of inconsistent COUNTS records: 1");
    }

    @Test
    void corruptionInIdGenerator() throws Exception {
        MutableObject rootNode = new MutableObject();
        File[] idStoreFiles = this.idStoreFiles();
        LayoutBootstrapper countsLayoutBootstrapper = (indexFile, pageCache, meta) -> new CountsLayout();
        this.corruptIndexes((FileSystemAbstraction)this.fs, true, (GBPTree<?, ?> tree, GBPTreeInspection<?, ?> inspection) -> {
            rootNode.setValue((Object)inspection.getRootNode());
            tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)((Long)rootNode.getValue()), (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.broken((GBPTreePointerType)GBPTreePointerType.leftSibling())));
        }, idStoreFiles);
        ConsistencyFlags flags = new ConsistencyFlags(false, false, true, false, false);
        ConsistencyCheckService.Result result = this.runConsistencyCheck((LogProvider)NullLogProvider.getInstance(), flags);
        Assertions.assertFalse((boolean)result.isSuccessful());
        this.assertResultContainsMessage(result, "Index inconsistency: Broken pointer found in tree node " + rootNode.getValue() + ", pointerType='left sibling'");
        this.assertResultContainsMessage(result, "Number of inconsistent ID_STORE records: " + idStoreFiles.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void multipleCorruptionsInFusionIndex() throws Exception {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)fs);
        testDirectory.prepareDirectory(ConsistencyCheckWithCorruptGBPTreeIT.class, "multipleCorruptionsInFusionIndex");
        try {
            File neo4jHome = testDirectory.homeDir();
            this.dbmsAction(neo4jHome, (FileSystemAbstraction)fs, GraphDatabaseSettings.SchemaIndex.NATIVE30, db -> {
                Label label = Label.label((String)"label2");
                this.indexWithNumberData((GraphDatabaseService)db, label);
            });
            DatabaseLayout layout = DatabaseLayout.of((Config)Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)neo4jHome.toPath()));
            File[] indexFiles = this.schemaIndexFiles((FileSystemAbstraction)fs, layout.databaseDirectory(), GraphDatabaseSettings.SchemaIndex.NATIVE30);
            List<File> files = this.corruptIndexes((FileSystemAbstraction)fs, true, (GBPTree<?, ?> tree, GBPTreeInspection<?, ?> inspection) -> {
                long leafNode = inspection.getLeafNodes().get(1);
                long internalNode = inspection.getInternalNodes().get(0);
                tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)leafNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.rightSiblingPointToNonExisting()));
                tree.unsafe((GBPTreeUnsafe)GBPTreeCorruption.pageSpecificCorruption((long)internalNode, (GBPTreeCorruption.PageCorruption)GBPTreeCorruption.setChild((int)0, (long)internalNode)));
            }, indexFiles);
            Assertions.assertTrue((files.size() > 0 ? 1 : 0) != 0, (String)"Expected number of corrupted files to be more than one.");
            ConsistencyCheckService.Result result = this.runConsistencyCheck((FileSystemAbstraction)fs, neo4jHome, layout, (LogProvider)NullLogProvider.getInstance(), ProgressMonitorFactory.NONE, ConsistencyFlags.DEFAULT);
            for (File file : files) {
                this.assertResultContainsMessage((FileSystemAbstraction)fs, result, "Index will be excluded from further consistency checks. Index file: " + file.getAbsolutePath());
            }
        }
        finally {
            testDirectory.cleanup();
        }
    }

    private void assertResultContainsMessage(ConsistencyCheckService.Result result, String expectedMessage) throws IOException {
        this.assertResultContainsMessage((FileSystemAbstraction)this.fs, result, expectedMessage);
    }

    private void assertResultContainsMessage(FileSystemAbstraction fs, ConsistencyCheckService.Result result, String expectedMessage) throws IOException {
        Reader reader = fs.openAsReader(result.reportFile(), Charset.defaultCharset());
        BufferedReader bufferedReader = new BufferedReader(reader);
        List lines = bufferedReader.lines().collect(Collectors.toList());
        boolean reportContainExpectedMessage = false;
        for (String line : lines) {
            if (!line.contains(expectedMessage)) continue;
            reportContainExpectedMessage = true;
            break;
        }
        String errorMessage = String.format("Expected consistency report to contain message `%s'. Real result was: %s%n", expectedMessage, String.join((CharSequence)System.lineSeparator(), lines));
        Assertions.assertTrue((boolean)reportContainExpectedMessage, (String)errorMessage);
    }

    private ConsistencyCheckService.Result runConsistencyCheck(LogProvider logProvider) throws ConsistencyCheckIncompleteException {
        return this.runConsistencyCheck(logProvider, ProgressMonitorFactory.NONE);
    }

    private ConsistencyCheckService.Result runConsistencyCheck(LogProvider logProvider, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runConsistencyCheck(logProvider, ProgressMonitorFactory.NONE, consistencyFlags);
    }

    private ConsistencyCheckService.Result runConsistencyCheck(LogProvider logProvider, ProgressMonitorFactory progressFactory) throws ConsistencyCheckIncompleteException {
        return this.runConsistencyCheck(logProvider, progressFactory, ConsistencyFlags.DEFAULT);
    }

    private ConsistencyCheckService.Result runConsistencyCheck(LogProvider logProvider, ProgressMonitorFactory progressFactory, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        return this.runConsistencyCheck((FileSystemAbstraction)this.fs, neo4jHome, this.databaseLayout, logProvider, progressFactory, consistencyFlags);
    }

    private ConsistencyCheckService.Result runConsistencyCheck(FileSystemAbstraction fs, File neo4jHome, DatabaseLayout databaseLayout, LogProvider logProvider, ProgressMonitorFactory progressFactory, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.neo4j_home, (Object)neo4jHome.toPath());
        return consistencyCheckService.runFullConsistencyCheck(databaseLayout, config, progressFactory, logProvider, fs, false, consistencyFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbmsAction(File neo4jHome, FileSystemAbstraction fs, GraphDatabaseSettings.SchemaIndex schemaIndex, Consumer<GraphDatabaseService> dbSetup) {
        DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(neo4jHome).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(fs)).setConfig(GraphDatabaseSettings.default_schema_provider, (Object)schemaIndex.providerName()).build();
        try {
            GraphDatabaseService db = dbms.database("neo4j");
            dbSetup.accept(db);
        }
        finally {
            dbms.shutdown();
        }
    }

    private File labelScanStoreFile() {
        File dataDir = this.databaseLayout.databaseDirectory();
        return new File(dataDir, DatabaseFile.LABEL_SCAN_STORE.getName());
    }

    private File indexStatisticsStoreFile() {
        File dataDir = this.databaseLayout.databaseDirectory();
        return new File(dataDir, DatabaseFile.INDEX_STATISTICS_STORE.getName());
    }

    private File countsStoreFile() {
        File dataDir = this.databaseLayout.databaseDirectory();
        return new File(dataDir, DatabaseFile.COUNTS_STORE.getName());
    }

    private File[] idStoreFiles() {
        return (File[])this.databaseLayout.idFiles().toArray(File[]::new);
    }

    private File[] schemaIndexFiles() throws IOException {
        File databaseDir = this.databaseLayout.databaseDirectory();
        return this.schemaIndexFiles((FileSystemAbstraction)this.fs, databaseDir, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10);
    }

    private File[] schemaIndexFiles(FileSystemAbstraction fs, File databaseDir, GraphDatabaseSettings.SchemaIndex schemaIndex) throws IOException {
        String fileNameFriendlyProviderName = IndexDirectoryStructure.fileNameFriendly((String)schemaIndex.providerName());
        File indexDir = new File(databaseDir, "schema/index/");
        return (File[])fs.streamFilesRecursive(indexDir).map(FileHandle::getFile).filter(file -> file.getAbsolutePath().contains(fileNameFriendlyProviderName)).toArray(File[]::new);
    }

    private List<File> corruptIndexes(boolean readOnly, CorruptionInject corruptionInject, File ... targetFiles) throws Exception {
        return this.corruptIndexes((FileSystemAbstraction)this.fs, readOnly, corruptionInject, targetFiles);
    }

    private List<File> corruptIndexes(FileSystemAbstraction fs, boolean readOnly, CorruptionInject corruptionInject, File ... targetFiles) throws Exception {
        return this.corruptIndexes(fs, readOnly, corruptionInject, (LayoutBootstrapper)new SchemaLayouts(), targetFiles);
    }

    private List<File> corruptIndexes(FileSystemAbstraction fs, boolean readOnly, CorruptionInject corruptionInject, LayoutBootstrapper layoutBootstrapper, File ... targetFiles) throws Exception {
        ArrayList<File> treeFiles = new ArrayList<File>();
        try (JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs, (JobScheduler)jobScheduler);){
            GBPTreeBootstrapper bootstrapper = new GBPTreeBootstrapper(pageCache, layoutBootstrapper, readOnly);
            for (File file : targetFiles) {
                GBPTreeBootstrapper.Bootstrap bootstrap = bootstrapper.bootstrapTree(file);
                if (!bootstrap.isTree()) continue;
                treeFiles.add(file);
                try (GBPTree gbpTree = bootstrap.getTree();){
                    InspectingVisitor visitor = (InspectingVisitor)gbpTree.visit((GBPTreeVisitor)new InspectingVisitor());
                    corruptionInject.corrupt(gbpTree, visitor.get());
                }
            }
        }
        return treeFiles;
    }

    private void indexWithNumberData(GraphDatabaseService db, Label label) {
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty(propKey1, (Object)i);
            }
            tx.commit();
        }
        this.createIndexOn(db, label);
    }

    private void indexWithStringData(GraphDatabaseService db, Label label) {
        String longString = this.longString();
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 60; ++i) {
                Node node = tx.createNode(new Label[]{label});
                String value = longString + i;
                node.setProperty(propKey1, (Object)value);
            }
            tx.commit();
        }
        this.createIndexOn(db, label);
    }

    private void createIndexOn(GraphDatabaseService db, Label label) {
        try (Transaction tx = db.beginTx();){
            tx.schema().indexFor(label).on(propKey1).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private String longString() {
        char[] chars = new char[1000];
        Arrays.fill((char[])chars, (char)'a');
        return new String(chars);
    }

    @FunctionalInterface
    private static interface CorruptionInject {
        public void corrupt(GBPTree<?, ?> var1, GBPTreeInspection<?, ?> var2) throws IOException;
    }
}

