/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.RecordCheckTestBase;
import org.neo4j.consistency.checking.SchemaRuleUtil;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsStore;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsAllocator;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.string.UTF8;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.util.Bits;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
@ExtendWith(value={SuppressOutputExtension.class})
public class FullCheckIntegrationTest {
    private static final IndexProviderDescriptor DESCRIPTOR = GenericNativeIndexProvider.DESCRIPTOR;
    private static final String PROP1 = "key1";
    private static final String PROP2 = "key2";
    private static final Object VALUE1 = "value1";
    private static final Object VALUE2 = "value2";
    @Inject
    private PageCache pageCache;
    @Inject
    private TestDirectory testDirectory;
    protected GraphStoreFixture fixture;
    protected int label1;
    protected int label2;
    protected int label3;
    protected int draconian;
    protected int key1;
    protected int mandatory;
    protected int C;
    protected int T;
    protected int M;
    protected final List<Long> indexedNodes = new ArrayList<Long>();

    @BeforeEach
    protected void setUp() {
        this.fixture = this.createFixture();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.fixture.close();
    }

    @Test
    void shouldCheckConsistencyOfAConsistentStore() throws Exception {
        ConsistencySummaryStatistics result = this.check();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)result.getTotalInconsistencyCount(), (String)result.toString());
    }

    @Test
    void shouldReportNodeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInlineNodeLabelInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord).add(10L, null, null, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportNodeDynamicLabelContainingUnknownLabelAsNodeInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                DynamicRecord record = (DynamicRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new DynamicRecord(next.nodeLabel()));
                ArrayList newRecords = new ArrayList();
                DynamicArrayStore.allocateFromNumbers(newRecords, (Object)LabelIdArray.prependNodeId((long)nodeRecord.getId(), (long[])new long[]{42L}), (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}), (PageCursorTracer)PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), newRecords);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldNotReportAnythingForNodeWithConsistentChainOfDynamicRecordsWithLabels() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((List)this.chainOfDynamicRecordsWithLabelsForANode(130).first()).size());
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent(), (String)"should be consistent");
    }

    @Test
    void shouldReportLabelScanStoreInconsistencies() throws Exception {
        GraphStoreFixture.IdGenerator idGenerator = this.fixture.idGenerator();
        long nodeId1 = idGenerator.node();
        long labelId = idGenerator.label() - 1;
        LabelScanStore labelScanStore = this.fixture.directStoreAccess().labelScanStore();
        Iterable nodeLabelUpdates = Iterables.asIterable((Object[])new EntityTokenUpdate[]{EntityTokenUpdate.tokenChanges((long)nodeId1, (long[])new long[0], (long[])new long[]{labelId})});
        this.write((TokenScanStore)labelScanStore, nodeLabelUpdates);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    void write(TokenScanStore tokenScanStore, Iterable<EntityTokenUpdate> entityTokenUpdates) throws IOException {
        try (TokenScanWriter writer = tokenScanStore.newWriter(PageCursorTracer.NULL);){
            for (EntityTokenUpdate update : entityTokenUpdates) {
                writer.write(update);
            }
        }
    }

    @Test
    void shouldReportIndexInconsistencies() throws Exception {
        for (Long indexedNodeId : this.indexedNodes) {
            this.fixture.directStoreAccess().nativeStores().getNodeStore().updateRecord((AbstractBaseRecord)((NodeRecord)RecordCheckTestBase.notInUse((AbstractBaseRecord)new NodeRecord(indexedNodeId.longValue()).initialize(false, -1L, false, -1L, 0L))), PageCursorTracer.NULL);
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.INDEX, 3).verify(RecordType.LABEL_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    void shouldNotReportIndexInconsistenciesIfIndexIsFailed() throws Exception {
        DirectStoreAccess storeAccess = this.fixture.directStoreAccess();
        Iterator<IndexDescriptor> rules = this.getIndexDescriptors();
        while (rules.hasNext()) {
            IndexDescriptor rule = rules.next();
            IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
            IndexPopulator populator = storeAccess.indexes().lookup(rule.getIndexProvider()).getPopulator(rule, samplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            populator.markAsFailed("Oh noes! I was a shiny index and then I was failed");
            populator.close(false, PageCursorTracer.NULL);
        }
        for (Long indexedNodeId : this.indexedNodes) {
            storeAccess.nativeStores().getNodeStore().updateRecord((AbstractBaseRecord)((NodeRecord)RecordCheckTestBase.notInUse((AbstractBaseRecord)new NodeRecord(indexedNodeId.longValue()).initialize(false, -1L, false, -1L, 0L))), PageCursorTracer.NULL);
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportMismatchedLabels() throws Exception {
        final ArrayList labels = new ArrayList();
        final Pair<List<DynamicRecord>, List<Integer>> pair = this.chainOfDynamicRecordsWithLabelsForANode(3);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(42L).initialize(false, -1L, false, -1L, 0L);
                node.setInUse(true);
                List dynamicRecords = (List)pair.first();
                labels.addAll((Collection)pair.other());
                node.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)dynamicRecords), (Collection)dynamicRecords);
                tx.create(node);
            }
        });
        long[] before = this.asArray(labels);
        labels.remove(1);
        long[] after = this.asArray(labels);
        this.write((TokenScanStore)this.fixture.directStoreAccess().labelScanStore(), Collections.singletonList(EntityTokenUpdate.tokenChanges((long)42L, (long[])before, (long[])after)));
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    private long[] asArray(List<? extends Number> in) {
        long[] longs = new long[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            longs[i] = in.get(i).longValue();
        }
        return longs;
    }

    @Test
    void shouldReportMismatchedInlinedLabels() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(42L).initialize(false, -1L, false, -1L, 0L);
                node.setInUse(true);
                node.setLabelField(FullCheckIntegrationTest.this.inlinedLabelsLongRepresentation(FullCheckIntegrationTest.this.label1, FullCheckIntegrationTest.this.label2), Collections.emptySet());
                tx.create(node);
            }
        });
        EntityTokenUpdate update = EntityTokenUpdate.tokenChanges((long)42L, (long[])new long[]{this.label1, this.label2}, (long[])new long[]{this.label1});
        this.write((TokenScanStore)this.fixture.directStoreAccess().labelScanStore(), Collections.singletonList(update));
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportNodesThatAreNotIndexed() throws Exception {
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        Iterator<IndexDescriptor> indexDescriptorIterator = this.getIndexDescriptors();
        while (indexDescriptorIterator.hasNext()) {
            IndexDescriptor indexDescriptor = indexDescriptorIterator.next();
            IndexAccessor accessor = this.fixture.directStoreAccess().indexes().lookup(indexDescriptor.getIndexProvider()).getOnlineAccessor(indexDescriptor, samplingConfig);
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
                for (long nodeId : this.indexedNodes) {
                    EntityUpdates updates = this.fixture.nodeAsUpdates(nodeId);
                    for (IndexEntryUpdate update : updates.forIndexKeys(Collections.singletonList(indexDescriptor))) {
                        updater.process(IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])update.values()));
                    }
                }
            }
            accessor.force(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
            accessor.close();
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 3).andThatsAllFolks();
    }

    @Test
    void shouldReportNodesWithDuplicatePropertyValueInUniqueIndex() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                for (int i = 0; i < 50; ++i) {
                    NodeRecord node = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                    node.setInUse(true);
                    tx.create(node);
                }
            }
        });
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(Config.defaults());
        Iterator<IndexDescriptor> indexRuleIterator = this.getIndexDescriptors();
        while (indexRuleIterator.hasNext()) {
            IndexDescriptor indexRule = indexRuleIterator.next();
            IndexAccessor accessor = this.fixture.directStoreAccess().indexes().lookup(indexRule.getIndexProvider()).getOnlineAccessor(indexRule, samplingConfig);
            try {
                try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
                    updater.process(IndexEntryUpdate.add((long)42L, (SchemaDescriptorSupplier)indexRule.schema(), (Value[])this.values(indexRule)));
                }
                accessor.force(IOLimiter.UNLIMITED, PageCursorTracer.NULL);
            }
            finally {
                if (accessor == null) continue;
                accessor.close();
            }
        }
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).verify(RecordType.INDEX, 3).andThatsAllFolks();
    }

    private Value[] values(IndexDescriptor indexRule) {
        switch (indexRule.schema().getPropertyIds().length) {
            case 1: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)VALUE1)});
            }
            case 2: {
                return (Value[])Iterators.array((Object[])new Value[]{Values.of((Object)VALUE1), Values.of((Object)VALUE2)});
            }
        }
        throw new UnsupportedOperationException();
    }

    @Test
    void shouldReportMissingMandatoryNodeProperty() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(next.node()).initialize(false, next.property(), false, -1L, 0L);
                node.setInUse(true);
                node.setLabelField(FullCheckIntegrationTest.this.inlinedLabelsLongRepresentation(FullCheckIntegrationTest.this.draconian), Collections.emptySet());
                PropertyRecord property = new PropertyRecord(node.getNextProp(), (PrimitiveRecord)node);
                property.setInUse(true);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)FullCheckIntegrationTest.this.key1 | (long)PropertyType.INT.intValue() << 24 | 0x5390000000L);
                property.addPropertyBlock(block);
                tx.create(node);
                tx.create(property);
            }
        });
        this.createNodePropertyExistenceConstraint(this.draconian, this.mandatory);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportMissingMandatoryRelationshipProperty() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeId1 = next.node();
                long nodeId2 = next.node();
                long relId = next.relationship();
                long propId = next.property();
                NodeRecord node1 = new NodeRecord(nodeId1).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, relId, (long)Record.NO_LABELS_FIELD.intValue());
                NodeRecord node2 = new NodeRecord(nodeId2).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, relId, (long)Record.NO_LABELS_FIELD.intValue());
                RelationshipRecord relationship = new RelationshipRecord(relId);
                relationship.initialize(true, 0L, nodeId1, nodeId2, FullCheckIntegrationTest.this.M, 1L, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 1L, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), true, true);
                relationship.setNextProp(propId);
                PropertyRecord property = new PropertyRecord(propId, (PrimitiveRecord)relationship);
                property.setInUse(true);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)FullCheckIntegrationTest.this.key1 | (long)PropertyType.INT.intValue() << 24 | 0x5390000000L);
                property.addPropertyBlock(block);
                tx.create(node1);
                tx.create(node2);
                tx.create(relationship);
                tx.create(property);
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.M, -1, 1L);
            }
        });
        this.createRelationshipPropertyExistenceConstraint(this.M, this.mandatory);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 1).andThatsAllFolks();
    }

    private long inlinedLabelsLongRepresentation(long ... labelIds) {
        long header = (long)labelIds.length << 36;
        byte bitsPerLabel = (byte)(36 / labelIds.length);
        Bits bits = Bits.bits((int)5);
        for (long labelId : labelIds) {
            bits.put(labelId, (int)bitsPerLabel);
        }
        return header | bits.getLongs()[0];
    }

    @Test
    void shouldReportCyclesInDynamicRecordsWithLabels() throws Exception {
        final List chain = (List)this.chainOfDynamicRecordsWithLabelsForANode(176).first();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)chain.size(), (String)"number of records in chain");
        org.junit.jupiter.api.Assertions.assertEquals((int)((DynamicRecord)chain.get(0)).getLength(), (int)((DynamicRecord)chain.get(2)).getLength(), (String)"all records full");
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeId = ((long[])DynamicArrayStore.getRightArray((Pair)AbstractDynamicStore.readFullByteArrayFromHeavyRecords((Iterable)chain, (PropertyType)PropertyType.ARRAY)).asObject())[0];
                NodeRecord before = (NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(nodeId).initialize(false, -1L, false, -1L, 0L));
                NodeRecord after = (NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(nodeId).initialize(false, -1L, false, -1L, 0L));
                DynamicRecord record1 = FullCheckIntegrationTest.this.cloneRecord((DynamicRecord)chain.get(0));
                DynamicRecord record2 = FullCheckIntegrationTest.this.cloneRecord((DynamicRecord)chain.get(1));
                DynamicRecord record3 = FullCheckIntegrationTest.this.cloneRecord((DynamicRecord)chain.get(2));
                record3.setNextBlock(record2.getId());
                before.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), (Collection)chain);
                after.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), Arrays.asList(record1, record2, record3));
                tx.update(before, after);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).verify(RecordType.COUNTS, 176).andThatsAllFolks();
    }

    private Pair<List<DynamicRecord>, List<Integer>> chainOfDynamicRecordsWithLabelsForANode(int labelCount) throws KernelException {
        final long[] labels = new long[labelCount + 1];
        final ArrayList createdLabels = new ArrayList();
        try (GraphStoreFixture.Applier applier = this.fixture.createApplier();){
            int i = 1;
            while (i < labels.length) {
                final int offset = i++;
                applier.apply(new GraphStoreFixture.Transaction(){

                    @Override
                    protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                        Integer label = next.label();
                        labels[offset] = label.intValue();
                        tx.nodeLabel((int)labels[offset], "label:" + offset, false);
                        createdLabels.add(label);
                    }
                });
            }
        }
        final ArrayList chain = new ArrayList();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord nodeRecord = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                DynamicRecord record1 = (DynamicRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new DynamicRecord(next.nodeLabel()));
                DynamicRecord record2 = (DynamicRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new DynamicRecord(next.nodeLabel()));
                DynamicRecord record3 = (DynamicRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new DynamicRecord(next.nodeLabel()));
                labels[0] = nodeRecord.getId();
                ReusableRecordsAllocator allocator = new ReusableRecordsAllocator(60, new DynamicRecord[]{record1, record2, record3});
                DynamicArrayStore.allocateFromNumbers((Collection)chain, (Object)labels, (DynamicRecordAllocator)allocator, (PageCursorTracer)PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)chain), (Collection)chain);
                tx.create(nodeRecord);
            }
        });
        return Pair.of(chain, createdLabels);
    }

    @Test
    void shouldReportNodeDynamicLabelContainingDuplicateLabelAsNodeInconsistency() throws Exception {
        final int nodeId = 1000;
        final ArrayList duplicatedLabel = new ArrayList();
        final Pair<List<DynamicRecord>, List<Integer>> labels = this.chainOfDynamicRecordsWithLabelsForANode(1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord((long)nodeId).initialize(false, -1L, false, -1L, 0L);
                node.setInUse(true);
                List labelRecords = (List)labels.first();
                node.setLabelField(DynamicNodeLabels.dynamicPointer((Collection)labelRecords), (Collection)labelRecords);
                tx.create(node);
                Integer labelId = (Integer)((List)labels.other()).get(0);
                DynamicRecord record = (DynamicRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new DynamicRecord((long)labelId.intValue()));
                DynamicArrayStore.allocateFromNumbers((Collection)duplicatedLabel, (Object)new long[]{nodeId, labelId.intValue(), labelId.intValue()}, (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}), (PageCursorTracer)PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
        });
        StoreAccess storeAccess = this.fixture.directStoreAccess().nativeStores();
        NodeRecord nodeRecord = new NodeRecord((long)nodeId);
        storeAccess.getNodeStore().getRecord((long)nodeId, (AbstractBaseRecord)nodeRecord, RecordLoad.FORCE, PageCursorTracer.NULL);
        nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(duplicatedLabel), duplicatedLabel);
        nodeRecord.setInUse(true);
        storeAccess.getNodeStore().updateRecord((AbstractBaseRecord)nodeRecord, PageCursorTracer.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).verify(RecordType.COUNTS, 0).andThatsAllFolks();
    }

    @Test
    protected void shouldReportOrphanedNodeDynamicLabelAsNodeInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.nodeLabel(42, "Label", false);
                NodeRecord nodeRecord = new NodeRecord(next.node()).initialize(false, -1L, false, -1L, 0L);
                DynamicRecord record = (DynamicRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new DynamicRecord(next.nodeLabel()));
                ArrayList newRecords = new ArrayList();
                DynamicArrayStore.allocateFromNumbers(newRecords, (Object)LabelIdArray.prependNodeId((long)next.node(), (long[])new long[]{42L}), (DynamicRecordAllocator)new ReusableRecordsAllocator(60, new DynamicRecord[]{record}), (PageCursorTracer)PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                nodeRecord.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), newRecords);
                tx.create(nodeRecord);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE_DYNAMIC_LABEL, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationship = new RelationshipRecord(next.relationship());
                relationship.setLinks(1L, 2L, FullCheckIntegrationTest.this.C);
                tx.create(relationship);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 2).verify(RecordType.COUNTS, 4).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipOtherNodeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node1 = next.node();
                long node2 = next.node();
                long rel = next.relationship();
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(node1, node2, 0);
                tx.create((RelationshipRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)relationship));
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node1).initialize(false, -1L, false, rel + 1L, 0L)));
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node2).initialize(false, -1L, false, rel + 2L, 0L)));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 2).verify(RecordType.NODE, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportPropertyInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                NodeRecord node = new NodeRecord(next.node());
                PropertyRecord property = new PropertyRecord(next.property());
                node.setNextProp(property.getId());
                property.setNextProp(1000L);
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)next.propertyKey() | (long)PropertyType.INT.intValue() << 24 | 0x29A0000000L);
                property.addPropertyBlock(block);
                tx.create(node);
                tx.create(property);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY, 2).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportStringPropertyInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                DynamicRecord string = new DynamicRecord(next.stringProperty());
                string.setInUse(true);
                string.setCreated();
                string.setType(PropertyType.STRING.intValue());
                string.setNextBlock(next.stringProperty());
                string.setData(UTF8.encode((String)"hello world"));
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)PropertyType.STRING.intValue() << 24 | string.getId() << 28);
                block.addValueRecord(string);
                PropertyRecord property = new PropertyRecord(next.property());
                property.addPropertyBlock(block);
                NodeRecord node = new NodeRecord(next.node());
                node.initialize(true, property.getId(), false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue());
                property.setNodeId(node.getId());
                tx.create(property);
                tx.create(node);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.STRING_PROPERTY, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportBrokenSchemaRecordChain() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                SchemaRecord before = new SchemaRecord(next.schema());
                SchemaRecord after = FullCheckIntegrationTest.this.cloneRecord(before);
                after.initialize(true, next.property());
                IndexDescriptor rule = SchemaRuleUtil.indexRule((long)after.getId(), (int)FullCheckIntegrationTest.this.label1, (int)FullCheckIntegrationTest.this.key1, (IndexProviderDescriptor)DESCRIPTOR);
                rule = tx.completeConfiguration(rule);
                tx.createSchema(before, after, (SchemaRule)rule);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicateConstraintReferences() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
                int ruleId1 = (int)next.schema();
                int ruleId2 = (int)next.schema();
                int labelId = next.label();
                int propertyKeyId = next.propertyKey();
                SchemaRecord before1 = new SchemaRecord((long)ruleId1);
                SchemaRecord before2 = new SchemaRecord((long)ruleId2);
                SchemaRecord after1 = FullCheckIntegrationTest.this.cloneRecord(before1).initialize(true, 0L);
                SchemaRecord after2 = FullCheckIntegrationTest.this.cloneRecord(before2).initialize(true, 0L);
                IndexDescriptor rule1 = SchemaRuleUtil.constraintIndexRule((long)ruleId1, (int)labelId, (int)propertyKeyId, (IndexProviderDescriptor)DESCRIPTOR, (long)ruleId1);
                rule1 = tx.completeConfiguration(rule1);
                IndexDescriptor rule2 = SchemaRuleUtil.constraintIndexRule((long)ruleId2, (int)labelId, (int)propertyKeyId, (IndexProviderDescriptor)DESCRIPTOR, (long)ruleId1);
                rule2 = tx.completeConfiguration(rule2);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule1, after1, tx, next);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule2, after2, tx, next);
                tx.nodeLabel(labelId, "label", false);
                tx.propertyKey(propertyKeyId, "property", false);
                tx.createSchema(before1, after1, (SchemaRule)rule1);
                tx.createSchema(before2, after2, (SchemaRule)rule2);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 4).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidConstraintBackReferences() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
                int ruleId1 = (int)next.schema();
                int ruleId2 = (int)next.schema();
                int labelId = next.label();
                int propertyKeyId = next.propertyKey();
                SchemaRecord before1 = new SchemaRecord((long)ruleId1);
                SchemaRecord before2 = new SchemaRecord((long)ruleId2);
                SchemaRecord after1 = FullCheckIntegrationTest.this.cloneRecord(before1).initialize(true, 0L);
                SchemaRecord after2 = FullCheckIntegrationTest.this.cloneRecord(before2).initialize(true, 0L);
                IndexDescriptor rule1 = SchemaRuleUtil.constraintIndexRule((long)ruleId1, (int)labelId, (int)propertyKeyId, (IndexProviderDescriptor)DESCRIPTOR, (long)ruleId2);
                rule1 = tx.completeConfiguration(rule1);
                ConstraintDescriptor rule2 = SchemaRuleUtil.uniquenessConstraintRule((long)ruleId2, (int)labelId, (int)propertyKeyId, (long)ruleId2);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule1, after1, tx, next);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)rule2, after2, tx, next);
                tx.nodeLabel(labelId, "label", false);
                tx.propertyKey(propertyKeyId, "property", false);
                tx.createSchema(before1, after1, (SchemaRule)rule1);
                tx.createSchema(before2, after2, (SchemaRule)rule2);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportArrayPropertyInconsistencies() throws Exception {
        final int recordDataSize = 116;
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, final GraphStoreFixture.IdGenerator next) {
                ArrayList allocatedRecords = new ArrayList();
                long[] arrayValue = new long[70];
                for (int i = 0; i < arrayValue.length; ++i) {
                    arrayValue[i] = i * 10000;
                }
                DynamicArrayStore.allocateRecords(allocatedRecords, (Object)arrayValue, (DynamicRecordAllocator)new DynamicRecordAllocator(){

                    public int getRecordDataSize() {
                        return recordDataSize;
                    }

                    public DynamicRecord nextRecord(PageCursorTracer cursorTracer) {
                        return StandardDynamicRecordAllocator.allocateRecord((long)next.arrayProperty());
                    }
                }, (boolean)true, (PageCursorTracer)PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                Assertions.assertThat((int)allocatedRecords.size()).isGreaterThan(1);
                DynamicRecord array = (DynamicRecord)allocatedRecords.get(0);
                array.setType(PropertyType.ARRAY.intValue());
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)PropertyType.ARRAY.intValue() << 24 | array.getId() << 28);
                block.addValueRecord(array);
                PropertyRecord property = new PropertyRecord(next.property());
                property.addPropertyBlock(block);
                NodeRecord node = new NodeRecord(next.node());
                node.initialize(true, property.getId(), false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue());
                property.setNodeId(node.getId());
                tx.create(property);
                tx.create(node);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.ARRAY_PROPERTY, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipLabelNameInconsistencies() throws Exception {
        final Reference inconsistentName = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                inconsistentName.set(next.relationshipType());
                tx.relationshipType((Integer)inconsistentName.get(), "FOO", false);
            }
        });
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        DynamicRecord record = (DynamicRecord)access.getRelationshipTypeNameStore().getRecord((long)((Integer)inconsistentName.get()).intValue(), (AbstractBaseRecord)((DynamicRecord)access.getRelationshipTypeNameStore().newRecord()), RecordLoad.FORCE, PageCursorTracer.NULL);
        record.setNextBlock(record.getId());
        access.getRelationshipTypeNameStore().updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE_NAME, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportPropertyKeyNameInconsistencies() throws Exception {
        final Reference inconsistentName = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                inconsistentName.set(next.propertyKey());
                tx.propertyKey((Integer)inconsistentName.get(), "FOO", false);
            }
        });
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        DynamicRecord record = (DynamicRecord)access.getPropertyKeyNameStore().getRecord((long)((Integer)inconsistentName.get() + 1), (AbstractBaseRecord)((DynamicRecord)access.getPropertyKeyNameStore().newRecord()), RecordLoad.FORCE, PageCursorTracer.NULL);
        record.setNextBlock(record.getId());
        access.getPropertyKeyNameStore().updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY_KEY_NAME, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipTypeInconsistencies() throws Exception {
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        RecordStore relTypeStore = access.getRelationshipTypeTokenStore();
        RelationshipTypeTokenRecord record = (RelationshipTypeTokenRecord)relTypeStore.getRecord((long)((int)relTypeStore.nextId(PageCursorTracer.NULL)), (AbstractBaseRecord)((RelationshipTypeTokenRecord)relTypeStore.newRecord()), RecordLoad.FORCE, PageCursorTracer.NULL);
        record.setNameId(20);
        record.setInUse(true);
        relTypeStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        ConsistencySummaryStatistics stats = this.check();
        access.close();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportLabelInconsistencies() throws Exception {
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        LabelTokenRecord record = (LabelTokenRecord)access.getLabelTokenStore().getRecord(1L, (AbstractBaseRecord)((LabelTokenRecord)access.getLabelTokenStore().newRecord()), RecordLoad.FORCE, PageCursorTracer.NULL);
        record.setNameId(20);
        record.setInUse(true);
        access.getLabelTokenStore().updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.LABEL, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportPropertyKeyInconsistencies() throws Exception {
        final Reference inconsistentKey = new Reference();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                inconsistentKey.set(next.propertyKey());
                tx.propertyKey((Integer)inconsistentKey.get(), "FOO", false);
            }
        });
        StoreAccess access = this.fixture.directStoreAccess().nativeStores();
        DynamicRecord record = (DynamicRecord)access.getPropertyKeyNameStore().getRecord((long)((Integer)inconsistentKey.get() + 1), (AbstractBaseRecord)((DynamicRecord)access.getPropertyKeyNameStore().newRecord()), RecordLoad.FORCE, PageCursorTracer.NULL);
        record.setInUse(false);
        access.getPropertyKeyNameStore().updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY_KEY, 1).andThatsAllFolks();
    }

    @Test
    void shouldNotBeConfusedByInternalPropertyKeyTokens() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int propertyKey = next.propertyKey();
                tx.propertyKey(propertyKey, "FOO", true);
                long nextProp = next.property();
                PropertyRecord property = new PropertyRecord(nextProp).initialize(true, Record.NO_PREVIOUS_PROPERTY.longValue(), Record.NO_NEXT_PROPERTY.longValue());
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)propertyKey | (long)PropertyType.INT.intValue() << 24 | 0x29A0000000L);
                property.addPropertyBlock(block);
                tx.create(property);
                tx.create(new NodeRecord(next.node()).initialize(true, nextProp, false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue()));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent());
        FullCheckIntegrationTest.on(stats).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupTypeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                int nonExistentType = next.relationshipType() + 1;
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(group, nonExistentType)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupChainInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withNext((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), group + 1L), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupUnsortedChainInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long firstGroupId = next.relationshipGroup();
                long otherGroupId = next.relationshipGroup();
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, firstGroupId, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withNext((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(firstGroupId, FullCheckIntegrationTest.this.T)), otherGroupId), node));
                tx.create(FullCheckIntegrationTest.withOwner((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(otherGroupId, FullCheckIntegrationTest.this.C)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupRelationshipNotInUseInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long groupId = next.relationshipGroup();
                long rel = next.relationship();
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, groupId, 0L)));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(groupId, FullCheckIntegrationTest.this.C)), rel, rel, rel), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupRelationshipNotFirstInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long relA = next.relationship();
                long relB = next.relationship();
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L)));
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, relA, 0L)));
                RelationshipRecord relationshipA = new RelationshipRecord(relA);
                relationshipA.setLinks(otherNode, node, FullCheckIntegrationTest.this.C);
                tx.create(FullCheckIntegrationTest.this.withNext((RelationshipRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)relationshipA), relB));
                RelationshipRecord relationshipB = new RelationshipRecord(relB);
                relationshipB.setLinks(node, otherNode, FullCheckIntegrationTest.this.C);
                tx.create(FullCheckIntegrationTest.this.withPrev((RelationshipRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)relationshipB), relA));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), relB, relB, relB), node));
                tx.incrementRelationshipCount(-1, -1, -1, 2L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 2L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldReportFirstRelationshipGroupOwnerInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                tx.create(new NodeRecord(node).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L));
                tx.create(new NodeRecord(otherNode).initialize(true, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 0L));
                tx.create(new RelationshipGroupRecord(group).initialize(true, FullCheckIntegrationTest.this.C, -1L, -1L, -1L, otherNode, -1L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportChainedRelationshipGroupOwnerInconsistency() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long groupA = next.relationshipGroup();
                long groupB = next.relationshipGroup();
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, groupA, 0L)));
                tx.create((NodeRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), 0L)));
                tx.create(FullCheckIntegrationTest.withNext(FullCheckIntegrationTest.withOwner((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(groupA, FullCheckIntegrationTest.this.C)), node), groupB));
                tx.create(FullCheckIntegrationTest.withOwner((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(groupB, FullCheckIntegrationTest.this.T)), otherNode));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupOwnerNotInUse() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long group = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.withOwner((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), node));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipGroupOwnerInvalidValue() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long group = next.relationshipGroup();
                tx.create(FullCheckIntegrationTest.withOwner((RelationshipGroupRecord)RecordCheckTestBase.inUse((AbstractBaseRecord)FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C)), -1L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 1).andThatsAllFolks();
    }

    private RelationshipRecord withNext(RelationshipRecord relationship, long next) {
        relationship.setFirstNextRel(next);
        relationship.setSecondNextRel(next);
        return relationship;
    }

    private RelationshipRecord withPrev(RelationshipRecord relationship, long prev) {
        relationship.setFirstInFirstChain(false);
        relationship.setFirstInSecondChain(false);
        relationship.setFirstPrevRel(prev);
        relationship.setSecondPrevRel(prev);
        return relationship;
    }

    @Test
    void shouldReportRelationshipGroupRelationshipOfOtherTypeInconsistencies() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L));
                tx.create(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(node, otherNode, FullCheckIntegrationTest.this.T);
                tx.create(relationship);
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationships(FullCheckIntegrationTest.relationshipGroupRecord(group, FullCheckIntegrationTest.this.C), rel, rel, rel), node));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.T, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldNotReportRelationshipGroupInconsistenciesForConsistentRecords() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long nodeA = next.node();
                long nodeB = next.node();
                long rel = next.relationship();
                long groupA = next.relationshipGroup();
                long groupB = next.relationshipGroup();
                tx.create(new NodeRecord(nodeA).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, groupA, 0L));
                tx.create(new NodeRecord(nodeB).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(nodeA, nodeB, FullCheckIntegrationTest.this.C);
                tx.create(FullCheckIntegrationTest.firstInChains(relationship, 1));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, FullCheckIntegrationTest.this.C, -1, 1L);
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.withRelationship(FullCheckIntegrationTest.withNext(FullCheckIntegrationTest.relationshipGroupRecord(groupA, FullCheckIntegrationTest.this.C), groupB), Direction.OUTGOING, rel), nodeA));
                tx.create(FullCheckIntegrationTest.withOwner(FullCheckIntegrationTest.relationshipGroupRecord(groupB, FullCheckIntegrationTest.this.T), nodeA));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent(), (String)"should be consistent");
    }

    @Test
    void shouldReportWrongNodeCountsEntries() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(FullCheckIntegrationTest.this.label3, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportWrongRelationshipCountsEntries() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementRelationshipCount(FullCheckIntegrationTest.this.label1, FullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportIfSomeKeysAreMissing() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(FullCheckIntegrationTest.this.label3, -1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportIfThereAreExtraKeys() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.incrementNodeCount(1024, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedIndexRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createIndexRule(labelId, propertyKeyId);
        this.createIndexRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedCompositeIndexRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        int propertyKeyId3 = this.createPropertyKey("p3");
        this.createIndexRule(labelId, propertyKeyId1, propertyKeyId2, propertyKeyId3);
        this.createIndexRule(labelId, propertyKeyId1, propertyKeyId2, propertyKeyId3);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedUniquenessConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedCompositeUniquenessConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        this.createUniquenessConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        this.createUniquenessConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedNodeKeyConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId1 = this.createPropertyKey("p1");
        int propertyKeyId2 = this.createPropertyKey("p2");
        this.createNodeKeyConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        this.createNodeKeyConstraintRule(labelId, propertyKeyId1, propertyKeyId2);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedNodePropertyExistenceConstraintRules() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportDuplicatedRelationshipPropertyExistenceConstraintRules() throws Exception {
        int relTypeId = this.createRelType();
        int propertyKeyId = this.createPropertyKey();
        this.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId);
        this.createRelationshipPropertyExistenceConstraint(relTypeId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInIndexRule() throws Exception {
        int labelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createIndexRule(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInUniquenessConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInNodeKeyConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createNodeKeyConstraintRule(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidLabelIdInNodePropertyExistenceConstraintRule() throws Exception {
        int badLabelId = this.fixture.idGenerator().label();
        int propertyKeyId = this.createPropertyKey();
        this.createNodePropertyExistenceConstraint(badLabelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidPropertyKeyIdInIndexRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createIndexRule(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidSecondPropertyKeyIdInIndexRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createIndexRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidPropertyKeyIdInUniquenessConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createUniquenessConstraintRule(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidSecondPropertyKeyIdInUniquenessConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidSecondPropertyKeyIdInNodeKeyConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createNodeKeyConstraintRule(labelId, propertyKeyId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 2).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidPropertyKeyIdInNodePropertyExistenceConstraintRule() throws Exception {
        int labelId = this.createLabel();
        int badPropertyKeyId = this.fixture.idGenerator().propertyKey();
        this.createNodePropertyExistenceConstraint(labelId, badPropertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportInvalidRelTypeIdInRelationshipPropertyExistenceConstraintRule() throws Exception {
        int badRelTypeId = this.fixture.idGenerator().relationshipType();
        int propertyKeyId = this.createPropertyKey();
        this.createRelationshipPropertyExistenceConstraint(badRelTypeId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.SCHEMA, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportNothingForUniquenessAndPropertyExistenceConstraintOnSameLabelAndProperty() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createUniquenessConstraintRule(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    void shouldReportNothingForNodeKeyAndPropertyExistenceConstraintOnSameLabelAndProperty() throws Exception {
        int labelId = this.createLabel();
        int propertyKeyId = this.createPropertyKey();
        this.createNodeKeyConstraintRule(labelId, propertyKeyId);
        this.createNodePropertyExistenceConstraint(labelId, propertyKeyId);
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    void shouldManageUnusedRecordsWithWeirdDataIn() throws Exception {
        final AtomicLong id = new AtomicLong();
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                id.set(next.relationship());
                RelationshipRecord relationship = new RelationshipRecord(id.get());
                relationship.setFirstNode(-1L);
                relationship.setSecondNode(-1L);
                relationship.setInUse(true);
                tx.create(relationship);
            }
        });
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationship = new RelationshipRecord(id.get());
                tx.delete(relationship);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.isConsistent());
    }

    @Test
    void shouldReportCircularNodePropertyRecordChain() throws Exception {
        this.shouldReportCircularPropertyRecordChain(RecordType.NODE, (tx, next, propertyRecordId) -> tx.create(new NodeRecord(next.node()).initialize(true, propertyRecordId, false, -1L, Record.NO_LABELS_FIELD.longValue())));
    }

    @Test
    void shouldReportCircularRelationshipPropertyRecordChain() throws Exception {
        int relType = this.createRelType();
        this.shouldReportCircularPropertyRecordChain(RecordType.RELATIONSHIP, (tx, next, propertyRecordId) -> {
            long node = next.node();
            long relationship = next.relationship();
            tx.create(new NodeRecord(node).initialize(true, -1L, false, relationship, Record.NO_LABELS_FIELD.longValue()));
            RelationshipRecord relationshipRecord = new RelationshipRecord(relationship);
            relationshipRecord.setFirstNode(node);
            relationshipRecord.setSecondNode(node);
            relationshipRecord.setType(relType);
            relationshipRecord.setNextProp(propertyRecordId);
            tx.create(relationshipRecord);
        });
    }

    @Test
    void shouldReportMissingCountsStore() throws Exception {
        this.shouldReportBadCountsStore((ThrowingFunction<File, Boolean, IOException>)((ThrowingFunction)File::delete));
    }

    @Test
    void shouldReportBrokenCountsStore() throws Exception {
        this.shouldReportBadCountsStore((ThrowingFunction<File, Boolean, IOException>)((ThrowingFunction)this::corruptFileIfExists));
    }

    @Test
    void shouldWarnIfConfiguredToValidateRelationshipTypeScanStoreButItIsDisabled() throws ConsistencyCheckIncompleteException {
        Config config = this.config();
        config.set(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store, (Object)false);
        ConsistencyFlags flags = new ConsistencyFlags(true, true, true, true, true, true);
        ConsistencySummaryStatistics check = this.check(config, flags);
        Assertions.assertThat((long)check.getTotalWarningCount()).isEqualTo(1L);
        FullCheckIntegrationTest.on(check).andThatsAllFolks();
    }

    private void shouldReportBadCountsStore(ThrowingFunction<File, Boolean, IOException> fileAction) throws Exception {
        boolean corrupted = (Boolean)fileAction.apply((Object)this.fixture.databaseLayout().countStore());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)corrupted);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(RecordType.COUNTS, 1);
    }

    protected Map<Setting<?>, Object> getSettings() {
        return MapUtil.genericMap((Object[])new Object[]{GraphDatabaseInternalSettings.experimental_consistency_checker, false});
    }

    private GraphStoreFixture createFixture() {
        return new GraphStoreFixture(this.getRecordFormatName(), this.pageCache, this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService db) {
                Transaction tx;
                try {
                    tx = db.beginTx();
                    try {
                        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
                        TokenRead tokenRead = ktx.tokenRead();
                        TokenWrite tokenWrite = ktx.tokenWrite();
                        FullCheckIntegrationTest.this.label1 = tokenWrite.labelGetOrCreateForName("label1");
                        FullCheckIntegrationTest.this.label2 = tokenWrite.labelGetOrCreateForName("label2");
                        FullCheckIntegrationTest.this.label3 = tokenWrite.labelGetOrCreateForName("label3");
                        tokenWrite.labelGetOrCreateForName("label4");
                        FullCheckIntegrationTest.this.draconian = tokenWrite.labelGetOrCreateForName("draconian");
                        FullCheckIntegrationTest.this.key1 = tokenWrite.propertyKeyGetOrCreateForName(FullCheckIntegrationTest.PROP1);
                        FullCheckIntegrationTest.this.mandatory = tokenWrite.propertyKeyGetOrCreateForName("mandatory");
                        FullCheckIntegrationTest.this.C = tokenWrite.relationshipTypeGetOrCreateForName("C");
                        FullCheckIntegrationTest.this.T = tokenWrite.relationshipTypeGetOrCreateForName("T");
                        FullCheckIntegrationTest.this.M = tokenWrite.relationshipTypeGetOrCreateForName("M");
                        tx.commit();
                    }
                    finally {
                        if (tx != null) {
                            tx.close();
                        }
                    }
                }
                catch (KernelException e) {
                    throw new RuntimeException(e);
                }
                tx = db.beginTx();
                try {
                    tx.schema().indexFor(Label.label((String)"label3")).on(FullCheckIntegrationTest.PROP1).create();
                    tx.schema().indexFor(Label.label((String)"label3")).on(FullCheckIntegrationTest.PROP1).on(FullCheckIntegrationTest.PROP2).create();
                    tx.schema().constraintFor(Label.label((String)"label4")).assertPropertyIsUnique(FullCheckIntegrationTest.PROP1).create();
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = db.beginTx();
                try {
                    tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
                tx = db.beginTx();
                try {
                    Node node1 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label1")}), (Property[])new Property[0]);
                    Node node2 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label2")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)});
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                    tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"T"));
                    FullCheckIntegrationTest.this.indexedNodes.add(((Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label3")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)})).getId());
                    FullCheckIntegrationTest.this.indexedNodes.add(((Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label3")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1), Property.property((String)FullCheckIntegrationTest.PROP2, (Object)VALUE2)})).getId());
                    Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"label4")}), (Property[])new Property[]{Property.property((String)FullCheckIntegrationTest.PROP1, (Object)VALUE1)});
                    tx.commit();
                }
                finally {
                    if (tx != null) {
                        tx.close();
                    }
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return FullCheckIntegrationTest.this.getSettings();
            }
        };
    }

    private boolean corruptFileIfExists(File file) throws IOException {
        if (file.exists()) {
            try (RandomAccessFile accessFile = new RandomAccessFile(file, "rw");){
                FileChannel channel = accessFile.getChannel();
                ByteBuffer buffer = ByteBuffers.allocate((int)30, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                while (buffer.hasRemaining()) {
                    buffer.put((byte)9);
                }
                buffer.flip();
                FileUtils.writeAll((FileChannel)channel, (ByteBuffer)buffer);
            }
            return true;
        }
        return false;
    }

    private void shouldReportCircularPropertyRecordChain(RecordType expectedInconsistentRecordType, final EntityCreator entityCreator) throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long a = next.property();
                long b = next.property();
                long c = next.property();
                long d = next.property();
                tx.create(this.propertyRecordWithSingleIntProperty(a, next.propertyKey(), -1L, b));
                tx.create(this.propertyRecordWithSingleIntProperty(b, next.propertyKey(), a, c));
                tx.create(this.propertyRecordWithSingleIntProperty(c, next.propertyKey(), b, d));
                tx.create(this.propertyRecordWithSingleIntProperty(d, next.propertyKey(), c, b));
                entityCreator.create(tx, next, a);
            }

            private PropertyRecord propertyRecordWithSingleIntProperty(long id, int propertyKeyId, long prev, long next) {
                PropertyRecord record = new PropertyRecord(id).initialize(true, prev, next);
                PropertyBlock block = new PropertyBlock();
                PropertyStore.encodeValue((PropertyBlock)block, (int)propertyKeyId, (Value)Values.intValue((int)10), null, null, (boolean)false, (PageCursorTracer)PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                record.addPropertyBlock(block);
                return record;
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationTest.on(stats).verify(expectedInconsistentRecordType, 1);
    }

    protected ConsistencySummaryStatistics check() throws ConsistencyCheckIncompleteException {
        DirectStoreAccess stores = this.fixture.readOnlyDirectStoreAccess();
        return this.check(this.fixture.getInstantiatedPageCache(), stores, this.fixture.counts());
    }

    private ConsistencySummaryStatistics check(Config config, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        PageCache pageCache = this.fixture.getInstantiatedPageCache();
        DirectStoreAccess stores = this.fixture.readOnlyDirectStoreAccess();
        ThrowingSupplier<CountsStore, IOException> counts = this.fixture.counts();
        return this.check(pageCache, stores, counts, config, consistencyFlags);
    }

    private ConsistencySummaryStatistics check(PageCache pageCache, DirectStoreAccess stores, ThrowingSupplier<CountsStore, IOException> counts) throws ConsistencyCheckIncompleteException {
        Config config = this.config();
        boolean checkRelationshipTypeScanStore = (Boolean)config.get(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store);
        ConsistencyFlags consistencyFlags = new ConsistencyFlags(true, true, true, true, checkRelationshipTypeScanStore, true);
        return this.check(pageCache, stores, counts, config, consistencyFlags);
    }

    private ConsistencySummaryStatistics check(PageCache pageCache, DirectStoreAccess stores, ThrowingSupplier<CountsStore, IOException> counts, Config config, ConsistencyFlags consistencyFlags) throws ConsistencyCheckIncompleteException {
        FullCheck checker = new FullCheck(ProgressMonitorFactory.NONE, this.fixture.getAccessStatistics(), ConsistencyCheckService.defaultConsistencyCheckThreadsNumber(), consistencyFlags, config, false, this.memoryLimit());
        return checker.execute(pageCache, stores, counts, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE, (Log)FormattedLog.toOutputStream((OutputStream)System.out));
    }

    protected NodeBasedMemoryLimiter.Factory memoryLimit() {
        return NodeBasedMemoryLimiter.DEFAULT;
    }

    private Config config() {
        return Config.newBuilder().set(GraphDatabaseSettings.record_format, (Object)this.getRecordFormatName()).set(this.getSettings()).build();
    }

    protected static RelationshipGroupRecord withRelationships(RelationshipGroupRecord group, long out, long in, long loop) {
        group.setFirstOut(out);
        group.setFirstIn(in);
        group.setFirstLoop(loop);
        return group;
    }

    private static RelationshipGroupRecord withRelationship(RelationshipGroupRecord group, Direction direction, long rel) {
        switch (direction) {
            case OUTGOING: {
                group.setFirstOut(rel);
                break;
            }
            case INCOMING: {
                group.setFirstIn(rel);
                break;
            }
            case BOTH: {
                group.setFirstLoop(rel);
                break;
            }
            default: {
                throw new IllegalArgumentException(direction.name());
            }
        }
        return group;
    }

    private static RelationshipRecord firstInChains(RelationshipRecord relationship, int count) {
        relationship.setFirstInFirstChain(true);
        relationship.setFirstPrevRel((long)count);
        relationship.setFirstInSecondChain(true);
        relationship.setSecondPrevRel((long)count);
        return relationship;
    }

    private static RelationshipGroupRecord withNext(RelationshipGroupRecord group, long next) {
        group.setNext(next);
        return group;
    }

    protected static RelationshipGroupRecord withOwner(RelationshipGroupRecord record, long owner) {
        record.setOwningNode(owner);
        return record;
    }

    protected String getRecordFormatName() {
        return "";
    }

    private int createLabel() throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int labelId = next.label();
                tx.nodeLabel(labelId, "label", false);
                id.setValue(labelId);
            }
        });
        return id.intValue();
    }

    private int createPropertyKey() throws Exception {
        return this.createPropertyKey("property");
    }

    private int createPropertyKey(final String propertyKey) throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int propertyKeyId = next.propertyKey();
                tx.propertyKey(propertyKeyId, propertyKey, false);
                id.setValue(propertyKeyId);
            }
        });
        return id.intValue();
    }

    private int createRelType() throws Exception {
        final MutableInt id = new MutableInt(-1);
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int relTypeId = next.relationshipType();
                tx.relationshipType(relTypeId, "relType", false);
                id.setValue(relTypeId);
            }
        });
        return id.intValue();
    }

    private void createIndexRule(final int labelId, final int ... propertyKeyIds) throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
                int id = (int)next.schema();
                IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyKeyIds), (IndexProviderDescriptor)DESCRIPTOR).withName("index_" + id).materialise((long)id);
                index = tx.completeConfiguration(index);
                SchemaRecord before = new SchemaRecord((long)id);
                SchemaRecord after = FullCheckIntegrationTest.this.cloneRecord(before);
                FullCheckIntegrationTest.this.serializeRule((SchemaRule)index, after, tx, next);
                tx.createSchema(before, after, (SchemaRule)index);
            }
        });
    }

    private void createUniquenessConstraintRule(int labelId, int ... propertyKeyIds) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId1 = schemaStore.nextId(PageCursorTracer.NULL);
        long ruleId2 = schemaStore.nextId(PageCursorTracer.NULL);
        String name = "constraint_" + ruleId2;
        IndexDescriptor indexRule = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyKeyIds), (IndexProviderDescriptor)DESCRIPTOR).withName(name).materialise(ruleId1).withOwningConstraintId(ruleId2);
        UniquenessConstraintDescriptor uniqueRule = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])propertyKeyIds).withId(ruleId2).withName(name).withOwnedIndexId(ruleId1);
        this.writeToSchemaStore(schemaStore, (SchemaRule)indexRule);
        this.writeToSchemaStore(schemaStore, (SchemaRule)uniqueRule);
    }

    private void createNodeKeyConstraintRule(int labelId, int ... propertyKeyIds) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId1 = schemaStore.nextId(PageCursorTracer.NULL);
        long ruleId2 = schemaStore.nextId(PageCursorTracer.NULL);
        String name = "constraint_" + ruleId2;
        IndexDescriptor indexRule = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)labelId, (int[])propertyKeyIds), (IndexProviderDescriptor)DESCRIPTOR).withName(name).materialise(ruleId1).withOwningConstraintId(ruleId2);
        NodeKeyConstraintDescriptor nodeKeyRule = ConstraintDescriptorFactory.nodeKeyForLabel((int)labelId, (int[])propertyKeyIds).withId(ruleId2).withName(name).withOwnedIndexId(ruleId1);
        this.writeToSchemaStore(schemaStore, (SchemaRule)indexRule);
        this.writeToSchemaStore(schemaStore, (SchemaRule)nodeKeyRule);
    }

    private void createNodePropertyExistenceConstraint(int labelId, int propertyKeyId) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        long ruleId = schemaStore.nextId(PageCursorTracer.NULL);
        ConstraintDescriptor rule = SchemaRuleUtil.nodePropertyExistenceConstraintRule((long)ruleId, (int)labelId, (int)propertyKeyId).withName("constraint_" + ruleId);
        this.writeToSchemaStore(schemaStore, (SchemaRule)rule);
    }

    private void createRelationshipPropertyExistenceConstraint(int relTypeId, int propertyKeyId) throws KernelException {
        SchemaStore schemaStore = this.fixture.directStoreAccess().nativeStores().getSchemaStore();
        ConstraintDescriptor rule = SchemaRuleUtil.relPropertyExistenceConstraintRule((long)schemaStore.nextId(PageCursorTracer.NULL), (int)relTypeId, (int)propertyKeyId);
        this.writeToSchemaStore(schemaStore, (SchemaRule)rule);
    }

    private void writeToSchemaStore(SchemaStore schemaStore, SchemaRule rule) throws KernelException {
        SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)schemaStore, (TokenHolders)this.fixture.writableTokenHolders());
        schemaRuleAccess.writeSchemaRule(rule, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private Iterator<IndexDescriptor> getIndexDescriptors() {
        StoreAccess storeAccess = this.fixture.directStoreAccess().nativeStores();
        TokenHolders tokenHolders = StoreTokens.readOnlyTokenHolders((NeoStores)storeAccess.getRawNeoStores(), (PageCursorTracer)PageCursorTracer.NULL);
        SchemaRuleAccess schema = SchemaRuleAccess.getSchemaRuleAccess((SchemaStore)storeAccess.getSchemaStore(), (TokenHolders)tokenHolders);
        return schema.indexesGetAll(PageCursorTracer.NULL);
    }

    protected static ConsistencySummaryVerifier on(ConsistencySummaryStatistics stats) {
        return new ConsistencySummaryVerifier(stats);
    }

    private void serializeRule(SchemaRule rule, SchemaRecord schemaRecord, GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) throws KernelException {
        IntObjectMap protoProperties = SchemaStore.convertSchemaRuleToMap((SchemaRule)rule, (TokenHolders)tx.tokenHolders());
        ArrayList blocks = new ArrayList();
        DynamicRecordAllocator stringAllocator = null;
        DynamicRecordAllocator arrayAllocator = null;
        protoProperties.forEachKeyValue((IntObjectProcedure & Serializable)(keyId, value) -> {
            PropertyBlock block = new PropertyBlock();
            PropertyStore.encodeValue((PropertyBlock)block, (int)keyId, (Value)value, (DynamicRecordAllocator)stringAllocator, (DynamicRecordAllocator)arrayAllocator, (boolean)true, (PageCursorTracer)PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            blocks.add(block);
        });
        long nextPropId = Record.NO_NEXT_PROPERTY.longValue();
        PropertyRecord currRecord = this.newInitialisedPropertyRecord(next, rule);
        for (PropertyBlock block : blocks) {
            if (!currRecord.hasSpaceFor(block)) {
                PropertyRecord nextRecord = this.newInitialisedPropertyRecord(next, rule);
                this.linkAndWritePropertyRecord(currRecord, nextRecord.getId(), nextPropId, tx);
                nextPropId = currRecord.getId();
                currRecord = nextRecord;
            }
            currRecord.addPropertyBlock(block);
        }
        this.linkAndWritePropertyRecord(currRecord, Record.NO_PREVIOUS_PROPERTY.longValue(), nextPropId, tx);
        nextPropId = currRecord.getId();
        schemaRecord.initialize(true, nextPropId);
        schemaRecord.setId(rule.getId());
    }

    private <T extends AbstractBaseRecord> T cloneRecord(T record) {
        return (T)record.copy();
    }

    private PropertyRecord newInitialisedPropertyRecord(GraphStoreFixture.IdGenerator next, SchemaRule rule) {
        PropertyRecord record = new PropertyRecord(next.property());
        record.setSchemaRuleId(rule.getId());
        return record;
    }

    private void linkAndWritePropertyRecord(PropertyRecord record, long prevPropId, long nextProp, GraphStoreFixture.TransactionDataBuilder tx) {
        record.setInUse(true);
        record.setPrevProp(prevPropId);
        record.setNextProp(nextProp);
        tx.update(this.cloneRecord(record).initialize(false, Record.NO_PREVIOUS_PROPERTY.longValue(), Record.NO_PREVIOUS_PROPERTY.longValue()), record);
    }

    private static RelationshipGroupRecord relationshipGroupRecord(long id, int type) {
        return new RelationshipGroupRecord(id).initialize(false, type, Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue());
    }

    protected static final class ConsistencySummaryVerifier {
        private final ConsistencySummaryStatistics stats;
        private final Set<RecordType> types = new HashSet<RecordType>();
        private long total;

        private ConsistencySummaryVerifier(ConsistencySummaryStatistics stats) {
            this.stats = stats;
        }

        public ConsistencySummaryVerifier verify(RecordType type, int inconsistencies) {
            if (!this.types.add(type)) {
                throw new IllegalStateException("Tried to verify the same type twice: " + type);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)inconsistencies, (int)this.stats.getInconsistencyCountForRecordType(type), (String)("Inconsistencies of type: " + type));
            this.total += (long)inconsistencies;
            return this;
        }

        public void andThatsAllFolks() {
            org.junit.jupiter.api.Assertions.assertEquals((long)this.total, (long)this.stats.getTotalInconsistencyCount(), (String)("Total number of inconsistencies: " + this.stats));
        }
    }

    private static class Reference<T> {
        private T value;

        private Reference() {
        }

        void set(T value) {
            this.value = value;
        }

        T get() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @FunctionalInterface
    private static interface EntityCreator {
        public void create(GraphStoreFixture.TransactionDataBuilder var1, GraphStoreFixture.IdGenerator var2, long var3);
    }
}

