/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.checking.index.IndexIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class IndexIteratorIT {
    private static final String INDEX_NAME = "index";
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private IndexProviderMap providerMap;
    @Inject
    private Config config;
    private IndexAccessors indexAccessors;
    private DefaultPageCacheTracer pageCacheTracer;

    IndexIteratorIT() {
    }

    @BeforeEach
    void setUp() throws IOException {
        Label label = Label.label((String)"any");
        String propertyName = "property";
        try (Transaction tx = this.database.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(propertyName, (Object)"nodeValue");
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().indexFor(label).on(propertyName).withName(INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        NeoStores neoStores = this.storageEngine.testAccessNeoStores();
        this.indexAccessors = new IndexAccessors(this.providerMap, neoStores, new IndexSamplingConfig(this.config), PageCacheTracer.NULL);
        this.pageCacheTracer = new DefaultPageCacheTracer();
    }

    @Test
    void tracePageCacheAccessOnIteration() throws Exception {
        List descriptors = this.indexAccessors.onlineRules();
        Assertions.assertThat((List)descriptors).hasSize(1);
        for (IndexDescriptor descriptor : descriptors) {
            try (IndexIterator indexIterator = new IndexIterator(this.indexAccessors.accessorFor(descriptor), (PageCacheTracer)this.pageCacheTracer);){
                org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)indexIterator.iterator()));
            }
        }
        Assertions.assertThat((long)this.pageCacheTracer.pins()).isOne();
        Assertions.assertThat((long)this.pageCacheTracer.unpins()).isOne();
        Assertions.assertThat((long)this.pageCacheTracer.hits()).isOne();
    }
}

