/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@DbmsExtension
class PropertyReaderIT {
    @Inject
    private GraphDatabaseAPI databaseAPI;
    @Inject
    private RecordStorageEngine storageEngine;
    private PropertyReader reader;
    private NeoStores neoStores;
    private DefaultPageCacheTracer pageCacheTracer;

    PropertyReaderIT() {
    }

    @BeforeEach
    void setUp() {
        this.neoStores = this.storageEngine.testAccessNeoStores();
        this.reader = new PropertyReader(new StoreAccess(this.neoStores));
        this.pageCacheTracer = new DefaultPageCacheTracer();
    }

    @Test
    void shouldDetectAndAbortPropertyChainLoadingOnCircularReference() {
        PropertyStore propertyStore = this.neoStores.getPropertyStore();
        PropertyRecord record = propertyStore.newRecord();
        record.setId(1L);
        record.initialize(true, -1L, 2L);
        propertyStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        record.setId(2L);
        record.initialize(true, 1L, 3L);
        propertyStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        record.setId(3L);
        record.initialize(true, 2L, 4L);
        propertyStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        record.setId(4L);
        record.initialize(true, 3L, 2L);
        propertyStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        PropertyReader.CircularPropertyRecordChainException e = (PropertyReader.CircularPropertyRecordChainException)org.junit.jupiter.api.Assertions.assertThrows(PropertyReader.CircularPropertyRecordChainException.class, () -> this.reader.getPropertyRecordChain(1L, PageCursorTracer.NULL));
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)e.propertyRecordClosingTheCircle().getId());
    }

    @Test
    void tracePageCacheAccessOnPropertyChainRead() throws PropertyReader.CircularPropertyRecordChainException {
        PropertyStore propertyStore = this.neoStores.getPropertyStore();
        PropertyRecord record = propertyStore.newRecord();
        record.setId(1L);
        record.initialize(true, -1L, 2L);
        propertyStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        record.setId(2L);
        record.initialize(true, 1L, -1L);
        propertyStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnPropertyChainRead");){
            this.reader.getPropertyRecordChain(1L, cursorTracer);
            PropertyReaderIT.assertCursorTracer(cursorTracer, 2);
        }
    }

    @Test
    void tracePageCacheAccessOnPropertyValueRead() {
        PropertyStore propertyStore = this.neoStores.getPropertyStore();
        PropertyRecord record = propertyStore.newRecord();
        record.setId(1L);
        record.initialize(true, -1L, -1L);
        PropertyBlock block = new PropertyBlock();
        TextValue expectedValue = Values.stringValue((String)RandomStringUtils.randomAscii((int)100));
        propertyStore.encodeValue(block, 1, (Value)expectedValue, PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        record.addPropertyBlock(block);
        propertyStore.updateRecord((AbstractBaseRecord)record, PageCursorTracer.NULL);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnPropertyValueRead");){
            block.getValueRecords().clear();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)block.isLight());
            this.reader.propertyValue(block, cursorTracer);
            PropertyReaderIT.assertCursorTracer(cursorTracer, 1);
        }
    }

    @Test
    void tracePageCacheAccessOnNodePropertyValueRead() {
        long nodeId;
        try (Transaction tx = this.databaseAPI.beginTx();){
            Node node = tx.createNode();
            node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)1024));
            nodeId = node.getId();
            tx.commit();
        }
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnPropertyValueRead");){
            this.reader.getNodePropertyValue(nodeId, 1, cursorTracer);
            PropertyReaderIT.assertCursorTracer(cursorTracer, 2);
        }
    }

    private static void assertCursorTracer(PageCursorTracer cursorTracer, int expectedValue) {
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo((long)expectedValue);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo((long)expectedValue);
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo((long)expectedValue);
    }
}

