/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.rule.TestDirectory;

@PageCacheExtension
@Neo4jLayoutExtension
@ExtendWith(value={SuppressOutputExtension.class})
public class ConsistencyCheckServiceIntegrationTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private GraphStoreFixture fixture;
    private DatabaseManagementService managementService;

    @BeforeEach
    void setUp() {
        this.fixture = new GraphStoreFixture(this.getRecordFormatName(), this.pageCache, this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    Node node1 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[0]);
                    Node node2 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"exampleValue")});
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                    tx.commit();
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return ConsistencyCheckServiceIntegrationTest.this.settings();
            }
        };
    }

    @AfterEach
    void tearDown() throws Exception {
        this.fixture.close();
    }

    @Test
    void reportNotUsedRelationshipReferencedInChain() throws Exception {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.defaults(this.settings());
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)reportFile.exists(), (String)"Consistency check report file should be generated.");
        ((AbstractStringAssert)Assertions.assertThat((String)Files.readString(reportFile.toPath())).as("Expected to see report about not deleted relationship record present as part of a chain", new Object[0])).contains(new CharSequence[]{"The relationship record is not in use, but referenced from relationships chain."});
    }

    @Test
    void tracePageCacheAccessOnConsistencyCheck() throws ConsistencyCheckIncompleteException {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        ConsistencyCheckService service = new ConsistencyCheckService(new Date());
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        ConsistencyCheckService.Result result = service.runFullConsistencyCheck(this.fixture.databaseLayout(), Config.defaults(this.settings()), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), this.testDirectory.getFileSystem(), this.pageCache, false, ConsistencyFlags.DEFAULT, (PageCacheTracer)pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful());
        Assertions.assertThat((long)pageCacheTracer.pins()).isGreaterThanOrEqualTo(74L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isGreaterThanOrEqualTo(74L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isGreaterThanOrEqualTo(35L);
        Assertions.assertThat((long)pageCacheTracer.faults()).isGreaterThanOrEqualTo(39L);
    }

    @Test
    void shouldFailOnDatabaseInNeedOfRecovery() throws IOException {
        this.nonRecoveredDatabase();
        ConsistencyCheckService service = new ConsistencyCheckService();
        try {
            Config defaults = Config.defaults(this.settings());
            this.runFullConsistencyCheck(service, defaults);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (ConsistencyCheckIncompleteException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)e.getCause().getMessage(), (Object)Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database.", "To perform recovery please start database in single mode and perform clean shutdown."}));
        }
    }

    @Test
    void ableToDeleteDatabaseDirectoryAfterConsistencyCheckRun() throws ConsistencyCheckIncompleteException, IOException {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        ConsistencyCheckService service = new ConsistencyCheckService();
        ConsistencyCheckService.Result consistencyCheck = this.runFullConsistencyCheck(service, Config.defaults(this.settings()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consistencyCheck.isSuccessful());
        org.apache.commons.io.FileUtils.deleteDirectory((File)this.fixture.databaseLayout().databaseDirectory());
    }

    @Test
    void shouldSucceedIfStoreIsConsistent() throws Exception {
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.defaults(this.settings());
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)reportFile.exists(), (String)("Unexpected generation of consistency check report file: " + reportFile));
    }

    @Test
    void shouldFailIfTheStoreInNotConsistent() throws Exception {
        this.breakNodeStore();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Path logsDir = this.testDirectory.homeDir().toPath();
        Config configuration = Config.newBuilder().set(this.settings()).set(GraphDatabaseSettings.logs_directory, (Object)logsDir).build();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful());
        String reportFile = String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(timestamp));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new File(logsDir.toString(), reportFile), (Object)result.reportFile());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.reportFile().exists(), (String)"Inconsistency report file not generated");
    }

    @Test
    void shouldNotReportDuplicateForHugeLongValues() throws Exception {
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings());
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setConfig(this.settings()).build();
        GraphDatabaseService db = managementService.database("neo4j");
        String propertyKey = "itemId";
        Label label = Label.label((String)"Item");
        try (Transaction tx = db.beginTx();){
            tx.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Property.set((Entity)tx.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596880L)});
            Property.set((Entity)tx.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596864L)});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        managementService.shutdown();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldReportMissingSchemaIndex() throws Exception {
        GraphDatabaseService gds = this.getGraphDatabaseService(this.testDirectory.homeDir());
        Label label = Label.label((String)"label");
        String propKey = "propKey";
        ConsistencyCheckServiceIntegrationTest.createIndex(gds, label, propKey);
        this.managementService.shutdown();
        File schemaDir = ConsistencyCheckServiceIntegrationTest.findFile(this.databaseLayout, "schema");
        FileUtils.deleteRecursively((File)schemaDir);
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings());
        ConsistencyCheckService.Result result = ConsistencyCheckServiceIntegrationTest.runFullConsistencyCheck(service, configuration, this.databaseLayout);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
        File reportFile = result.reportFile();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)reportFile.exists(), (String)"Consistency check report file should be generated.");
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)Files.readString(reportFile.toPath())).as("Expected to see report about schema index not being online", new Object[0])).contains(new CharSequence[]{"schema rule"})).contains(new CharSequence[]{"not online"});
    }

    @Test
    void oldLuceneSchemaIndexShouldBeConsideredConsistentWithFusionProvider() throws Exception {
        Label label = Label.label((String)"label");
        String propKey = "propKey";
        GraphDatabaseService db = this.getGraphDatabaseService(this.databaseLayout.databaseDirectory(), Map.of(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE30.providerName()));
        ConsistencyCheckServiceIntegrationTest.createIndex(db, label, propKey);
        try (Transaction tx = db.beginTx();){
            tx.createNode(new Label[]{label}).setProperty(propKey, (Object)1);
            tx.createNode(new Label[]{label}).setProperty(propKey, (Object)"string");
            tx.commit();
        }
        this.managementService.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.newBuilder().set(this.settings()).set(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName()).build();
        ConsistencyCheckService.Result result = ConsistencyCheckServiceIntegrationTest.runFullConsistencyCheck(service, configuration, this.databaseLayout);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
    }

    private static void createIndex(GraphDatabaseService gds, Label label, String propKey) {
        try (Transaction tx = gds.beginTx();){
            tx.schema().indexFor(label).on(propKey).create();
            tx.commit();
        }
        tx = gds.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static File findFile(DatabaseLayout databaseLayout, String targetFile) {
        File file = databaseLayout.file(targetFile);
        if (!file.exists()) {
            org.junit.jupiter.api.Assertions.fail((String)("Could not find file " + targetFile));
        }
        return file;
    }

    private GraphDatabaseService getGraphDatabaseService(File homeDir) {
        return this.getGraphDatabaseService(homeDir, Map.of());
    }

    private GraphDatabaseService getGraphDatabaseService(File homeDir, Map<Setting<?>, Object> settings) {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(homeDir);
        builder.setConfig(this.settings());
        builder.setConfig(settings);
        this.managementService = builder.build();
        return this.managementService.database("neo4j");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareDbWithDeletedRelationshipPartOfTheChain() {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setConfig(GraphDatabaseSettings.record_format, (Object)this.getRecordFormatName()).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            RelationshipType relationshipType = RelationshipType.withName((String)"testRelationshipType");
            try (Transaction tx = db.beginTx();){
                Node node1 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[0]);
                Node node2 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                node1.createRelationshipTo(node2, relationshipType);
                tx.commit();
            }
            RecordStorageEngine recordStorageEngine = (RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            NeoStores neoStores = recordStorageEngine.testAccessNeoStores();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
            RelationshipRecord record = (RelationshipRecord)relationshipStore.getRecord(4L, (AbstractBaseRecord)relationshipRecord, RecordLoad.FORCE, PageCursorTracer.NULL);
            record.setInUse(false);
            relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord, PageCursorTracer.NULL);
        }
        finally {
            managementService.shutdown();
        }
    }

    private void nonRecoveredDatabase() throws IOException {
        File[] txLogs;
        File tmpLogDir = new File(this.testDirectory.homeDir(), "logs");
        this.fs.mkdir(tmpLogDir);
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir()).setConfig(this.settings()).build();
        GraphDatabaseAPI db = (GraphDatabaseAPI)managementService.database("neo4j");
        RelationshipType relationshipType = RelationshipType.withName((String)"testRelationshipType");
        try (Transaction tx = db.beginTx();){
            Node node1 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[0]);
            Node node2 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
            node1.createRelationshipTo(node2, relationshipType);
            tx.commit();
        }
        for (File file : txLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fs).withCommandReaderFactory(RecordStorageCommandReaderFactory.INSTANCE).build().logFiles()) {
            this.fs.copyToDirectory(file, tmpLogDir);
        }
        managementService.shutdown();
        for (File txLog : txLogs) {
            this.fs.deleteFile(txLog);
        }
        for (File file : LogFilesBuilder.logFilesBasedOnlyBuilder((File)tmpLogDir, (FileSystemAbstraction)this.fs).build().logFiles()) {
            this.fs.moveToDirectory(file, this.databaseLayout.getTransactionLogsDirectory());
        }
    }

    protected Map<Setting<?>, Object> settings() {
        HashMap defaults = new HashMap();
        defaults.put(GraphDatabaseSettings.pagecache_memory, "8m");
        defaults.put(GraphDatabaseSettings.logs_directory, this.databaseLayout.databaseDirectory().toPath());
        defaults.put(GraphDatabaseSettings.record_format, this.getRecordFormatName());
        return defaults;
    }

    private void breakNodeStore() throws KernelException {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
            }
        });
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration) throws ConsistencyCheckIncompleteException {
        return ConsistencyCheckServiceIntegrationTest.runFullConsistencyCheck(service, configuration, this.fixture.databaseLayout());
    }

    private static ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration, DatabaseLayout databaseLayout) throws ConsistencyCheckIncompleteException {
        return service.runFullConsistencyCheck(databaseLayout, configuration, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
    }

    protected String getRecordFormatName() {
        return "";
    }
}

