/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.TransactionWriter;
import org.neo4j.consistency.internal.SchemaIndexExtensionLoader;
import org.neo4j.consistency.statistics.AccessStatistics;
import org.neo4j.consistency.statistics.AccessStatsKeepingStoreAccess;
import org.neo4j.consistency.statistics.Counts;
import org.neo4j.consistency.statistics.DefaultCounts;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.statistics.VerboseStatistics;
import org.neo4j.consistency.store.DirectStoreAccess;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.index.label.FullStoreChangeStream;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.RecordStorageReader;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.extension.DatabaseExtensions;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.api.scan.FullRelationshipTypeStream;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.lock.LockService;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;

public abstract class GraphStoreFixture
implements AutoCloseable {
    private DirectStoreAccess directStoreAccess;
    private Statistics statistics;
    private final boolean keepStatistics;
    private NeoStores neoStore;
    private StorageReader storeReader;
    private long schemaId;
    private long nodeId;
    private int labelId;
    private long nodeLabelsId;
    private long relId;
    private long relGroupId;
    private int propId;
    private long stringPropId;
    private long arrayPropId;
    private int relTypeId;
    private int propKeyId;
    private DefaultFileSystemAbstraction fileSystem;
    private final LifeSupport storeLife = new LifeSupport();
    private final LifeSupport fixtureLife = new LifeSupport();
    private String formatName;
    private final PageCache pageCache;
    private final TestDirectory testDirectory;
    private LabelScanStore labelScanStore;
    private RelationshipTypeScanStore relationshipTypeScanStore;
    private IndexStatisticsStore indexStatisticsStore;
    private ThreadPoolJobScheduler jobScheduler;
    private CountsStore counts;

    private GraphStoreFixture(boolean keepStatistics, String formatName, PageCache pageCache, TestDirectory testDirectory) {
        this.keepStatistics = keepStatistics;
        this.formatName = formatName;
        this.pageCache = pageCache;
        this.testDirectory = testDirectory;
        this.generateInitialData();
    }

    protected GraphStoreFixture(String formatName, PageCache pageCache, TestDirectory testDirectory) {
        this(false, formatName, pageCache, testDirectory);
    }

    @Override
    public void close() throws Exception {
        this.stop();
        this.storeLife.shutdown();
        this.fixtureLife.shutdown();
        IOUtils.closeAllSilently((AutoCloseable[])new DefaultFileSystemAbstraction[]{this.fileSystem});
    }

    public void apply(Transaction transaction) throws KernelException {
        this.applyTransaction(transaction);
    }

    public DirectStoreAccess directStoreAccess() {
        return this.directStoreAccess(false);
    }

    public DirectStoreAccess readOnlyDirectStoreAccess() {
        return this.directStoreAccess(true);
    }

    public PageCache getInstantiatedPageCache() {
        return this.pageCache;
    }

    private DirectStoreAccess directStoreAccess(boolean readOnly) {
        if (this.directStoreAccess == null) {
            StoreAccess nativeStores;
            this.fileSystem = new DefaultFileSystemAbstraction();
            this.jobScheduler = new ThreadPoolJobScheduler("Fixture-");
            NullLogProvider logProvider = NullLogProvider.getInstance();
            Config config = Config.newBuilder().set(GraphDatabaseSettings.read_only, (Object)readOnly).set(this.getConfig()).build();
            DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fileSystem, RecoveryCleanupWorkCollector.immediate());
            StoreFactory storeFactory = new StoreFactory(this.databaseLayout(), config, (IdGeneratorFactory)idGeneratorFactory, this.pageCache, (FileSystemAbstraction)this.fileSystem, (LogProvider)logProvider, PageCacheTracer.NULL);
            this.neoStore = storeFactory.openAllNeoStores();
            if (this.keepStatistics) {
                AccessStatistics accessStatistics = new AccessStatistics();
                this.statistics = new VerboseStatistics(accessStatistics, (Counts)new DefaultCounts(ConsistencyCheckService.defaultConsistencyCheckThreadsNumber()), (Log)NullLog.getInstance());
                nativeStores = new AccessStatsKeepingStoreAccess(this.neoStore, accessStatistics);
            } else {
                this.statistics = Statistics.NONE;
                nativeStores = new StoreAccess(this.neoStore);
            }
            nativeStores.initialize();
            this.fixtureLife.start();
            this.storeLife.start();
            NeoStoreIndexStoreView indexStoreView = new NeoStoreIndexStoreView(LockService.NO_LOCK_SERVICE, () -> new RecordStorageReader(nativeStores.getRawNeoStores()));
            Monitors monitors = new Monitors();
            this.labelScanStore = this.startLabelScanStore(this.pageCache, (IndexStoreView)indexStoreView, monitors, readOnly);
            this.relationshipTypeScanStore = this.startRelationshipTypeScanStore(this.pageCache, (IndexStoreView)indexStoreView, monitors, readOnly, config);
            IndexProviderMap indexes = this.createIndexes(this.pageCache, config, (LogProvider)logProvider, monitors);
            this.indexStatisticsStore = this.startIndexStatisticsStore(readOnly);
            this.directStoreAccess = new DirectStoreAccess(nativeStores, this.labelScanStore, this.relationshipTypeScanStore, indexes, StoreTokens.readOnlyTokenHolders((NeoStores)this.neoStore, (PageCursorTracer)PageCursorTracer.NULL), this.indexStatisticsStore, (IdGeneratorFactory)idGeneratorFactory);
            this.storeReader = new RecordStorageReader(this.neoStore);
        }
        return this.directStoreAccess;
    }

    private IndexStatisticsStore startIndexStatisticsStore(boolean readOnly) {
        IndexStatisticsStore indexStatisticsStore = new IndexStatisticsStore(this.pageCache, this.databaseLayout(), RecoveryCleanupWorkCollector.immediate(), readOnly, PageCacheTracer.NULL);
        try {
            indexStatisticsStore.init();
            indexStatisticsStore.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return indexStatisticsStore;
    }

    public ThrowingSupplier<CountsStore, IOException> counts() {
        return () -> {
            if (this.counts == null) {
                this.counts = new GBPTreeCountsStore(this.pageCache, this.databaseLayout().countStore(), (FileSystemAbstraction)this.fileSystem, RecoveryCleanupWorkCollector.immediate(), new CountsBuilder(){

                    public void initialize(CountsAccessor.Updater updater, PageCursorTracer cursorTracer, MemoryTracker memoryTracker) {
                        throw new UnsupportedOperationException("Should not be rebuilt");
                    }

                    public long lastCommittedTxId() {
                        return 0L;
                    }
                }, true, PageCacheTracer.NULL, GBPTreeCountsStore.NO_MONITOR);
                this.counts.start(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            }
            return this.counts;
        };
    }

    private LabelScanStore startLabelScanStore(PageCache pageCache, IndexStoreView indexStoreView, Monitors monitors, boolean readOnly) {
        FullLabelStream labelStream = new FullLabelStream(indexStoreView);
        LabelScanStore labelScanStore = TokenScanStore.labelScanStore((PageCache)pageCache, (DatabaseLayout)this.databaseLayout(), (FileSystemAbstraction)this.fileSystem, (FullStoreChangeStream)labelStream, (boolean)readOnly, (Monitors)monitors, (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.immediate(), (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            labelScanStore.init();
            labelScanStore.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return labelScanStore;
    }

    private RelationshipTypeScanStore startRelationshipTypeScanStore(PageCache pageCache, IndexStoreView indexStoreView, Monitors monitors, boolean readOnly, Config config) {
        FullRelationshipTypeStream typeStream = new FullRelationshipTypeStream(indexStoreView);
        RelationshipTypeScanStore relationshipTypeScanStore = TokenScanStore.toggledRelationshipTypeScanStore((PageCache)pageCache, (DatabaseLayout)this.databaseLayout(), (FileSystemAbstraction)this.fileSystem, (FullStoreChangeStream)typeStream, (boolean)readOnly, (Monitors)monitors, (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.immediate(), (Config)config, (PageCacheTracer)PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            relationshipTypeScanStore.init();
            relationshipTypeScanStore.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return relationshipTypeScanStore;
    }

    private IndexProviderMap createIndexes(PageCache pageCache, Config config, LogProvider logProvider, Monitors monitors) {
        SimpleLogService logService = new SimpleLogService(logProvider, logProvider);
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "PropertyKey"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "Label"), (TokenHolder)new DelegatingTokenHolder((TokenCreator)new ReadOnlyTokenCreator(), "RelationshipType"));
        DatabaseExtensions extensions = (DatabaseExtensions)this.fixtureLife.add((Lifecycle)SchemaIndexExtensionLoader.instantiateExtensions((DatabaseLayout)this.databaseLayout(), (FileSystemAbstraction)this.fileSystem, (Config)config, (LogService)logService, (PageCache)pageCache, (JobScheduler)this.jobScheduler, (RecoveryCleanupWorkCollector)RecoveryCleanupWorkCollector.ignore(), (DbmsInfo)DbmsInfo.COMMUNITY, (Monitors)monitors, (TokenHolders)tokenHolders));
        return (IndexProviderMap)this.fixtureLife.add((Lifecycle)new DefaultIndexProviderMap((DependencyResolver)extensions, config));
    }

    public DatabaseLayout databaseLayout() {
        return Neo4jLayout.of((File)this.testDirectory.homeDir()).databaseLayout("neo4j");
    }

    public Statistics getAccessStatistics() {
        return this.statistics;
    }

    public EntityUpdates nodeAsUpdates(long nodeId) {
        try (StorageNodeCursor nodeCursor = this.storeReader.allocateNodeCursor(PageCursorTracer.NULL);){
            EntityUpdates entityUpdates;
            block17: {
                long[] labels;
                StoragePropertyCursor propertyCursor;
                block15: {
                    EntityUpdates entityUpdates2;
                    block16: {
                        propertyCursor = this.storeReader.allocatePropertyCursor(PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                        nodeCursor.single(nodeId);
                        if (nodeCursor.next() && nodeCursor.hasProperties() && (labels = nodeCursor.labels()).length != 0) break block15;
                        entityUpdates2 = null;
                        if (propertyCursor == null) break block16;
                        propertyCursor.close();
                    }
                    return entityUpdates2;
                }
                try {
                    nodeCursor.properties(propertyCursor);
                    EntityUpdates.Builder update = EntityUpdates.forEntity((long)nodeId, (boolean)true).withTokens(labels);
                    while (propertyCursor.next()) {
                        update.added(propertyCursor.propertyKey(), propertyCursor.propertyValue());
                    }
                    entityUpdates = update.build();
                    if (propertyCursor == null) break block17;
                }
                catch (Throwable throwable) {
                    if (propertyCursor != null) {
                        try {
                            propertyCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                propertyCursor.close();
            }
            return entityUpdates;
        }
    }

    public TokenHolders writableTokenHolders() {
        DelegatingTokenHolder propertyKeyTokens = new DelegatingTokenHolder(this.buildTokenCreator((name, internal, tx, next) -> {
            int id = next.propertyKey();
            tx.propertyKey(id, name, internal);
            return id;
        }), "PropertyKey");
        DelegatingTokenHolder labelTokens = new DelegatingTokenHolder(this.buildTokenCreator((name, internal, tx, next) -> {
            int id = next.label();
            tx.nodeLabel(id, name, internal);
            return id;
        }), "Label");
        DelegatingTokenHolder relationshipTypeTokens = new DelegatingTokenHolder(this.buildTokenCreator((name, internal, tx, next) -> {
            int id = next.relationshipType();
            tx.relationshipType(id, name, internal);
            return id;
        }), "RelationshipType");
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)propertyKeyTokens, (TokenHolder)labelTokens, (TokenHolder)relationshipTypeTokens);
        tokenHolders.setInitialTokens(StoreTokens.allReadableTokens((NeoStores)this.directStoreAccess().nativeStores().getRawNeoStores()), PageCursorTracer.NULL);
        return tokenHolders;
    }

    private TokenCreator buildTokenCreator(final TokenChange propChange) {
        return (name, internal) -> {
            final MutableInt keyId = new MutableInt();
            this.applyTransaction(new Transaction(){

                @Override
                protected void transactionData(TransactionDataBuilder tx, IdGenerator next) {
                    keyId.setValue(propChange.createToken(name, internal, tx, next));
                }
            });
            return keyId.intValue();
        };
    }

    public IdGenerator idGenerator() {
        return new IdGenerator();
    }

    protected abstract void generateInitialData(GraphDatabaseService var1);

    void stop() throws IOException {
        if (this.directStoreAccess != null) {
            this.storeLife.shutdown();
            this.storeReader.close();
            this.neoStore.close();
            this.labelScanStore.shutdown();
            this.relationshipTypeScanStore.shutdown();
            this.indexStatisticsStore.shutdown();
            this.jobScheduler.shutdown();
            this.directStoreAccess = null;
            if (this.counts != null) {
                this.counts.close();
                this.counts = null;
            }
        }
    }

    public Applier createApplier() {
        return new Applier();
    }

    private void applyTransaction(Transaction transaction) throws KernelException {
        try (Applier applier = this.createApplier();){
            applier.apply(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateInitialData() {
        TestDatabaseManagementServiceBuilder builder = new TestDatabaseManagementServiceBuilder(this.testDirectory.homeDir());
        DatabaseManagementService managementService = builder.setConfig(GraphDatabaseSettings.record_format, (Object)this.formatName).setConfig(GraphDatabaseInternalSettings.label_block_size, (Object)60).setConfig(GraphDatabaseInternalSettings.consistency_check_on_apply, (Object)false).setConfig(this.getConfig()).build();
        GraphDatabaseAPI graphDb = (GraphDatabaseAPI)managementService.database("neo4j");
        try {
            this.generateInitialData((GraphDatabaseService)graphDb);
            RecordStorageEngine storageEngine = (RecordStorageEngine)graphDb.getDependencyResolver().resolveDependency(RecordStorageEngine.class);
            StoreAccess stores = new StoreAccess(storageEngine.testAccessNeoStores()).initialize();
            this.schemaId = stores.getSchemaStore().getHighId();
            this.nodeId = stores.getNodeStore().getHighId();
            this.labelId = (int)stores.getLabelTokenStore().getHighId();
            this.nodeLabelsId = stores.getNodeDynamicLabelStore().getHighId();
            this.relId = stores.getRelationshipStore().getHighId();
            this.relGroupId = stores.getRelationshipGroupStore().getHighId();
            this.propId = (int)stores.getPropertyStore().getHighId();
            this.stringPropId = stores.getStringStore().getHighId();
            this.arrayPropId = stores.getArrayStore().getHighId();
            this.relTypeId = (int)stores.getRelationshipTypeTokenStore().getHighId();
            this.propKeyId = (int)stores.getPropertyKeyNameStore().getHighId();
        }
        finally {
            managementService.shutdown();
        }
    }

    protected abstract Map<Setting<?>, Object> getConfig();

    public class Applier
    implements AutoCloseable {
        private final GraphDatabaseAPI database;
        private final TransactionRepresentationCommitProcess commitProcess;
        private final TransactionIdStore transactionIdStore;
        private final NeoStores neoStores;
        private final DatabaseManagementService managementService;
        private final IndexingService indexingService;

        Applier() {
            this.managementService = new TestDatabaseManagementServiceBuilder(GraphStoreFixture.this.testDirectory.homeDir()).setConfig(GraphDatabaseInternalSettings.consistency_check_on_apply, (Object)false).setConfig(GraphStoreFixture.this.getConfig()).build();
            this.database = (GraphDatabaseAPI)this.managementService.database("neo4j");
            DependencyResolver dependencyResolver = this.database.getDependencyResolver();
            this.commitProcess = new TransactionRepresentationCommitProcess((TransactionAppender)dependencyResolver.resolveDependency(TransactionAppender.class), (StorageEngine)dependencyResolver.resolveDependency(StorageEngine.class));
            this.transactionIdStore = (TransactionIdStore)this.database.getDependencyResolver().resolveDependency(TransactionIdStore.class);
            this.neoStores = ((RecordStorageEngine)dependencyResolver.resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
            this.indexingService = (IndexingService)dependencyResolver.resolveDependency(IndexingService.class);
        }

        public void apply(Transaction transaction) throws KernelException {
            TransactionRepresentation representation = transaction.representation(GraphStoreFixture.this.idGenerator(), this.transactionIdStore.getLastCommittedTransactionId(), this.neoStores, this.indexingService);
            this.commitProcess.commit(new TransactionToApply(representation, PageCursorTracer.NULL), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        }

        @Override
        public void close() {
            this.managementService.shutdown();
        }
    }

    public static final class TransactionDataBuilder {
        private final TransactionWriter writer;
        private final NodeStore nodes;
        private final IndexingService indexingService;
        private final TokenHolders tokenHolders;
        private final AtomicInteger propKeyDynIds = new AtomicInteger(1);
        private final AtomicInteger labelDynIds = new AtomicInteger(1);
        private final AtomicInteger relTypeDynIds = new AtomicInteger(1);

        TransactionDataBuilder(TransactionWriter writer, NeoStores neoStores, IdGenerator next, IndexingService indexingService) {
            this.writer = writer;
            this.nodes = neoStores.getNodeStore();
            this.indexingService = indexingService;
            DelegatingTokenHolder propTokens = new DelegatingTokenHolder((name, internal) -> {
                int id = next.propertyKey();
                writer.propertyKey(id, name, internal, this.dynIds(0, this.propKeyDynIds, name));
                return id;
            }, "PropertyKey");
            DelegatingTokenHolder labelTokens = new DelegatingTokenHolder((name, internal) -> {
                int id = next.label();
                writer.label(id, name, internal, this.dynIds(0, this.labelDynIds, name));
                return id;
            }, "Label");
            DelegatingTokenHolder relTypeTokens = new DelegatingTokenHolder((name, internal) -> {
                int id = next.relationshipType();
                writer.relationshipType(id, name, internal, this.dynIds(0, this.relTypeDynIds, name));
                return id;
            }, "RelationshipType");
            this.tokenHolders = new TokenHolders((TokenHolder)propTokens, (TokenHolder)labelTokens, (TokenHolder)relTypeTokens);
            this.tokenHolders.setInitialTokens(StoreTokens.allReadableTokens((NeoStores)neoStores), PageCursorTracer.NULL);
            this.tokenHolders.propertyKeyTokens().getAllTokens().forEach(token -> this.propKeyDynIds.getAndUpdate(id -> Math.max(id, token.id() + 1)));
            this.tokenHolders.labelTokens().getAllTokens().forEach(token -> this.labelDynIds.getAndUpdate(id -> Math.max(id, token.id() + 1)));
            this.tokenHolders.relationshipTypeTokens().getAllTokens().forEach(token -> this.relTypeDynIds.getAndUpdate(id -> Math.max(id, token.id() + 1)));
        }

        private int[] dynIds(int externalBase, AtomicInteger idGenerator, String name) {
            if (idGenerator.get() <= externalBase) {
                idGenerator.set(externalBase + 1);
            }
            byte[] bytes = name.getBytes(StandardCharsets.UTF_8);
            int blocks = 1 + bytes.length / 30;
            int base = idGenerator.getAndAdd(blocks);
            int[] ids = new int[blocks];
            for (int i = 0; i < blocks; ++i) {
                ids[i] = base + i;
            }
            return ids;
        }

        public TokenHolders tokenHolders() {
            return this.tokenHolders;
        }

        public void createSchema(SchemaRecord before, SchemaRecord after, SchemaRule rule) {
            this.writer.createSchema(before, after, rule);
        }

        public void propertyKey(int id, String key, boolean internal) {
            this.writer.propertyKey(id, key, internal, this.dynIds(id, this.propKeyDynIds, key));
            this.tokenHolders.propertyKeyTokens().addToken(new NamedToken(key, id));
        }

        public void nodeLabel(int id, String name, boolean internal) {
            this.writer.label(id, name, internal, this.dynIds(id, this.labelDynIds, name));
            this.tokenHolders.labelTokens().addToken(new NamedToken(name, id));
        }

        public void relationshipType(int id, String relationshipType, boolean internal) {
            this.writer.relationshipType(id, relationshipType, internal, this.dynIds(id, this.relTypeDynIds, relationshipType));
            this.tokenHolders.relationshipTypeTokens().addToken(new NamedToken(relationshipType, id));
        }

        public void create(NodeRecord node) {
            this.updateCounts(node, 1);
            this.writer.create(node);
        }

        public void update(NodeRecord before, NodeRecord after) {
            this.updateCounts(before, -1);
            this.updateCounts(after, 1);
            this.writer.update(before, after);
        }

        public void delete(NodeRecord node) {
            this.updateCounts(node, -1);
            this.writer.delete(node);
        }

        public void create(RelationshipRecord relationship) {
            this.writer.create(relationship);
        }

        public void update(RelationshipRecord before, RelationshipRecord after) {
            this.writer.update(before, after);
        }

        public void delete(RelationshipRecord relationship) {
            this.writer.delete(relationship);
        }

        public void create(RelationshipGroupRecord group) {
            this.writer.create(group);
        }

        public void update(RelationshipGroupRecord before, RelationshipGroupRecord after) {
            this.writer.update(before, after);
        }

        public void delete(RelationshipGroupRecord group) {
            this.writer.delete(group);
        }

        public void create(PropertyRecord property) {
            this.writer.create(property);
        }

        public void update(PropertyRecord before, PropertyRecord property) {
            this.writer.update(before, property);
        }

        public void delete(PropertyRecord before, PropertyRecord property) {
            this.writer.delete(before, property);
        }

        private void updateCounts(NodeRecord node, int delta) {
            this.writer.incrementNodeCount(-1, delta);
            for (long label : NodeLabelsField.parseLabelsField((NodeRecord)node).get(this.nodes, PageCursorTracer.NULL)) {
                this.writer.incrementNodeCount((int)label, delta);
            }
        }

        public void incrementNodeCount(int labelId, long delta) {
            this.writer.incrementNodeCount(labelId, delta);
        }

        public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
            this.writer.incrementRelationshipCount(startLabelId, typeId, endLabelId, delta);
        }

        public IndexDescriptor completeConfiguration(IndexDescriptor indexDescriptor) {
            return this.indexingService.completeConfiguration(indexDescriptor);
        }
    }

    public class IdGenerator {
        public long schema() {
            return GraphStoreFixture.this.schemaId++;
        }

        public long node() {
            return GraphStoreFixture.this.nodeId++;
        }

        public int label() {
            return GraphStoreFixture.this.labelId++;
        }

        public long nodeLabel() {
            return GraphStoreFixture.this.nodeLabelsId++;
        }

        public long relationship() {
            return GraphStoreFixture.this.relId++;
        }

        public long relationshipGroup() {
            return GraphStoreFixture.this.relGroupId++;
        }

        public long property() {
            return GraphStoreFixture.this.propId++;
        }

        public long stringProperty() {
            return GraphStoreFixture.this.stringPropId++;
        }

        public long arrayProperty() {
            return GraphStoreFixture.this.arrayPropId++;
        }

        public int relationshipType() {
            return GraphStoreFixture.this.relTypeId++;
        }

        public int propertyKey() {
            return GraphStoreFixture.this.propKeyId++;
        }

        void updateCorrespondingIdGenerators(NeoStores neoStores) {
            neoStores.getNodeStore().setHighestPossibleIdInUse(GraphStoreFixture.this.nodeId);
            neoStores.getRelationshipStore().setHighestPossibleIdInUse(GraphStoreFixture.this.relId);
            neoStores.getRelationshipGroupStore().setHighestPossibleIdInUse(GraphStoreFixture.this.relGroupId);
        }
    }

    public static abstract class Transaction {
        final long startTimestamp = System.currentTimeMillis();

        protected abstract void transactionData(TransactionDataBuilder var1, IdGenerator var2) throws KernelException;

        public TransactionRepresentation representation(IdGenerator idGenerator, long lastCommittedTx, NeoStores neoStores, IndexingService indexingService) throws KernelException {
            TransactionWriter writer = new TransactionWriter(neoStores);
            this.transactionData(new TransactionDataBuilder(writer, neoStores, idGenerator, indexingService), idGenerator);
            idGenerator.updateCorrespondingIdGenerators(neoStores);
            return writer.representation(new byte[0], this.startTimestamp, lastCommittedTx, System.currentTimeMillis());
        }
    }

    @FunctionalInterface
    static interface TokenChange {
        public int createToken(String var1, boolean var2, TransactionDataBuilder var3, IdGenerator var4);
    }
}

