/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheTask;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class CacheTaskTrackingIT {
    private static final long NODE_COUNT = 1000L;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;

    CacheTaskTrackingIT() {
    }

    @Test
    void trackPageCacheAccessOnProcessCache() {
        try (Transaction tx = this.database.beginTx();){
            int i = 0;
            while ((long)i < 1000L) {
                tx.createNode();
                ++i;
            }
            tx.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        StoreAccess storeAccess = new StoreAccess(this.storageEngine.testAccessNeoStores());
        storeAccess.initialize();
        CacheAccess cacheAccess = CacheAccess.EMPTY;
        Stage stage = Stage.SEQUENTIAL_FORWARD;
        this.assertZeroTracer(pageCacheTracer);
        StoreProcessor storeProcessor = new StoreProcessor(CheckDecorator.NONE, ConsistencyReport.NO_REPORT, stage, cacheAccess);
        CacheTask.CheckNextRel task = new CacheTask.CheckNextRel(stage, cacheAccess, storeAccess, storeProcessor, (PageCacheTracer)pageCacheTracer);
        task.run();
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(1000L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(1000L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(1000L);
    }

    private void assertZeroTracer(DefaultPageCacheTracer pageCacheTracer) {
        Assertions.assertThat((long)pageCacheTracer.pins()).isZero();
        Assertions.assertThat((long)pageCacheTracer.unpins()).isZero();
        Assertions.assertThat((long)pageCacheTracer.hits()).isZero();
    }
}

