/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.checking.full.IterableStore;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class IterableStoreIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    private DefaultPageCacheTracer pageCacheTracer;

    IterableStoreIT() {
    }

    @BeforeEach
    void setUp() {
        this.pageCacheTracer = new DefaultPageCacheTracer();
        this.prepareTestData();
    }

    @Test
    void tracePageCacheAccessOnWarmup() {
        try (IterableStore iterableStore = new IterableStore((RecordStore)this.storageEngine.testAccessNeoStores().getNodeStore(), true, (PageCacheTracer)this.pageCacheTracer);){
            iterableStore.warmUpCache();
        }
        Assertions.assertThat((long)this.pageCacheTracer.pins()).isEqualTo(10L);
        Assertions.assertThat((long)this.pageCacheTracer.unpins()).isEqualTo(10L);
        Assertions.assertThat((long)this.pageCacheTracer.hits()).isEqualTo(10L);
    }

    @Test
    void tracePageCacheAccessOnIterations() {
        try (IterableStore iterableStore = new IterableStore((RecordStore)this.storageEngine.testAccessNeoStores().getNodeStore(), true, (PageCacheTracer)this.pageCacheTracer);){
            org.junit.jupiter.api.Assertions.assertEquals((long)10000L, (long)Iterators.count((Iterator)iterableStore.iterator()));
        }
        Assertions.assertThat((long)this.pageCacheTracer.pins()).isEqualTo(19L);
        Assertions.assertThat((long)this.pageCacheTracer.unpins()).isEqualTo(19L);
        Assertions.assertThat((long)this.pageCacheTracer.hits()).isEqualTo(19L);
    }

    private void prepareTestData() {
        for (int i = 0; i < 100; ++i) {
            try (Transaction tx = this.database.beginTx();){
                for (int j = 0; j < 100; ++j) {
                    tx.createNode();
                }
                tx.commit();
                continue;
            }
        }
    }
}

