/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.MandatoryProperties;
import org.neo4j.consistency.checking.full.PropertyAndNode2LabelIndexProcessor;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class PropertyAndNode2LabelIndexProcessorIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    private PropertyReader propertyReader;
    private ConsistencyReporter consistencyReporter;
    private BiFunction<NodeRecord, PageCursorTracer, MandatoryProperties.Check<NodeRecord, ConsistencyReport.NodeConsistencyReport>> nodeChecker;
    private NeoStores neoStores;
    private DefaultPageCacheTracer pageCacheTracer;

    PropertyAndNode2LabelIndexProcessorIT() {
    }

    @BeforeEach
    void setUp() {
        this.prepareData();
        this.pageCacheTracer = new DefaultPageCacheTracer();
        this.neoStores = this.storageEngine.testAccessNeoStores();
        StoreAccess storeAccess = new StoreAccess(this.neoStores);
        storeAccess.initialize();
        this.propertyReader = new PropertyReader(storeAccess);
        MandatoryProperties mandatoryProperties = new MandatoryProperties(storeAccess, (PageCacheTracer)this.pageCacheTracer);
        this.consistencyReporter = (ConsistencyReporter)Mockito.mock(ConsistencyReporter.class);
        this.nodeChecker = mandatoryProperties.forNodes(this.consistencyReporter);
    }

    @Test
    void tracePageCacheOnPropertyAndNodeProcessor() throws Exception {
        PropertyAndNode2LabelIndexProcessor processor = new PropertyAndNode2LabelIndexProcessor(this.consistencyReporter, null, this.propertyReader, CacheAccess.EMPTY, this.nodeChecker);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheOnPropertyAndNodeProcessor");){
            this.neoStores.getNodeStore().scanAllRecords(record -> {
                processor.process(record, cursorTracer);
                return false;
            }, PageCursorTracer.NULL);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(2L);
        }
    }

    private void prepareData() {
        Label startLabel = Label.label((String)"start");
        Label endLabel = Label.label((String)"end");
        RelationshipType relationshipType = RelationshipType.withName((String)"connection");
        String propertyName = "property";
        try (Transaction tx = this.database.beginTx();){
            Node start = tx.createNode(new Label[]{startLabel});
            for (int i = 0; i < 100; ++i) {
                start.addLabel(Label.label((String)("label" + i)));
            }
            Node end = tx.createNode(new Label[]{endLabel});
            start.createRelationshipTo(end, relationshipType);
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().indexFor(startLabel).on(propertyName).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

