/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.CheckerTestBase;
import org.neo4j.consistency.newchecker.IndexChecker;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexCheckerTest
extends CheckerTestBase {
    int label;
    int prop;

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        this.label = tx.tokenWrite().labelGetOrCreateForName("myLabel");
        this.prop = tx.tokenWrite().propertyKeyGetOrCreateForName("myProp");
        for (int i = 0; i < 200; ++i) {
            long node = tx.dataWrite().nodeCreateWithLabels(new int[]{this.label});
            tx.dataWrite().nodeSetProperty(node, this.prop, (Value)Values.stringValue((String)("propValue" + "1".repeat(i))));
        }
    }

    @Test
    void consistentUniqueIndexShouldNotGenerateInconsistencies() throws Exception {
        this.uniqueIndex((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label, (int[])new int[]{this.prop}));
        ConsistencySummaryStatistics inconsistenciesSummary = new ConsistencySummaryStatistics();
        CheckerContext context = this.context(4, ConsistencyFlags.DEFAULT, inconsistenciesSummary);
        IndexChecker indexChecker = new IndexChecker(context, EntityType.NODE);
        indexChecker.check(LongRange.range((long)0L, (long)10L), true, false);
        Assertions.assertTrue((boolean)inconsistenciesSummary.isConsistent());
    }
}

