/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.checking.DebugContext;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.CountsState;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.newchecker.ParallelExecution;
import org.neo4j.consistency.newchecker.RecordLoading;
import org.neo4j.consistency.newchecker.RelationshipChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;

@DbmsExtension
class RelationshipCheckerIT {
    private static final String INDEX_NAME = "index";
    private final ParallelExecution execution = new ParallelExecution(10, ParallelExecution.NOOP_EXCEPTION_HANDLER, 100);
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private IndexProviderMap providerMap;
    @Inject
    private Config config;
    @Inject
    private PageCache pageCache;
    @Inject
    private LabelScanStore labelScanStore;
    @Inject
    private RelationshipTypeScanStore relationshipTypeScanStore;
    @Inject
    private TokenHolders tokenHolders;
    private long relationshipId;
    private CheckerContext context;
    private DefaultPageCacheTracer pageCacheTracer;

    RelationshipCheckerIT() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.pageCacheTracer = new DefaultPageCacheTracer();
        Label label = Label.label((String)"any");
        RelationshipType type = RelationshipType.withName((String)"type");
        String propertyName = "property";
        try (Transaction tx = this.database.beginTx();){
            Node start = tx.createNode(new Label[]{label});
            Node end = tx.createNode();
            Relationship rel = start.createRelationshipTo(end, type);
            rel.setProperty(propertyName, (Object)"value");
            this.relationshipId = rel.getId();
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().indexFor(type).on(propertyName).withName(INDEX_NAME).withIndexType(IndexType.FULLTEXT).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        this.prepareContext();
    }

    @Test
    void tracePageCacheAccessOnRelationshipCheck() throws Exception {
        this.prepareContext();
        RelationshipChecker relationshipChecker = new RelationshipChecker(this.context, (MutableIntObjectMap)new IntObjectHashMap());
        relationshipChecker.check(LongRange.range((long)0L, (long)(this.relationshipId + 1L)), true, false);
        Assertions.assertThat((long)this.pageCacheTracer.pins()).isEqualTo(2L);
        Assertions.assertThat((long)this.pageCacheTracer.unpins()).isEqualTo(2L);
        Assertions.assertThat((long)this.pageCacheTracer.hits()).isEqualTo(2L);
    }

    private void prepareContext() throws Exception {
        NeoStores neoStores = this.storageEngine.testAccessNeoStores();
        IndexAccessors indexAccessors = new IndexAccessors(this.providerMap, neoStores, new IndexSamplingConfig(this.config), PageCacheTracer.NULL, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
        this.context = new CheckerContext(neoStores, indexAccessors, this.labelScanStore, this.relationshipTypeScanStore, this.execution, (ConsistencyReport.Reporter)Mockito.mock(ConsistencyReport.Reporter.class, (Answer)Mockito.RETURNS_MOCKS), CacheAccess.EMPTY, this.tokenHolders, (RecordLoading)Mockito.mock(RecordLoading.class), (CountsState)Mockito.mock(CountsState.class), (NodeBasedMemoryLimiter)Mockito.mock(NodeBasedMemoryLimiter.class), ProgressMonitorFactory.NONE.multipleParts("test"), this.pageCache, (PageCacheTracer)this.pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE, DebugContext.NO_DEBUG, ConsistencyFlags.DEFAULT);
        this.context.initialize();
    }
}

