/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.storageengine.api.StorageCommand;

public class TransactionWriter {
    private final NeoStores neoStores;
    private final List<Command.NodeCommand> nodeCommands = new ArrayList<Command.NodeCommand>();
    private final List<Command.RelationshipCommand> relationshipCommands = new ArrayList<Command.RelationshipCommand>();
    private final List<Command.RelationshipGroupCommand> relationshipGroupCommands = new ArrayList<Command.RelationshipGroupCommand>();
    private final List<Command> otherCommands = new ArrayList<Command>();

    public TransactionWriter(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    public TransactionRepresentation representation(byte[] additionalHeader, long startTime, long lastCommittedTx, long committedTime) {
        this.prepareForCommit();
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(this.allCommands());
        representation.setHeader(additionalHeader, startTime, lastCommittedTx, committedTime, -1);
        return representation;
    }

    public void propertyKey(int id, String key, boolean internal, int ... dynamicIds) {
        PropertyKeyTokenRecord before = new PropertyKeyTokenRecord(id);
        PropertyKeyTokenRecord after = TransactionWriter.withName(new PropertyKeyTokenRecord(id), dynamicIds, key);
        after.setInternal(internal);
        this.otherCommands.add((Command)new Command.PropertyKeyTokenCommand(before, after));
    }

    public void label(int id, String name, boolean internal, int ... dynamicIds) {
        LabelTokenRecord before = new LabelTokenRecord((long)id);
        LabelTokenRecord after = TransactionWriter.withName(new LabelTokenRecord((long)id), dynamicIds, name);
        after.setInternal(internal);
        this.otherCommands.add((Command)new Command.LabelTokenCommand(before, after));
    }

    public void relationshipType(int id, String relType, boolean internal, int ... dynamicIds) {
        RelationshipTypeTokenRecord before = new RelationshipTypeTokenRecord(id);
        RelationshipTypeTokenRecord after = TransactionWriter.withName(new RelationshipTypeTokenRecord(id), dynamicIds, relType);
        after.setInternal(internal);
        this.otherCommands.add((Command)new Command.RelationshipTypeTokenCommand(before, after));
    }

    public void update(LabelTokenRecord before, LabelTokenRecord after) {
        this.otherCommands.add((Command)new Command.LabelTokenCommand(before, after));
    }

    public void create(NodeRecord node) {
        node.setCreated();
        this.update(new NodeRecord(node.getId()).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_PREV_RELATIONSHIP.intValue(), 0L), node);
    }

    public void create(LabelTokenRecord labelToken) {
        labelToken.setCreated();
        this.update(new LabelTokenRecord((long)labelToken.getIntId()), labelToken);
    }

    public void create(PropertyKeyTokenRecord token) {
        token.setCreated();
        this.update(new PropertyKeyTokenRecord(token.getIntId()), token);
    }

    public void create(RelationshipGroupRecord group) {
        group.setCreated();
        this.update(new RelationshipGroupRecord(group.getId()).initialize(false, group.getType(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue()), group);
    }

    public void update(NodeRecord before, NodeRecord node) {
        node.setInUse(true);
        this.add(before, node);
    }

    public void update(PropertyKeyTokenRecord before, PropertyKeyTokenRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(NodeRecord node) {
        node.setInUse(false);
        this.add(node, new NodeRecord(node.getId()).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, (long)Record.NO_PREV_RELATIONSHIP.intValue(), 0L));
    }

    public void create(RelationshipRecord record) {
        record.setCreated();
        this.update(new RelationshipRecord(record.getId()), record);
    }

    public void delete(RelationshipGroupRecord group) {
        group.setInUse(false);
        this.add(group, new RelationshipGroupRecord(group.getId()).initialize(false, group.getType(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue(), Record.NULL_REFERENCE.longValue()));
    }

    public void createSchema(SchemaRecord before, SchemaRecord after, SchemaRule rule) {
        after.setCreated();
        this.updateSchema(before, after, rule);
    }

    public void updateSchema(SchemaRecord before, SchemaRecord after, SchemaRule rule) {
        after.setInUse(true);
        this.addSchema(before, after, rule);
    }

    public void update(RelationshipRecord before, RelationshipRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void update(RelationshipGroupRecord before, RelationshipGroupRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(RelationshipRecord record) {
        record.setInUse(false);
        this.add(record, new RelationshipRecord(record.getId()));
    }

    public void create(PropertyRecord property) {
        property.setCreated();
        PropertyRecord before = new PropertyRecord(property.getId());
        if (property.isNodeSet()) {
            before.setNodeId(property.getNodeId());
        }
        if (property.isRelSet()) {
            before.setRelId(property.getRelId());
        }
        if (property.isSchemaSet()) {
            before.setSchemaRuleId(property.getSchemaRuleId());
        }
        this.update(before, property);
    }

    public void update(PropertyRecord before, PropertyRecord after) {
        after.setInUse(true);
        this.add(before, after);
    }

    public void delete(PropertyRecord before, PropertyRecord after) {
        after.setInUse(false);
        this.add(before, after);
    }

    private void addSchema(SchemaRecord before, SchemaRecord after, SchemaRule rule) {
        this.otherCommands.add((Command)new Command.SchemaRuleCommand(before, after, rule));
    }

    public void add(NodeRecord before, NodeRecord after) {
        this.nodeCommands.add(new Command.NodeCommand(before, after));
    }

    public void add(RelationshipRecord before, RelationshipRecord after) {
        this.relationshipCommands.add(new Command.RelationshipCommand(before, after));
    }

    public void add(RelationshipGroupRecord before, RelationshipGroupRecord after) {
        this.relationshipGroupCommands.add(new Command.RelationshipGroupCommand(before, after));
    }

    public void add(PropertyRecord before, PropertyRecord property) {
        this.otherCommands.add((Command)new Command.PropertyCommand(before, property));
    }

    public void add(RelationshipTypeTokenRecord before, RelationshipTypeTokenRecord after) {
        this.otherCommands.add((Command)new Command.RelationshipTypeTokenCommand(before, after));
    }

    public void add(PropertyKeyTokenRecord before, PropertyKeyTokenRecord after) {
        this.otherCommands.add((Command)new Command.PropertyKeyTokenCommand(before, after));
    }

    public void incrementNodeCount(int labelId, long delta) {
        this.otherCommands.add((Command)new Command.NodeCountsCommand(labelId, delta));
    }

    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        this.otherCommands.add((Command)new Command.RelationshipCountsCommand(startLabelId, typeId, endLabelId, delta));
    }

    private static <T extends TokenRecord> T withName(T record, int[] dynamicIds, String name) {
        if (dynamicIds == null || dynamicIds.length == 0) {
            throw new IllegalArgumentException("No dynamic records for storing the name.");
        }
        record.setInUse(true);
        byte[] data = PropertyStore.encodeString((String)name);
        if (data.length > dynamicIds.length * 30) {
            throw new IllegalArgumentException(String.format("[%s] is too long to fit in %d blocks", name, dynamicIds.length));
        }
        if (data.length <= (dynamicIds.length - 1) * 30) {
            throw new IllegalArgumentException(String.format("[%s] is to short to fill %d blocks", name, dynamicIds.length));
        }
        for (int i = 0; i < dynamicIds.length; ++i) {
            byte[] part = new byte[Math.min(30, data.length - i * 30)];
            System.arraycopy(data, i * 30, part, 0, part.length);
            DynamicRecord dynamicRecord = new DynamicRecord((long)dynamicIds[i]);
            dynamicRecord.setInUse(true);
            dynamicRecord.setData(part);
            dynamicRecord.setCreated();
            record.addNameRecord(dynamicRecord);
        }
        record.setNameId(dynamicIds[0]);
        return record;
    }

    private void prepareForCommit() {
        for (Command.NodeCommand nodeCommand : this.nodeCommands) {
            this.neoStores.getNodeStore().prepareForCommit((AbstractBaseRecord)((NodeRecord)nodeCommand.getAfter()), PageCursorTracer.NULL);
        }
        for (Command.RelationshipCommand relationshipCommand : this.relationshipCommands) {
            this.neoStores.getRelationshipStore().prepareForCommit((AbstractBaseRecord)((RelationshipRecord)relationshipCommand.getAfter()), PageCursorTracer.NULL);
        }
        for (Command.RelationshipGroupCommand relationshipGroupCommand : this.relationshipGroupCommands) {
            this.neoStores.getRelationshipGroupStore().prepareForCommit((AbstractBaseRecord)((RelationshipGroupRecord)relationshipGroupCommand.getAfter()), PageCursorTracer.NULL);
        }
    }

    private List<StorageCommand> allCommands() {
        ArrayList<StorageCommand> allCommands = new ArrayList<StorageCommand>();
        allCommands.addAll(this.nodeCommands);
        allCommands.addAll(this.relationshipCommands);
        allCommands.addAll(this.relationshipGroupCommands);
        allCommands.addAll(this.otherCommands);
        return allCommands;
    }
}

