/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.full.MandatoryProperties;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class MandatoryPropertiesIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    private DefaultPageCacheTracer pageCacheTracer;
    private StoreAccess storeAccess;
    private NeoStores neoStores;

    MandatoryPropertiesIT() {
    }

    @BeforeEach
    void setUp() {
        this.prepareData();
        this.pageCacheTracer = new DefaultPageCacheTracer();
        this.neoStores = this.storageEngine.testAccessNeoStores();
        this.storeAccess = new StoreAccess(this.neoStores);
        this.storeAccess.initialize();
    }

    @Test
    void trackPageCacheAccessOnCreation() {
        new MandatoryProperties(this.storeAccess, (PageCacheTracer)this.pageCacheTracer);
        Assertions.assertThat((long)this.pageCacheTracer.pins()).isEqualTo(256L);
        Assertions.assertThat((long)this.pageCacheTracer.unpins()).isEqualTo(256L);
        Assertions.assertThat((long)this.pageCacheTracer.hits()).isEqualTo(256L);
    }

    @Test
    void trackPageCacheAccessOnMandatoryPropertiesForNodesCheck() throws Exception {
        MandatoryProperties mandatoryProperties = new MandatoryProperties(this.storeAccess, (PageCacheTracer)this.pageCacheTracer);
        BiFunction nodesCheck = mandatoryProperties.forNodes((ConsistencyReporter)Mockito.mock(ConsistencyReporter.class));
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("trackPageCacheAccessOnMandatoryPropertiesForNodesCheck");){
            this.neoStores.getNodeStore().scanAllRecords(record -> {
                nodesCheck.apply(record, cursorTracer);
                return false;
            }, PageCursorTracer.NULL);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(2L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(2L);
        }
    }

    private void prepareData() {
        Label startLabel = Label.label((String)"start");
        Label endLabel = Label.label((String)"end");
        RelationshipType relationshipType = RelationshipType.withName((String)"connection");
        String propertyName = "property";
        try (Transaction tx = this.database.beginTx();){
            Node start = tx.createNode(new Label[]{startLabel});
            for (int i = 0; i < 100; ++i) {
                start.addLabel(Label.label((String)("label" + i)));
            }
            Node end = tx.createNode(new Label[]{endLabel});
            start.createRelationshipTo(end, relationshipType);
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().indexFor(startLabel).on(propertyName).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

