/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.PropertyAndNodeIndexedCheck;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class PropertyAndNodeIndexedCheckIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private IndexProviderMap providerMap;
    @Inject
    private Config config;
    private PropertyReader propertyReader;
    private IndexAccessors indexAccessors;
    private NeoStores neoStores;
    private DefaultPageCacheTracer pageCacheTracer;
    private DirectRecordAccess recordAccess;

    PropertyAndNodeIndexedCheckIT() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.prepareTestData();
        this.pageCacheTracer = new DefaultPageCacheTracer();
        this.neoStores = this.storageEngine.testAccessNeoStores();
        StoreAccess storeAccess = new StoreAccess(this.neoStores);
        storeAccess.initialize();
        this.propertyReader = new PropertyReader(storeAccess);
        this.recordAccess = new DirectRecordAccess(storeAccess, CacheAccess.EMPTY);
        this.indexAccessors = new IndexAccessors(this.providerMap, this.neoStores, new IndexSamplingConfig(this.config), (PageCacheTracer)this.pageCacheTracer, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
    }

    @Test
    void tracePageCacheOnNodePropertyCheck() throws Exception {
        PropertyAndNodeIndexedCheck indexedCheck = new PropertyAndNodeIndexedCheck(this.indexAccessors, this.propertyReader, CacheAccess.EMPTY);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheOnNodePropertyCheck");){
            this.neoStores.getNodeStore().scanAllRecords(record -> {
                indexedCheck.check(record, (CheckerEngine)Mockito.mock(CheckerEngine.class), (RecordAccess)this.recordAccess, cursorTracer);
                return false;
            }, PageCursorTracer.NULL);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(4L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(4L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(4L);
        }
    }

    private void prepareTestData() {
        int i;
        try (Transaction tx = this.database.beginTx();){
            Node node = tx.createNode();
            for (i = 0; i < 10; ++i) {
                node.setProperty("a" + i, (Object)"i");
                node.addLabel(Label.label((String)("label" + i)));
            }
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            Schema schema = tx.schema();
            for (i = 0; i < 10; ++i) {
                schema.indexFor(Label.label((String)("label" + i))).on("a" + i).create();
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }
}

