/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.neo4j.consistency.newchecker.CheckerTestBase;
import org.neo4j.consistency.newchecker.SchemaChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class SchemaCheckerTest
extends CheckerTestBase {
    private int label1;
    private int label2;
    private int relationshipType1;
    private int relationshipType2;
    private int propertyKey1;
    private int propertyKey2;
    private final int UNUSED = 99;
    private final MutableIntObjectMap<MutableIntSet> mandatoryNodeProperties = IntObjectMaps.mutable.empty();
    private final MutableIntObjectMap<MutableIntSet> mandatoryRelationshipProperties = IntObjectMaps.mutable.empty();
    private final String NAME = "name1";
    private final String NAME2 = "name2";

    SchemaCheckerTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        TokenWrite tokenWrite = tx.tokenWrite();
        this.label1 = tokenWrite.labelGetOrCreateForName("A");
        this.label2 = tokenWrite.labelGetOrCreateForName("B");
        this.relationshipType1 = tokenWrite.relationshipTypeGetOrCreateForName("A");
        this.relationshipType2 = tokenWrite.relationshipTypeGetOrCreateForName("B");
        this.propertyKey1 = tokenWrite.propertyKeyGetOrCreateForName("A");
        this.propertyKey2 = tokenWrite.propertyKeyGetOrCreateForName("B");
    }

    @Test
    void shouldReportDuplicateRuleContent() throws Exception {
        PageCursorTracer cursorTracer = PageCursorTracer.NULL;
        try (AutoCloseable ignored = this.tx();){
            IndexDescriptor index1 = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            IndexDescriptor index2 = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name2").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            this.schemaStorage.writeSchemaRule((SchemaRule)index1, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)index2, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.duplicateRuleContent((SchemaRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportSchemaRuleNotOnline() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.schemaRuleNotOnline((SchemaRule)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportLabelNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)99, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.labelNotInUse((LabelTokenRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportRelationshipTypeNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)99, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.relationshipTypeNotInUse((RelationshipTypeTokenRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportPropertyKeyNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forRelType((int)this.relationshipType1, (int[])new int[]{99})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.propertyKeyNotInUse((PropertyKeyTokenRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportMissingObligationUniquenessConstraint() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index1 = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer)).withOwningConstraintId(99L);
            this.schemaStorage.writeSchemaRule((SchemaRule)index1, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.missingObligation((String)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportMissingObligationConstraintIndexRule() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            UniquenessConstraintDescriptor constraintDescriptor = ConstraintDescriptorFactory.uniqueForLabel((int)this.label1, (int[])new int[]{this.propertyKey1}).withId(this.schemaStore.nextId(cursorTracer)).withName("name1").withOwnedIndexId(99L);
            this.schemaStorage.writeSchemaRule((SchemaRule)constraintDescriptor, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.missingObligation((String)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportMalformedSchemaRule() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            SchemaRecord schemaRecord = (SchemaRecord)this.schemaStore.getRecord(index.getId(), (AbstractBaseRecord)((SchemaRecord)this.schemaStore.newRecord()), RecordLoad.NORMAL, PageCursorTracer.NULL);
            this.propertyStore.updateRecord((AbstractBaseRecord)new PropertyRecord(schemaRecord.getNextProp()), PageCursorTracer.NULL);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, ConsistencyReport.SchemaConsistencyReport::malformedSchemaRule);
    }

    @Test
    void shouldReportConstraintIndexRuleNotReferencingBack() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)this.label1, (int[])new int[]{this.propertyKey1}).withId(this.schemaStore.nextId(cursorTracer)).withName("name1").withOwnedIndexId(index.getId());
            index = index.withOwningConstraintId(99L);
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)uniquenessConstraint, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.constraintIndexRuleNotReferencingBack((SchemaRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportUniquenessConstraintNotReferencingBack() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)this.label1, (int[])new int[]{this.propertyKey1}).withId(this.schemaStore.nextId(cursorTracer)).withName("name1").withOwnedIndexId(99L);
            index = index.withOwningConstraintId(uniquenessConstraint.getId());
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)uniquenessConstraint, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.uniquenessConstraintNotReferencingBack((SchemaRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDuplicateObligationForIndex() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index1 = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            IndexDescriptor index2 = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label2, (int[])new int[]{this.propertyKey2})).withName("name2").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)this.label1, (int[])new int[]{this.propertyKey1}).withId(this.schemaStore.nextId(cursorTracer)).withName("name1").withOwnedIndexId(index1.getId());
            index1 = index1.withOwningConstraintId(uniquenessConstraint.getId());
            index2 = index2.withOwningConstraintId(uniquenessConstraint.getId());
            this.schemaStorage.writeSchemaRule((SchemaRule)index1, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)index2, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)uniquenessConstraint, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.duplicateObligation((SchemaRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDuplicateObligationForConstraint() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1})).withName("name1").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).materialise(this.schemaStore.nextId(cursorTracer));
            UniquenessConstraintDescriptor uniquenessConstraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)this.label1, (int[])new int[]{this.propertyKey1}).withId(this.schemaStore.nextId(cursorTracer)).withName("name1").withOwnedIndexId(index.getId());
            UniquenessConstraintDescriptor uniquenessConstraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)this.label2, (int[])new int[]{this.propertyKey2}).withId(this.schemaStore.nextId(cursorTracer)).withName("name2").withOwnedIndexId(index.getId());
            index = index.withOwningConstraintId(uniquenessConstraint1.getId());
            this.schemaStorage.writeSchemaRule((SchemaRule)index, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)uniquenessConstraint1, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)uniquenessConstraint2, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        this.expect(ConsistencyReport.SchemaConsistencyReport.class, report -> report.duplicateObligation((SchemaRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldPopulateMandatoryPropertiesMap() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            PageCursorTracer cursorTracer = PageCursorTracer.NULL;
            NodeExistenceConstraintDescriptor constraint1 = ConstraintDescriptorFactory.existsForLabel((int)this.label1, (int[])new int[]{this.propertyKey1}).withId(this.schemaStore.nextId(cursorTracer)).withName("name1");
            NodeExistenceConstraintDescriptor constraint2 = ConstraintDescriptorFactory.existsForLabel((int)this.label2, (int[])new int[]{this.propertyKey1, this.propertyKey2}).withId(this.schemaStore.nextId(cursorTracer)).withName("name2");
            RelExistenceConstraintDescriptor constraint3 = ConstraintDescriptorFactory.existsForRelType((int)this.relationshipType1, (int[])new int[]{this.propertyKey2}).withId(this.schemaStore.nextId(cursorTracer)).withName("name1");
            RelExistenceConstraintDescriptor constraint4 = ConstraintDescriptorFactory.existsForRelType((int)this.relationshipType2, (int[])new int[]{this.propertyKey1, this.propertyKey2}).withId(this.schemaStore.nextId(cursorTracer)).withName("name2");
            this.schemaStorage.writeSchemaRule((SchemaRule)constraint1, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)constraint2, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)constraint3, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.schemaStorage.writeSchemaRule((SchemaRule)constraint4, cursorTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        this.check();
        Assertions.assertEquals((Object)IntSets.mutable.of(new int[]{this.propertyKey1}), (Object)this.mandatoryNodeProperties.remove(this.label1));
        Assertions.assertEquals((Object)IntSets.mutable.of(new int[]{this.propertyKey1, this.propertyKey2}), (Object)this.mandatoryNodeProperties.remove(this.label2));
        Assertions.assertTrue((boolean)this.mandatoryNodeProperties.isEmpty());
        Assertions.assertEquals((Object)IntSets.mutable.of(new int[]{this.propertyKey2}), (Object)this.mandatoryRelationshipProperties.remove(this.relationshipType1));
        Assertions.assertEquals((Object)IntSets.mutable.of(new int[]{this.propertyKey1, this.propertyKey2}), (Object)this.mandatoryRelationshipProperties.remove(this.relationshipType2));
        Assertions.assertTrue((boolean)this.mandatoryRelationshipProperties.isEmpty());
    }

    @Test
    void shouldReportLabelTokenDynamicRecordNotInUse() throws Exception {
        this.testDynamicLabelTokenChainInconsistency(record -> ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setInUse(false), ConsistencyReport.LabelTokenConsistencyReport.class, report -> report.nameBlockNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextLabelTokenDynamicRecordNotInUse() throws Exception {
        this.testDynamicLabelTokenChainInconsistency(record -> ((DynamicRecord)Iterables.last((Iterable)record.getNameRecords())).setInUse(false), ConsistencyReport.DynamicConsistencyReport.class, report -> report.nextNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicLabelStringEmpty() throws Exception {
        this.testDynamicLabelTokenChainInconsistency(record -> ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setData(new byte[0]), ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::emptyBlock);
    }

    @Test
    void shouldReportDynamicLabelStringRecordNotFullReferencesNext() throws Exception {
        this.testDynamicLabelTokenChainInconsistency(record -> {
            DynamicRecord first = (DynamicRecord)Iterables.first((Iterable)record.getNameRecords());
            ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setData(Arrays.copyOf(first.getData(), first.getLength() / 2));
        }, ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::recordNotFullReferencesNext);
    }

    @Test
    void shouldReportPropertyKeyTokenDynamicRecordNotInUse() throws Exception {
        this.testDynamicPropertyKeyTokenChainInconsistency(record -> ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setInUse(false), ConsistencyReport.PropertyKeyTokenConsistencyReport.class, report -> report.nameBlockNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextPropertyKeyTokenDynamicRecordNotInUse() throws Exception {
        this.testDynamicPropertyKeyTokenChainInconsistency(record -> ((DynamicRecord)Iterables.last((Iterable)record.getNameRecords())).setInUse(false), ConsistencyReport.DynamicConsistencyReport.class, report -> report.nextNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicPropertyKeyStringEmpty() throws Exception {
        this.testDynamicPropertyKeyTokenChainInconsistency(record -> ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setData(new byte[0]), ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::emptyBlock);
    }

    @Test
    void shouldReportDynamicPropertyKeyStringRecordNotFullReferencesNext() throws Exception {
        this.testDynamicPropertyKeyTokenChainInconsistency(record -> {
            DynamicRecord first = (DynamicRecord)Iterables.first((Iterable)record.getNameRecords());
            ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setData(Arrays.copyOf(first.getData(), first.getLength() / 2));
        }, ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::recordNotFullReferencesNext);
    }

    @Test
    void shouldReportRelationshipTypeTokenDynamicRecordNotInUse() throws Exception {
        this.testDynamicRelationshipTypeTokenChainInconsistency(record -> ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setInUse(false), ConsistencyReport.RelationshipTypeConsistencyReport.class, report -> report.nameBlockNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextRelationshipTypeTokenDynamicRecordNotInUse() throws Exception {
        this.testDynamicRelationshipTypeTokenChainInconsistency(record -> ((DynamicRecord)Iterables.last((Iterable)record.getNameRecords())).setInUse(false), ConsistencyReport.DynamicConsistencyReport.class, report -> report.nextNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicRelationshipTypeStringEmpty() throws Exception {
        this.testDynamicRelationshipTypeTokenChainInconsistency(record -> ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setData(new byte[0]), ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::emptyBlock);
    }

    @Test
    void shouldReportDynamicRelationshipTypeStringRecordNotFullReferencesNext() throws Exception {
        this.testDynamicRelationshipTypeTokenChainInconsistency(record -> {
            DynamicRecord first = (DynamicRecord)Iterables.first((Iterable)record.getNameRecords());
            ((DynamicRecord)Iterables.first((Iterable)record.getNameRecords())).setData(Arrays.copyOf(first.getData(), first.getLength() / 2));
        }, ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::recordNotFullReferencesNext);
    }

    private <R extends ConsistencyReport> void testDynamicRelationshipTypeTokenChainInconsistency(Consumer<RelationshipTypeTokenRecord> vandal, Class<R> reportClass, Consumer<R> report) throws Exception {
        this.testDynamicTokenChainInconsistency((TokenStore)this.neoStores.getRelationshipTypeTokenStore(), TokenWrite::relationshipTypeGetOrCreateForName, (Consumer)vandal, reportClass, report);
    }

    private <R extends ConsistencyReport> void testDynamicLabelTokenChainInconsistency(Consumer<LabelTokenRecord> vandal, Class<R> reportClass, Consumer<R> report) throws Exception {
        this.testDynamicTokenChainInconsistency((TokenStore)this.neoStores.getLabelTokenStore(), TokenWrite::labelGetOrCreateForName, (Consumer)vandal, reportClass, report);
    }

    private <R extends ConsistencyReport> void testDynamicPropertyKeyTokenChainInconsistency(Consumer<PropertyKeyTokenRecord> vandal, Class<R> reportClass, Consumer<R> report) throws Exception {
        this.testDynamicTokenChainInconsistency((TokenStore)this.neoStores.getPropertyKeyTokenStore(), TokenWrite::propertyKeyGetOrCreateForName, (Consumer)vandal, reportClass, report);
    }

    private <TOKEN extends TokenRecord, R extends ConsistencyReport> void testDynamicTokenChainInconsistency(TokenStore<TOKEN> store, TokenCreator tokenCreator, Consumer<TOKEN> vandal, Class<R> expectedReportClass, Consumer<R> report) throws Exception {
        int tokenId;
        try (KernelTransaction ktx = this.ktx();){
            tokenId = tokenCreator.createToken(ktx.tokenWrite(), "Broken".repeat(50));
            ktx.commit();
        }
        try (AutoCloseable ignored = this.tx();){
            TokenRecord record = (TokenRecord)store.getRecord((long)tokenId, (AbstractBaseRecord)((TokenRecord)store.newRecord()), RecordLoad.NORMAL, PageCursorTracer.NULL);
            store.ensureHeavy(record, PageCursorTracer.NULL);
            vandal.accept(record);
            DynamicStringStore nameStore = store.getNameStore();
            for (DynamicRecord nameRecord : record.getNameRecords()) {
                nameStore.updateRecord((AbstractBaseRecord)nameRecord, PageCursorTracer.NULL);
            }
        }
        this.check();
        this.expect(expectedReportClass, report);
    }

    private void check() throws Exception {
        new SchemaChecker(this.context()).check(this.mandatoryNodeProperties, this.mandatoryRelationshipProperties, PageCursorTracer.NULL);
    }

    static interface TokenCreator {
        public int createToken(TokenWrite var1, String var2) throws KernelException;
    }
}

