/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker.full;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.FullCheckIntegrationTest;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class ExperimentalFullCheckIntegrationTest
extends FullCheckIntegrationTest {
    private Map<Setting<?>, Object> extraSettings;

    @Override
    @BeforeEach
    protected void setUp() {
        this.extraSettings = new HashMap();
        super.setUp();
    }

    @Override
    protected Map<Setting<?>, Object> getSettings() {
        HashMap cfg = new HashMap(super.getSettings());
        cfg.put(GraphDatabaseInternalSettings.experimental_consistency_checker, true);
        cfg.putAll(this.extraSettings);
        return cfg;
    }

    @Test
    void shouldOnlyReportFirstNodeInconsistencyOnFailFast() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
            }
        });
        this.extraSettings.put(GraphDatabaseInternalSettings.experimental_consistency_checker_stop_threshold, 1);
        ConsistencySummaryStatistics stats = this.check();
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldOnlyReportFirstRelationshipInconsistenciesOnFailFast() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationshipA = new RelationshipRecord(next.relationship());
                relationshipA.setLinks(1L, 2L, ExperimentalFullCheckIntegrationTest.this.C);
                tx.create(relationshipA);
                RelationshipRecord relationshipB = new RelationshipRecord(next.relationship());
                relationshipB.setLinks(1L, 2L, ExperimentalFullCheckIntegrationTest.this.C);
                tx.create(relationshipB);
            }
        });
        this.extraSettings.put(GraphDatabaseInternalSettings.experimental_consistency_checker_stop_threshold, 1);
        ConsistencySummaryStatistics stats = this.check();
        int relationshipInconsistencies = stats.getInconsistencyCountForRecordType(RecordType.RELATIONSHIP);
        Assertions.assertThat((int)relationshipInconsistencies).isIn(new Object[]{1, 2});
        org.junit.jupiter.api.Assertions.assertEquals((long)stats.getTotalInconsistencyCount(), (long)relationshipInconsistencies);
    }

    @Test
    void shouldReportRelationshipGroupRelationshipDoesNotShareOwner() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long group = next.relationshipGroup();
                long rel = next.relationship();
                tx.create(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), true, group, 0L));
                tx.create(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(otherNode, otherNode, ExperimentalFullCheckIntegrationTest.this.C);
                tx.create(relationship);
                tx.create(new RelationshipGroupRecord(group).initialize(false, ExperimentalFullCheckIntegrationTest.this.C, rel, rel, rel, node, Record.NULL_REFERENCE.longValue()));
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, ExperimentalFullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP_GROUP, 3).andThatsAllFolks();
    }

    @Test
    void shouldHandleNegativeRelationshipPointers() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                long node = next.node();
                long otherNode = next.node();
                long rel = next.relationship();
                tx.create(new NodeRecord(node).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                tx.create(new NodeRecord(otherNode).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, rel, 0L));
                RelationshipRecord relationship = new RelationshipRecord(rel);
                relationship.setLinks(node, otherNode, ExperimentalFullCheckIntegrationTest.this.C);
                relationship.setFirstNextRel(-3L);
                relationship.setFirstPrevRel(-4L);
                relationship.setSecondNextRel(-5L);
                relationship.setSecondPrevRel(-6L);
                tx.create(relationship);
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, ExperimentalFullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 4).andThatsAllFolks();
    }

    @Test
    void shouldHandleNegativeNodeRelationshipPointer() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, (long)Record.NO_NEXT_PROPERTY.intValue(), false, -6L, 0L));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.NODE, 1).andThatsAllFolks();
    }

    @Test
    void shouldHandleNegativeRelationshipNodePointers() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                RelationshipRecord relationship = new RelationshipRecord(next.relationship());
                relationship.setLinks(-2L, -3L, ExperimentalFullCheckIntegrationTest.this.C);
                tx.create(relationship);
                tx.incrementRelationshipCount(-1, -1, -1, 1L);
                tx.incrementRelationshipCount(-1, ExperimentalFullCheckIntegrationTest.this.C, -1, 1L);
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.RELATIONSHIP, 2).andThatsAllFolks();
    }

    @Test
    void shouldDetectInvalidUseOfInternalPropertyKeyTokens() throws Exception {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                int propertyKey = next.propertyKey();
                tx.propertyKey(propertyKey, "FOO", true);
                long nextProp = next.property();
                PropertyRecord property = new PropertyRecord(nextProp).initialize(true, Record.NO_PREVIOUS_PROPERTY.longValue(), Record.NO_NEXT_PROPERTY.longValue());
                PropertyBlock block = new PropertyBlock();
                block.setSingleBlock((long)propertyKey | (long)PropertyType.INT.intValue() << 24 | 0x29A0000000L);
                property.addPropertyBlock(block);
                tx.create(property);
                tx.create(new NodeRecord(next.node()).initialize(true, nextProp, false, Record.NO_NEXT_RELATIONSHIP.longValue(), Record.NO_LABELS_FIELD.longValue()));
            }
        });
        ConsistencySummaryStatistics stats = this.check();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)stats.isConsistent());
        ExperimentalFullCheckIntegrationTest.on(stats).verify(RecordType.PROPERTY, 1).andThatsAllFolks();
    }

    @Override
    @Disabled(value="New checker detects correct usage of internal vs non-internal tokens")
    @Test
    protected void shouldNotBeConfusedByInternalPropertyKeyTokens() throws Exception {
        super.shouldNotBeConfusedByInternalPropertyKeyTokens();
    }

    @Override
    @Disabled(value="New checker checks the live graph, i.e. anything that can be reached from the used nodes/relationships")
    @Test
    protected void shouldReportOrphanedNodeDynamicLabelAsNodeInconsistency() throws Exception {
        super.shouldReportOrphanedNodeDynamicLabelAsNodeInconsistency();
    }
}

