/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.NodeRecordCheck;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.RelationshipRecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.CountsBuilderDecorator;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class CountsBuilderDecoratorIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    private NeoStores neoStores;
    private CountsBuilderDecorator countsDecorator;
    private ConsistencyReporter consistencyReporter;
    private DefaultPageCacheTracer pageCacheTracer;
    private DirectRecordAccess recordAccess;

    CountsBuilderDecoratorIT() {
    }

    @BeforeEach
    void setUp() {
        this.prepareData();
        this.neoStores = this.storageEngine.testAccessNeoStores();
        StoreAccess storeAccess = new StoreAccess(this.neoStores);
        storeAccess.initialize();
        this.countsDecorator = new CountsBuilderDecorator(storeAccess);
        this.recordAccess = new DirectRecordAccess(storeAccess, CacheAccess.EMPTY);
        this.pageCacheTracer = new DefaultPageCacheTracer();
        this.consistencyReporter = new ConsistencyReporter((RecordAccess)this.recordAccess, (InconsistencyReport)Mockito.mock(InconsistencyReport.class), (PageCacheTracer)this.pageCacheTracer);
    }

    @Test
    void trackPageCacheAccessOnCountsCheck() throws Exception {
        this.prepareDecorator(this.neoStores, this.countsDecorator, this.recordAccess);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("trackPageCacheAccessOnCountsCheck");){
            this.countsDecorator.checkCounts(this.storageEngine.countsAccessor(), this.consistencyReporter, ProgressMonitorFactory.NONE, cursorTracer);
            Assertions.assertThat((long)cursorTracer.pins()).isOne();
            Assertions.assertThat((long)cursorTracer.unpins()).isOne();
            Assertions.assertThat((long)cursorTracer.hits()).isOne();
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCheck() throws Exception {
        this.countsDecorator.prepare();
        OwningRecordCheck nodeCheck = this.countsDecorator.decorateNodeChecker((OwningRecordCheck)new NodeRecordCheck());
        CheckerEngine fakeEngine = (CheckerEngine)Mockito.mock(CheckerEngine.class);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnNodeCheck");){
            this.neoStores.getNodeStore().scanAllRecords(node -> {
                nodeCheck.check((AbstractBaseRecord)node, fakeEngine, (RecordAccess)this.recordAccess, cursorTracer);
                return false;
            }, PageCursorTracer.NULL);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(600L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(600L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(600L);
        }
    }

    @Test
    void tracePageCacheAccessOnRelationshipCheck() throws Exception {
        this.countsDecorator.prepare();
        this.countsDecorator.prepare();
        OwningRecordCheck relCheck = this.countsDecorator.decorateRelationshipChecker((OwningRecordCheck)new RelationshipRecordCheck());
        CheckerEngine fakeEngine = (CheckerEngine)Mockito.mock(CheckerEngine.class);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnRelationshipCheck");){
            this.neoStores.getRelationshipStore().scanAllRecords(record -> {
                relCheck.check((AbstractBaseRecord)record, fakeEngine, (RecordAccess)this.recordAccess, cursorTracer);
                return false;
            }, PageCursorTracer.NULL);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(100L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(100L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(100L);
        }
    }

    private void prepareData() {
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node start = tx.createNode(new Label[]{Label.label((String)("marker" + i))});
                Node end = tx.createNode(new Label[]{Label.label((String)("endMarker" + i))});
                start.createRelationshipTo(end, RelationshipType.withName((String)("type" + i)));
            }
            tx.commit();
        }
    }

    private void prepareDecorator(NeoStores neoStores, CountsBuilderDecorator countsDecorator, DirectRecordAccess recordAccess) throws Exception {
        countsDecorator.prepare();
        OwningRecordCheck nodeCheck = countsDecorator.decorateNodeChecker((OwningRecordCheck)new NodeRecordCheck());
        OwningRecordCheck relCheck = countsDecorator.decorateRelationshipChecker((OwningRecordCheck)new RelationshipRecordCheck());
        CheckerEngine fakeEngine = (CheckerEngine)Mockito.mock(CheckerEngine.class);
        neoStores.getNodeStore().scanAllRecords(node -> {
            nodeCheck.check((AbstractBaseRecord)node, fakeEngine, (RecordAccess)recordAccess, PageCursorTracer.NULL);
            return false;
        }, PageCursorTracer.NULL);
        countsDecorator.prepare();
        neoStores.getRelationshipStore().scanAllRecords(record -> {
            relCheck.check((AbstractBaseRecord)record, fakeEngine, (RecordAccess)recordAccess, PageCursorTracer.NULL);
            return false;
        }, PageCursorTracer.NULL);
    }
}

