/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Map;
import org.junit.jupiter.api.Test;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.FullCheckIntegrationTest;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.index.label.TokenScanStore;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.EntityTokenUpdate;

public class FullCheckIntegrationWithRelationshipTypeScanStoreTest
extends FullCheckIntegrationTest {
    @Override
    protected Map<Setting<?>, Object> getSettings() {
        Map<Setting<?>, Object> settings = super.getSettings();
        settings.put(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store, true);
        return settings;
    }

    @Test
    void shouldReportRelationshipTypeScanStoreInconsistencies1() throws Exception {
        GraphStoreFixture.IdGenerator idGenerator = this.fixture.idGenerator();
        long relationshipId = idGenerator.relationship();
        long relationshipTypeId = idGenerator.relationshipType() - 1;
        RelationshipTypeScanStore relationshipTypeScanStore = this.fixture.directStoreAccess().relationshipTypeScanStore();
        Iterable relationshipTypeUpdates = Iterables.asIterable((Object[])new EntityTokenUpdate[]{EntityTokenUpdate.tokenChanges((long)relationshipId, (long[])new long[0], (long[])new long[]{relationshipTypeId})});
        this.write((TokenScanStore)relationshipTypeScanStore, relationshipTypeUpdates);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationWithRelationshipTypeScanStoreTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, 1).andThatsAllFolks();
    }

    @Test
    void shouldReportRelationshipTypeScanStoreInconsistencies2() throws Exception {
        RecordStore relationshipStore = this.fixture.directStoreAccess().nativeStores().getRelationshipStore();
        GraphStoreFixture.IdGenerator idGenerator = this.fixture.idGenerator();
        RelationshipRecord relationshipRecord = new RelationshipRecord(0L);
        long relationshipId = idGenerator.relationship() - 1L;
        relationshipStore.getRecord(relationshipId, (AbstractBaseRecord)relationshipRecord, RecordLoad.NORMAL, PageCursorTracer.NULL);
        relationshipRecord.setType(relationshipRecord.getType() + 1);
        relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord, PageCursorTracer.NULL);
        ConsistencySummaryStatistics stats = this.check();
        FullCheckIntegrationWithRelationshipTypeScanStoreTest.on(stats).verify(RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT, 2).verify(RecordType.COUNTS, 2).andThatsAllFolks();
    }
}

