/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.state.DefaultIndexProviderMap;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@DbmsExtension
@ExtendWith(value={RandomExtension.class})
class IndexConsistencyIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private DefaultIndexProviderMap indexProviderMap;
    @Inject
    private RandomRule random;
    private final AssertableLogProvider log = new AssertableLogProvider();
    private static final Label[] LABELS = new Label[]{TestLabels.LABEL_ONE, TestLabels.LABEL_TWO, TestLabels.LABEL_THREE};
    private static final String PROPERTY_KEY = "numericProperty";
    private static final double DELETE_RATIO = 0.2;
    private static final double UPDATE_RATIO = 0.2;
    private static final int NODE_COUNT_BASELINE = 10;
    private final Predicate<Path> SOURCE_COPY_FILE_FILTER = path -> Files.isDirectory(path, new LinkOption[0]) || path.getFileName().toString().startsWith("index");

    IndexConsistencyIT() {
    }

    @Test
    void reportNotCleanNativeIndex() throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData();
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        Path indexesCopy = databaseLayout.file("indexesCopy");
        Path indexSources = this.indexProviderMap.getDefaultProvider().directoryStructure().rootDirectory();
        FileUtils.copyDirectory((Path)indexSources, (Path)indexesCopy, this.SOURCE_COPY_FILE_FILTER);
        try (Transaction tx = this.db.beginTx();){
            this.createNewNode(tx, new Label[]{TestLabels.LABEL_ONE});
            tx.commit();
        }
        this.managementService.shutdown();
        FileUtils.copyDirectory((Path)indexesCopy, (Path)indexSources);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
        Assertions.assertThat((String)this.readReport(result)).contains(new CharSequence[]{"WARN  Index was dirty on startup which means it was not shutdown correctly and need to be cleaned up with a successful recovery."});
    }

    @Test
    void reportNotCleanNativeIndexWithCorrectData() throws IOException, ConsistencyCheckIncompleteException {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.someData();
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        Path indexesCopy = databaseLayout.file("indexesCopy");
        Path indexSources = this.indexProviderMap.getDefaultProvider().directoryStructure().rootDirectory();
        FileUtils.copyDirectory((Path)indexSources, (Path)indexesCopy, this.SOURCE_COPY_FILE_FILTER);
        this.managementService.shutdown();
        FileUtils.copyDirectory((Path)indexesCopy, (Path)indexSources);
        ConsistencyCheckService.Result result = this.fullConsistencyCheck();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected consistency check to fail");
        Assertions.assertThat((String)this.readReport(result)).contains(new CharSequence[]{"WARN  Index was dirty on startup which means it was not shutdown correctly and need to be cleaned up with a successful recovery."});
    }

    private String readReport(ConsistencyCheckService.Result result) throws IOException {
        return Files.readString(result.reportFile());
    }

    void someData() {
        this.someData(50);
    }

    void someData(int numberOfModifications) {
        ArrayList<Pair<Long, Label[]>> existingNodes = new ArrayList<Pair<Long, Label[]>>();
        try (Transaction tx = this.db.beginTx();){
            this.randomModifications(tx, existingNodes, numberOfModifications);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(TestLabels.LABEL_ONE).on(PROPERTY_KEY).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private void randomModifications(Transaction tx, List<Pair<Long, Label[]>> existingNodes, int numberOfModifications) {
        for (int i = 0; i < numberOfModifications; ++i) {
            double selectModification = this.random.nextDouble();
            if (existingNodes.size() < 10 || selectModification >= 0.4) {
                this.createNewNode(tx, existingNodes);
                continue;
            }
            if (selectModification < 0.2) {
                this.deleteExistingNode(tx, existingNodes);
                continue;
            }
            this.modifyLabelsOnExistingNode(tx, existingNodes);
        }
    }

    private void createNewNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        Label[] labels = this.randomLabels();
        Node node = this.createNewNode(transaction, labels);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)node.getId(), (Object)labels));
    }

    private Node createNewNode(Transaction tx, Label[] labels) {
        Node node = tx.createNode(labels);
        node.setProperty(PROPERTY_KEY, (Object)this.random.nextInt());
        return node;
    }

    private void modifyLabelsOnExistingNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        Label[] newLabels;
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        long nodeId = (Long)existingPair.first();
        Node node = transaction.getNodeById(nodeId);
        node.getLabels().forEach(arg_0 -> ((Node)node).removeLabel(arg_0));
        for (Label label : newLabels = this.randomLabels()) {
            node.addLabel(label);
        }
        existingNodes.remove(targetIndex);
        existingNodes.add((Pair<Long, Label[]>)Pair.of((Object)nodeId, (Object)newLabels));
    }

    private void deleteExistingNode(Transaction transaction, List<Pair<Long, Label[]>> existingNodes) {
        int targetIndex = this.random.nextInt(existingNodes.size());
        Pair<Long, Label[]> existingPair = existingNodes.get(targetIndex);
        Node node = transaction.getNodeById(((Long)existingPair.first()).longValue());
        node.delete();
        existingNodes.remove(targetIndex);
    }

    private Label[] randomLabels() {
        ArrayList<Label> labels = new ArrayList<Label>(LABELS.length);
        for (Label label : LABELS) {
            if (!this.random.nextBoolean()) continue;
            labels.add(label);
        }
        return labels.toArray(new Label[0]);
    }

    private ConsistencyCheckService.Result fullConsistencyCheck() throws ConsistencyCheckIncompleteException, IOException {
        try (DefaultFileSystemAbstraction fsa = new DefaultFileSystemAbstraction();){
            ConsistencyCheckService service = new ConsistencyCheckService();
            DatabaseLayout databaseLayout = this.db.databaseLayout();
            Config config = Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (Object)databaseLayout.databaseDirectory());
            ConsistencyCheckService.Result result = service.runFullConsistencyCheck(databaseLayout, config, ProgressMonitorFactory.NONE, (LogProvider)this.log, (FileSystemAbstraction)fsa, false, ConsistencyFlags.DEFAULT);
            return result;
        }
    }
}

