/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.full.FullCheck;
import org.neo4j.consistency.newchecker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.counts.CountsStore;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
public class ExecutionOrderIntegrationTest {
    @Inject
    private TestDirectory testDirectory;
    private GraphStoreFixture fixture;

    @BeforeEach
    void setUp() {
        this.fixture = new GraphStoreFixture(this.getRecordFormatName(), this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    Node node1 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Foo")}), (Property[])new Property[0]);
                    Node node2 = (Node)Property.set((Entity)tx.createNode(new Label[]{Label.label((String)"Foo")}), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                    tx.commit();
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return ExecutionOrderIntegrationTest.this.getSettings();
            }
        };
    }

    @AfterEach
    void tearDown() throws Exception {
        this.fixture.close();
    }

    @Test
    void shouldRunChecksInSingleThreadedPass() throws Exception {
        int threads = ConsistencyCheckService.defaultConsistencyCheckThreadsNumber();
        FullCheck singlePass = new FullCheck(ProgressMonitorFactory.NONE, Statistics.NONE, threads, ConsistencyFlags.DEFAULT, this.getTuningConfiguration(), false, NodeBasedMemoryLimiter.DEFAULT);
        ConsistencySummaryStatistics singlePassSummary = new ConsistencySummaryStatistics();
        InconsistencyLogger logger = (InconsistencyLogger)Mockito.mock(InconsistencyLogger.class);
        singlePass.execute(this.fixture.getInstantiatedPageCache(), this.fixture.directStoreAccess(), new InconsistencyReport(logger, singlePassSummary), (CountsStore)this.fixture.counts().get(), null, PageCacheTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Mockito.verifyNoInteractions((Object[])new Object[]{logger});
        Assertions.assertEquals((long)0L, (long)singlePassSummary.getTotalInconsistencyCount(), (String)"Expected no inconsistencies in single pass.");
    }

    private Config getTuningConfiguration() {
        return Config.defaults(Map.of(GraphDatabaseSettings.pagecache_memory, "8m", GraphDatabaseSettings.record_format, this.getRecordFormatName()));
    }

    protected String getRecordFormatName() {
        return "";
    }

    protected Map<Setting<?>, Object> getSettings() {
        return new HashMap();
    }
}

