/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.newchecker.CheckerTestBase;
import org.neo4j.consistency.newchecker.SafePropertyChainReader;
import org.neo4j.consistency.newchecker.SchemaComplianceChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SchemaComplianceCheckerTest
extends CheckerTestBase {
    private int propertyKey1;
    private int propertyKey2;
    private int propertyKey3;
    private int label1;
    private int label2;
    private int label3;

    SchemaComplianceCheckerTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        TokenWrite tokenWrite = tx.tokenWrite();
        this.propertyKey1 = tokenWrite.propertyKeyGetOrCreateForName("1");
        this.propertyKey2 = tokenWrite.propertyKeyGetOrCreateForName("2");
        this.propertyKey3 = tokenWrite.propertyKeyGetOrCreateForName("3");
        this.label1 = tokenWrite.labelGetOrCreateForName("A");
        this.label2 = tokenWrite.labelGetOrCreateForName("B");
        this.label3 = tokenWrite.labelGetOrCreateForName("C");
    }

    @Test
    void shouldReportMissingMandatoryProperty() throws Exception {
        long nodeId = 0L;
        IntObjectHashMap propertyValues = new IntObjectHashMap();
        propertyValues.put(this.propertyKey2, (Object)Values.intValue((int)99));
        long[] labels = new long[]{this.label1, this.label3};
        MutableIntObjectMap mandatoryProperties = IntObjectMaps.mutable.empty();
        mandatoryProperties.put(this.label1, (Object)IntSets.mutable.of(new int[]{this.propertyKey1, this.propertyKey2}));
        mandatoryProperties.put(this.label2, (Object)IntSets.mutable.of(new int[]{this.propertyKey1, this.propertyKey3}));
        mandatoryProperties.put(this.label3, (Object)IntSets.mutable.of(new int[]{this.propertyKey1}));
        try (SchemaComplianceChecker checker = new SchemaComplianceChecker(this.context(), mandatoryProperties, (Iterable)this.context().indexAccessors.onlineRules(EntityType.NODE), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            checker.checkContainsMandatoryProperties((PrimitiveRecord)new NodeRecord(nodeId), labels, (IntObjectMap)propertyValues, arg_0 -> ((ConsistencyReporter)this.reporter).forNode(arg_0));
        }
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.missingMandatoryProperty(ArgumentMatchers.anyInt()));
    }

    @Test
    void shouldReportNotUniquelyIndexed() throws Exception {
        long nodeId;
        LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1});
        long indexId = this.uniqueIndex((SchemaDescriptor)descriptor);
        try (AutoCloseable ignored = this.tx();){
            TextValue value = Values.stringValue((String)"a");
            long propId = this.propertyStore.nextId(PageCursorTracer.NULL);
            nodeId = this.node(this.nodeStore.nextId(PageCursorTracer.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId, (Value)value);
            propId = this.propertyStore.nextId(PageCursorTracer.NULL);
            long nodeId2 = this.node(this.nodeStore.nextId(PageCursorTracer.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId2, (Value)value);
        }
        this.checkIndexed(nodeId);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.uniqueIndexNotUnique((IndexDescriptor)ArgumentMatchers.any(), (Object[])ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @Test
    void shouldReportNotIndexed() throws Exception {
        long nodeId;
        LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1});
        this.index((SchemaDescriptor)descriptor);
        try (AutoCloseable ignored = this.tx();){
            long propId = this.propertyStore.nextId(PageCursorTracer.NULL);
            nodeId = this.node(this.nodeStore.nextId(PageCursorTracer.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)Values.stringValue((String)"a")));
        }
        this.checkIndexed(nodeId);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.notIndexed((IndexDescriptor)ArgumentMatchers.any(), (Object[])ArgumentMatchers.any()));
    }

    @Test
    void shouldCheckIndexesWithLookupFiltering() throws Exception {
        long nodeId;
        LabelSchemaDescriptor descriptor = SchemaDescriptor.forLabel((int)this.label1, (int[])new int[]{this.propertyKey1});
        long indexId = this.uniqueIndex((SchemaDescriptor)descriptor);
        try (AutoCloseable ignored = this.tx();){
            PointValue value = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{2.0, 4.0});
            long propId = this.propertyStore.nextId(PageCursorTracer.NULL);
            nodeId = this.node(this.nodeStore.nextId(PageCursorTracer.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId, (Value)value);
            propId = this.propertyStore.nextId(PageCursorTracer.NULL);
            long nodeId2 = this.node(this.nodeStore.nextId(PageCursorTracer.NULL), propId, NULL, this.label1);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)value));
            this.indexValue(descriptor, indexId, nodeId2, (Value)value);
        }
        this.checkIndexed(nodeId);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.uniqueIndexNotUnique((IndexDescriptor)ArgumentMatchers.any(), (Object[])ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    private void indexValue(LabelSchemaDescriptor descriptor, long indexId, long nodeId, Value value) throws IndexNotFoundKernelException, IndexEntryConflictException {
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        try (IndexUpdater indexUpdater = indexingService.getIndexProxy(indexId).newUpdater(IndexUpdateMode.ONLINE, PageCursorTracer.NULL);){
            indexUpdater.process(IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{value}));
        }
    }

    private void checkIndexed(long nodeId) throws Exception {
        try (SchemaComplianceChecker checker = new SchemaComplianceChecker(this.context(), (MutableIntObjectMap)new IntObjectHashMap(), (Iterable)this.context().indexAccessors.onlineRules(EntityType.NODE), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            NodeRecord node = this.loadNode(nodeId);
            checker.checkCorrectlyIndexed((PrimitiveRecord)node, this.nodeLabels(node), this.readPropertyValues(nodeId), arg_0 -> ((ConsistencyReporter)this.reporter).forNode(arg_0));
        }
    }

    private MutableIntObjectMap<Value> readPropertyValues(long nodeId) throws Exception {
        try (SafePropertyChainReader reader = new SafePropertyChainReader(this.context().withoutReporting(), PageCursorTracer.NULL);){
            NodeRecord node = this.loadNode(nodeId);
            IntObjectHashMap values = new IntObjectHashMap();
            reader.read((MutableIntObjectMap)values, (PrimitiveRecord)node, arg_0 -> ((ConsistencyReporter)this.reporter).forNode(arg_0), PageCursorTracer.NULL);
            IntObjectHashMap intObjectHashMap = values;
            return intObjectHashMap;
        }
    }
}

