/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.LabelTokenRecordCheck;
import org.neo4j.consistency.checking.NodeRecordCheck;
import org.neo4j.consistency.checking.OwningRecordCheck;
import org.neo4j.consistency.checking.PropertyKeyTokenRecordCheck;
import org.neo4j.consistency.checking.PropertyRecordCheck;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.RelationshipRecordCheck;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class DynamicOwnerIT {
    private static final int TEST_TRANSACTIONS = 100;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    private NeoStores neoStores;
    private DirectRecordAccess recordAccess;
    private DefaultPageCacheTracer pageCacheTracer;
    private final OwnerCheck ownerCheck = new OwnerCheck(true, new DynamicStore[0]);

    DynamicOwnerIT() {
    }

    @BeforeEach
    void setUp() {
        this.neoStores = this.storageEngine.testAccessNeoStores();
        StoreAccess storeAccess = new StoreAccess(this.neoStores);
        storeAccess.initialize();
        this.recordAccess = new DirectRecordAccess(storeAccess, CacheAccess.EMPTY);
        this.pageCacheTracer = new DefaultPageCacheTracer();
    }

    @Test
    void tracePageCacheAccessOnNodeOwnerCheck() throws Exception {
        this.checkOwner((CommonAbstractStore)this.neoStores.getNodeStore(), (RecordCheck)this.ownerCheck.decorateNodeChecker((OwningRecordCheck)new NodeRecordCheck()), 400);
    }

    @Test
    void tracePageCacheAccessOnPropertyOwnerCheck() throws Exception {
        this.checkOwner((CommonAbstractStore)this.neoStores.getPropertyStore(), (RecordCheck)this.ownerCheck.decoratePropertyChecker((RecordCheck)new PropertyRecordCheck()), 200);
    }

    @Test
    void tracePageCacheAccessOnRelationshipOwnerCheck() throws Exception {
        this.checkOwner((CommonAbstractStore)this.neoStores.getRelationshipStore(), (RecordCheck)this.ownerCheck.decorateRelationshipChecker((OwningRecordCheck)new RelationshipRecordCheck()), 200);
    }

    @Test
    void tracePageCacheAccessOnKeyTokenOwnerCheck() throws Exception {
        this.checkOwner((CommonAbstractStore)this.neoStores.getPropertyKeyTokenStore(), (RecordCheck)this.ownerCheck.decoratePropertyKeyTokenChecker((RecordCheck)new PropertyKeyTokenRecordCheck()), 200);
    }

    @Test
    void tracePageCacheAccessOnLabelOwnerCheck() throws Exception {
        this.checkOwner((CommonAbstractStore)this.neoStores.getLabelTokenStore(), (RecordCheck)this.ownerCheck.decorateLabelTokenChecker((RecordCheck)new LabelTokenRecordCheck()), 200);
    }

    private <T extends AbstractBaseRecord> void checkOwner(CommonAbstractStore<T, ? extends StoreHeader> store, RecordCheck<T, ? extends ConsistencyReport> check, int expected) throws Exception {
        this.prepareData();
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("checkOwner");){
            this.checkAllRecords(store, check, cursorTracer);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo((long)expected);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo((long)expected);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo((long)expected);
        }
    }

    private <T extends AbstractBaseRecord> void checkAllRecords(CommonAbstractStore<T, ? extends StoreHeader> store, RecordCheck<T, ? extends ConsistencyReport> check, PageCursorTracer cursorTracer) throws Exception {
        store.scanAllRecords(record -> {
            check.check(record, (CheckerEngine)Mockito.mock(CheckerEngine.class), (RecordAccess)this.recordAccess, cursorTracer);
            return false;
        }, PageCursorTracer.NULL);
    }

    private void prepareData() {
        RelationshipType type = RelationshipType.withName((String)"any");
        for (int i = 0; i < 100; ++i) {
            try (Transaction tx = this.database.beginTx();){
                Node start = tx.createNode(new Label[]{Label.label((String)("start" + i))});
                Node end = tx.createNode(new Label[]{Label.label((String)("end" + i))});
                start.setProperty("a" + i, (Object)"b");
                end.setProperty("c" + i, (Object)"d");
                start.createRelationshipTo(end, type);
                end.createRelationshipTo(start, type);
                tx.commit();
                continue;
            }
        }
    }
}

