/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.IndexCheck;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class IndexCheckIT {
    private static final String NODE_INDEX_NAME = "nodeIndex";
    private static final String RELATIONSHIP_INDEX_NAME = "relationshipIndex";
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private TokenNameLookup tokenNameLookup;
    private DirectRecordAccess recordAccess;
    private DefaultPageCacheTracer pageCacheTracer;
    private long nodeId;
    private long relationshipId;

    IndexCheckIT() {
    }

    @BeforeEach
    void setUp() {
        Label label = Label.label((String)"any");
        String propertyName = "property";
        RelationshipType relationshipType = RelationshipType.withName((String)"type");
        try (Transaction tx = this.database.beginTx();){
            tx.schema().indexFor(label).on(propertyName).withName(NODE_INDEX_NAME).create();
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().indexFor(relationshipType).withIndexType(IndexType.FULLTEXT).on(propertyName).withName(RELATIONSHIP_INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        tx = this.database.beginTx();
        try {
            Node start = tx.createNode(new Label[]{label});
            start.setProperty(propertyName, (Object)"nodeValue");
            this.nodeId = start.getId();
            Node end = tx.createNode(new Label[]{label});
            Relationship relationship = start.createRelationshipTo(end, relationshipType);
            this.relationshipId = relationship.getId();
            relationship.setProperty(propertyName, (Object)"relationshipValue");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        NeoStores neoStores = this.storageEngine.testAccessNeoStores();
        StoreAccess storeAccess = new StoreAccess(neoStores);
        storeAccess.initialize();
        this.recordAccess = new DirectRecordAccess(storeAccess, CacheAccess.EMPTY);
        this.pageCacheTracer = new DefaultPageCacheTracer();
    }

    @Test
    void tracePageCacheAccessOnNodeIndexCheck() {
        this.checkAssessOnIndexCheck(NODE_INDEX_NAME, this.nodeId);
    }

    @Test
    void tracePageCacheAccessOnRelationshipNodeIndexCheck() {
        this.checkAssessOnIndexCheck(RELATIONSHIP_INDEX_NAME, this.relationshipId);
    }

    private void checkAssessOnIndexCheck(String indexName, long entityId) {
        IndexDescriptor indexDescriptor = this.getIndexDescriptor(indexName);
        IndexCheck indexCheck = new IndexCheck(indexDescriptor);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("checkAssessOnIndexCheck");){
            IndexEntry indexEntry = new IndexEntry(indexDescriptor, this.tokenNameLookup, entityId);
            indexCheck.check(indexEntry, (CheckerEngine)Mockito.mock(CheckerEngine.class), (RecordAccess)this.recordAccess, cursorTracer);
            Assertions.assertThat((long)cursorTracer.pins()).isOne();
            Assertions.assertThat((long)cursorTracer.unpins()).isOne();
            Assertions.assertThat((long)cursorTracer.hits()).isOne();
        }
    }

    private IndexDescriptor getIndexDescriptor(String indexName) {
        try (Transaction transaction = this.database.beginTx();){
            SchemaRead schemaRead = ((InternalTransaction)transaction).kernelTransaction().schemaRead();
            IndexDescriptor indexDescriptor = schemaRead.indexGetForName(indexName);
            return indexDescriptor;
        }
    }
}

