/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.PropertyReader;
import org.neo4j.consistency.checking.full.RelationshipToIndexCheck;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class RelationshipIndexedCheckIT {
    private static final String INDEX_NAME = "relIndex";
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private IndexProviderMap providerMap;
    @Inject
    private IndexingService indexingService;
    @Inject
    private Config config;
    private PropertyReader propertyReader;
    private IndexAccessors indexAccessors;
    private NeoStores neoStores;
    private DefaultPageCacheTracer pageCacheTracer;
    private DirectRecordAccess recordAccess;

    RelationshipIndexedCheckIT() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.prepareTestData();
        this.pageCacheTracer = new DefaultPageCacheTracer();
        this.neoStores = this.storageEngine.testAccessNeoStores();
        StoreAccess storeAccess = new StoreAccess(this.neoStores);
        storeAccess.initialize();
        this.propertyReader = new PropertyReader(storeAccess);
        this.recordAccess = new DirectRecordAccess(storeAccess, CacheAccess.EMPTY);
        this.allowIndexToBeAccessedByIndexAccessors();
        this.indexAccessors = new IndexAccessors(this.providerMap, this.neoStores, new IndexSamplingConfig(this.config), PageCacheTracer.NULL, SchemaTestUtil.SIMPLE_NAME_LOOKUP);
    }

    @AfterEach
    void tearDown() {
        this.indexAccessors.close();
    }

    @Test
    void tracePageCacheOnRelationshipPropertyCheck() throws Exception {
        List<IndexDescriptor> indexList = List.of(this.getIndexDescriptor(INDEX_NAME));
        RelationshipToIndexCheck indexedCheck = new RelationshipToIndexCheck(indexList, this.indexAccessors, this.propertyReader);
        try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("tracePageCacheOnRelationshipPropertyCheck");){
            this.neoStores.getRelationshipStore().scanAllRecords(record -> {
                indexedCheck.check(record, (CheckerEngine)Mockito.mock(CheckerEngine.class), (RecordAccess)this.recordAccess, cursorTracer);
                return false;
            }, PageCursorTracer.NULL);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(1L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(1L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(1L);
        }
    }

    private void allowIndexToBeAccessedByIndexAccessors() throws Exception {
        this.indexingService.stop();
        this.indexingService.shutdown();
    }

    private void prepareTestData() {
        RelationshipType relType = RelationshipType.withName((String)"connection");
        String propertyName = "property";
        try (Transaction tx = this.database.beginTx();){
            Node start = tx.createNode();
            Node end = tx.createNode();
            Relationship relationship = start.createRelationshipTo(end, relType);
            relationship.setProperty(propertyName, (Object)"value");
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().indexFor(relType).on(propertyName).withIndexType(IndexType.FULLTEXT).withName(INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexOnline(INDEX_NAME, 10L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private IndexDescriptor getIndexDescriptor(String indexName) {
        try (Transaction transaction = this.database.beginTx();){
            SchemaRead schemaRead = ((InternalTransaction)transaction).kernelTransaction().schemaRead();
            IndexDescriptor indexDescriptor = schemaRead.indexGetForName(indexName);
            return indexDescriptor;
        }
    }
}

