/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.index.label.LabelScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStore;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.AbstractDelegatingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={TestDirectorySupportExtension.class, RandomExtension.class})
public class DetectRandomSabotageIT {
    private static final int SOME_WAY_TOO_HIGH_ID = 10000000;
    private static final int NUMBER_OF_NODES = 10000;
    private static final int NUMBER_OF_INDEXES = 7;
    private static final String[] TOKEN_NAMES = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight"};
    @Inject
    TestDirectory directory;
    @Inject
    protected RandomRule random;
    private DatabaseManagementService dbms;
    private NeoStores neoStores;
    private DependencyResolver resolver;

    private DatabaseManagementService getDbms(Path home) {
        return this.addConfig((DatabaseManagementServiceBuilder)this.createBuilder(home)).build();
    }

    protected TestDatabaseManagementServiceBuilder createBuilder(Path home) {
        return new TestDatabaseManagementServiceBuilder(home);
    }

    @BeforeEach
    protected void setUp() {
        this.dbms = this.getDbms(this.directory.homePath());
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbms.database("neo4j");
        MutableLongList nodeIds = this.createNodes(db);
        MutableLongSet singleRelationshipNodes = LongSets.mutable.empty();
        MutableLongSet denseNodes = LongSets.mutable.empty();
        while (singleRelationshipNodes.size() < 5) {
            singleRelationshipNodes.add(nodeIds.get(this.random.nextInt(nodeIds.size())));
        }
        while (denseNodes.size() < 5) {
            long nodeId = nodeIds.get(this.random.nextInt(nodeIds.size()));
            if (singleRelationshipNodes.contains(nodeId)) continue;
            denseNodes.add(nodeId);
        }
        this.createRelationships(db, nodeIds, singleRelationshipNodes);
        this.createAdditionalRelationshipsForDenseNodes(db, nodeIds, denseNodes);
        this.deleteSomeEntities(db, nodeIds, singleRelationshipNodes, denseNodes);
        this.createSchema(db);
        this.neoStores = ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        this.resolver = db.getDependencyResolver();
    }

    @AfterEach
    void tearDown() {
        this.dbms.shutdown();
    }

    @Test
    void shouldDetectRandomSabotage() throws Exception {
        SabotageType type = (SabotageType)((Object)this.random.among((Object[])SabotageType.values()));
        Sabotage sabotage = type.run(this.random, this.neoStores, this.resolver);
        ConsistencyCheckService.Result result = this.shutDownAndRunConsistencyChecker();
        boolean hasSomeErrorOrWarning = result.summary().getTotalInconsistencyCount() > 0L || result.summary().getTotalWarningCount() > 0L;
        Assertions.assertTrue((boolean)hasSomeErrorOrWarning);
    }

    private void createSchema(GraphDatabaseAPI db) {
        for (int i = 0; i < 7; ++i) {
            Transaction tx2;
            Label label = Label.label((String)((String)this.random.among((Object[])TOKEN_NAMES)));
            String[] keys = (String[])this.random.selection((Object[])TOKEN_NAMES, 1, 3, false);
            try {
                tx2 = db.beginTx();
                try {
                    IndexCreator indexCreator = tx2.schema().indexFor(label);
                    for (String key : keys) {
                        indexCreator = indexCreator.on(key);
                    }
                    indexCreator.create();
                    tx2.commit();
                }
                finally {
                    if (tx2 != null) {
                        tx2.close();
                    }
                }
            }
            catch (ConstraintViolationException tx2) {
                // empty catch block
            }
            if (keys.length != 1 || !((double)this.random.nextFloat() < 0.3)) continue;
            try {
                tx2 = db.beginTx();
                try {
                    ConstraintCreator constraintCreator = tx2.schema().constraintFor(label);
                    for (String key : keys) {
                        constraintCreator = constraintCreator.assertPropertyIsUnique(key);
                    }
                    constraintCreator.create();
                    tx2.commit();
                    continue;
                }
                finally {
                    if (tx2 != null) {
                        tx2.close();
                    }
                }
            }
            catch (ConstraintViolationException constraintViolationException) {
                // empty catch block
            }
        }
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
    }

    private void deleteSomeEntities(GraphDatabaseAPI db, MutableLongList nodeIds, MutableLongSet singleRelationshipNodes, MutableLongSet denseNodes) {
        int nodesToDelete = 100;
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < nodesToDelete; ++i) {
                long nodeId;
                while (singleRelationshipNodes.contains(nodeId = nodeIds.get(this.random.nextInt(nodeIds.size()))) || denseNodes.contains(nodeId)) {
                }
                nodeIds.remove(nodeId);
                Node node = tx.getNodeById(nodeId);
                node.getRelationships().forEach(Relationship::delete);
                node.delete();
            }
            tx.commit();
        }
    }

    private void createAdditionalRelationshipsForDenseNodes(GraphDatabaseAPI db, MutableLongList nodeIds, MutableLongSet denseNodes) {
        try (Transaction tx = db.beginTx();){
            int additionalRelationships = denseNodes.size() * (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue();
            long[] denseNodeIds = denseNodes.toArray();
            for (int i = 0; i < additionalRelationships; ++i) {
                Node denseNode = tx.getNodeById(denseNodeIds[i % denseNodeIds.length]);
                Node otherNode = tx.getNodeById(nodeIds.get(this.random.nextInt(nodeIds.size())));
                Node startNode = this.random.nextBoolean() ? denseNode : otherNode;
                Node endNode = startNode == denseNode ? otherNode : denseNode;
                startNode.createRelationshipTo(endNode, RelationshipType.withName((String)((String)this.random.among((Object[])TOKEN_NAMES))));
            }
            tx.commit();
        }
    }

    private void createRelationships(GraphDatabaseAPI db, MutableLongList nodeIds, MutableLongSet singleRelationshipNodes) {
        try (Transaction tx = db.beginTx();){
            int numberOfRelationships = (int)(10000.0f * (10.0f + 10.0f * this.random.nextFloat()));
            for (int i = 0; i < numberOfRelationships; ++i) {
                Node startNode = tx.getNodeById(nodeIds.get(this.random.nextInt(nodeIds.size())));
                Node endNode = tx.getNodeById(nodeIds.get(this.random.nextInt(nodeIds.size())));
                startNode.createRelationshipTo(endNode, RelationshipType.withName((String)((String)this.random.among((Object[])TOKEN_NAMES))));
                if (singleRelationshipNodes.remove(startNode.getId())) {
                    nodeIds.remove(startNode.getId());
                }
                if (!singleRelationshipNodes.remove(endNode.getId())) continue;
                nodeIds.remove(endNode.getId());
            }
            tx.commit();
        }
    }

    private MutableLongList createNodes(GraphDatabaseAPI db) {
        MutableLongList nodeIds = LongLists.mutable.empty();
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < 10000; ++i) {
                Node node = tx.createNode(DetectRandomSabotageIT.labels((String[])this.random.selection((Object[])TOKEN_NAMES, 0, TOKEN_NAMES.length, false)));
                this.setRandomProperties((Entity)node);
                nodeIds.add(node.getId());
            }
            tx.commit();
        }
        return nodeIds;
    }

    private void setRandomProperties(Entity entity) {
        for (String key : (String[])this.random.selection((Object[])TOKEN_NAMES, 0, TOKEN_NAMES.length, false)) {
            entity.setProperty(key, this.randomValue().asObjectCopy());
        }
    }

    private Value randomValue() {
        switch (this.random.nextInt(100)) {
            case 0: {
                return this.random.nextAlphaNumericTextValue(300, 500);
            }
            case 1: {
                int arrayLength = this.random.nextInt(20, 40);
                String[] array = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    array[i] = this.random.nextAlphaNumericTextValue(10, 20).stringValue();
                }
                return Values.stringArray((String[])array);
            }
        }
        return this.random.nextValue();
    }

    private static Label[] labels(String[] names) {
        return (Label[])Stream.of(names).map(Label::label).toArray(Label[]::new);
    }

    private ConsistencyCheckService.Result shutDownAndRunConsistencyChecker() throws ConsistencyCheckIncompleteException {
        this.dbms.shutdown();
        Config.Builder builder = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.directory.homePath());
        Config config = this.addConfig(builder).build();
        return new ConsistencyCheckService().runFullConsistencyCheck(DatabaseLayout.of((Config)config), config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false, ConsistencyFlags.DEFAULT.withCheckRelationshipTypeScanStore(true));
    }

    protected <T> T addConfig(T t, SetConfigAction<T> action) {
        action.setConfig(t, RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store, true);
        action.setConfig(t, GraphDatabaseInternalSettings.experimental_consistency_checker, true);
        return t;
    }

    private DatabaseManagementServiceBuilder addConfig(DatabaseManagementServiceBuilder builder) {
        return this.addConfig(builder, DatabaseManagementServiceBuilder::setConfig);
    }

    private Config.Builder addConfig(Config.Builder builder) {
        return this.addConfig(builder, Config.Builder::set);
    }

    private static class Sabotage {
        private final String description;
        private final String record;

        Sabotage(String description, String record) {
            this.description = description;
            this.record = record;
        }

        String description() {
            return this.description;
        }

        String record() {
            return this.record;
        }
    }

    private static enum SabotageType {
        NODE_PROP{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.loadChangeUpdate(random, stores.getNodeStore(), SabotageType.usedRecord(), PrimitiveRecord::getNextProp, PrimitiveRecord::setNextProp, () -> this.randomLargeSometimesNegative(random));
            }
        }
        ,
        NODE_REL{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.loadChangeUpdate(random, stores.getNodeStore(), SabotageType.usedRecord(), NodeRecord::getNextRel, NodeRecord::setNextRel);
            }
        }
        ,
        NODE_LABELS{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                NodeStore store = stores.getNodeStore();
                NodeRecord node = (NodeRecord)this.randomRecord(random, store, SabotageType.usedRecord());
                NodeRecord before = (NodeRecord)store.getRecord(node.getId(), (AbstractBaseRecord)((NodeRecord)store.newRecord()), RecordLoad.NORMAL, PageCursorTracer.NULL);
                NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
                long[] existing = nodeLabels.get(store, PageCursorTracer.NULL);
                if (random.nextBoolean()) {
                    do {
                        long labelField;
                        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)(labelField = random.nextLong(0xFFFFFFFFFFL)))) continue;
                        node.setLabelField(labelField, node.getDynamicLabelRecords());
                    } while (Arrays.equals(existing, NodeLabelsField.get((NodeRecord)node, (NodeStore)store, (PageCursorTracer)PageCursorTracer.NULL)));
                } else {
                    long existingLabelField = node.getLabelField();
                    do {
                        node.setLabelField(DynamicNodeLabels.dynamicPointer((long)this.randomLargeSometimesNegative(random)), node.getDynamicLabelRecords());
                    } while (existingLabelField == node.getLabelField());
                }
                store.updateRecord((AbstractBaseRecord)node, PageCursorTracer.NULL);
                return SabotageType.recordSabotage(before, node);
            }
        }
        ,
        NODE_IN_USE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.setRandomRecordNotInUse(random, stores.getNodeStore());
            }
        }
        ,
        RELATIONSHIP_CHAIN{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                RelationshipStore store = stores.getRelationshipStore();
                RelationshipRecord relationship = (RelationshipRecord)this.randomRecord(random, store, SabotageType.usedRecord());
                RelationshipRecord before = (RelationshipRecord)store.getRecord(relationship.getId(), (AbstractBaseRecord)((RelationshipRecord)store.newRecord()), RecordLoad.NORMAL, PageCursorTracer.NULL);
                LongSupplier rng = () -> this.randomIdOrSometimesDefault(random, Record.NULL_REFERENCE.longValue(), id -> true);
                switch (random.nextInt(4)) {
                    case 0: {
                        if (!relationship.isFirstInFirstChain()) {
                            this.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getFirstPrevRel(), arg_0 -> ((RelationshipRecord)relationship).setFirstPrevRel(arg_0), rng);
                            break;
                        }
                    }
                    case 1: {
                        this.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getFirstNextRel(), arg_0 -> ((RelationshipRecord)relationship).setFirstNextRel(arg_0), rng);
                        break;
                    }
                    case 2: {
                        if (!relationship.isFirstInSecondChain()) {
                            this.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getSecondPrevRel(), arg_0 -> ((RelationshipRecord)relationship).setSecondPrevRel(arg_0), rng);
                            break;
                        }
                    }
                    default: {
                        this.guaranteedChangedId(() -> ((RelationshipRecord)relationship).getSecondNextRel(), arg_0 -> ((RelationshipRecord)relationship).setSecondNextRel(arg_0), rng);
                    }
                }
                store.updateRecord((AbstractBaseRecord)relationship, PageCursorTracer.NULL);
                return SabotageType.recordSabotage(before, relationship);
            }
        }
        ,
        RELATIONSHIP_NODES{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                boolean startNode = random.nextBoolean();
                ToLongFunction<RelationshipRecord> getter = startNode ? RelationshipRecord::getFirstNode : RelationshipRecord::getSecondNode;
                BiConsumer<RelationshipRecord, Long> setter = startNode ? RelationshipRecord::setFirstNode : RelationshipRecord::setSecondNode;
                return this.loadChangeUpdate(random, stores.getRelationshipStore(), SabotageType.usedRecord(), getter, setter);
            }
        }
        ,
        RELATIONSHIP_PROP{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.loadChangeUpdate(random, stores.getRelationshipStore(), SabotageType.usedRecord(), PrimitiveRecord::getNextProp, PrimitiveRecord::setNextProp, () -> this.randomIdOrSometimesDefault(random, Record.NULL_REFERENCE.longValue(), propertyId -> {
                    if (propertyId < 0L) {
                        return true;
                    }
                    PropertyStore propertyStore = stores.getPropertyStore();
                    PropertyRecord record = (PropertyRecord)propertyStore.getRecord(propertyId, (AbstractBaseRecord)propertyStore.newRecord(), RecordLoad.CHECK, PageCursorTracer.NULL);
                    return !record.inUse() || !Record.NULL_REFERENCE.is(record.getPrevProp());
                }));
            }
        }
        ,
        RELATIONSHIP_TYPE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.loadChangeUpdate(random, stores.getRelationshipStore(), SabotageType.usedRecord(), RelationshipRecord::getType, (relationship, type) -> relationship.setType(type.intValue()), () -> random.nextInt(TOKEN_NAMES.length * 2) - 1);
            }
        }
        ,
        RELATIONSHIP_IN_USE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.setRandomRecordNotInUse(random, stores.getRelationshipStore());
            }
        }
        ,
        PROPERTY_CHAIN{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                boolean prev = random.nextBoolean();
                if (prev) {
                    return this.loadChangeUpdate(random, stores.getPropertyStore(), SabotageType.usedRecord(), PropertyRecord::getPrevProp, PropertyRecord::setPrevProp);
                }
                return this.loadChangeUpdate(random, stores.getPropertyStore(), SabotageType.usedRecord(), PropertyRecord::getNextProp, PropertyRecord::setNextProp, () -> this.randomLargeSometimesNegative(random));
            }
        }
        ,
        PROPERTY_IN_USE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.setRandomRecordNotInUse(random, stores.getPropertyStore());
            }
        }
        ,
        STRING_LENGTH{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return SabotageType.loadChangeUpdateDynamicChain(random, stores.getPropertyStore(), (AbstractDynamicStore)stores.getPropertyStore().getStringStore(), PropertyType.STRING, record -> record.setData(Arrays.copyOf(record.getData(), random.nextInt(record.getLength()))), v -> true);
            }
        }
        ,
        STRING_IN_USE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.setRandomRecordNotInUse(random, stores.getPropertyStore().getStringStore());
            }
        }
        ,
        ARRAY_CHAIN{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return SabotageType.loadChangeUpdateDynamicChain(random, stores.getPropertyStore(), (AbstractDynamicStore)stores.getPropertyStore().getArrayStore(), PropertyType.ARRAY, record -> record.setData(Arrays.copyOf(record.getData(), random.nextInt(record.getLength()))), v -> v.asObjectCopy() instanceof String[]);
            }
        }
        ,
        ARRAY_LENGTH{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return SabotageType.loadChangeUpdateDynamicChain(random, stores.getPropertyStore(), (AbstractDynamicStore)stores.getPropertyStore().getArrayStore(), PropertyType.ARRAY, record -> record.setData(Arrays.copyOf(record.getData(), random.nextInt(record.getLength()))), v -> true);
            }
        }
        ,
        ARRAY_IN_USE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.setRandomRecordNotInUse(random, stores.getPropertyStore().getArrayStore());
            }
        }
        ,
        RELATIONSHIP_GROUP_CHAIN{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.loadChangeUpdate(random, stores.getRelationshipGroupStore(), SabotageType.usedRecord(), RelationshipGroupRecord::getNext, RelationshipGroupRecord::setNext, () -> this.randomLargeSometimesNegative(random));
            }
        }
        ,
        RELATIONSHIP_GROUP_TYPE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.loadChangeUpdate(random, stores.getRelationshipGroupStore(), SabotageType.usedRecord(), RelationshipGroupRecord::getType, (group, type) -> group.setType(type.intValue()), () -> random.nextInt(TOKEN_NAMES.length * 2) - 1);
            }
        }
        ,
        RELATIONSHIP_GROUP_FIRST_RELATIONSHIP{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                BiConsumer<RelationshipGroupRecord, Long> setter;
                ToLongFunction<RelationshipGroupRecord> getter;
                switch (random.nextInt(3)) {
                    case 0: {
                        getter = RelationshipGroupRecord::getFirstOut;
                        setter = RelationshipGroupRecord::setFirstOut;
                        break;
                    }
                    case 1: {
                        getter = RelationshipGroupRecord::getFirstIn;
                        setter = RelationshipGroupRecord::setFirstIn;
                        break;
                    }
                    default: {
                        getter = RelationshipGroupRecord::getFirstLoop;
                        setter = RelationshipGroupRecord::setFirstLoop;
                    }
                }
                return this.loadChangeUpdate(random, stores.getRelationshipGroupStore(), SabotageType.usedRecord(), getter, setter, () -> this.randomLargeSometimesNegative(random));
            }
        }
        ,
        RELATIONSHIP_GROUP_IN_USE{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) {
                return this.setRandomRecordNotInUse(random, stores.getRelationshipGroupStore());
            }
        }
        ,
        SCHEMA_INDEX_ENTRY{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) throws Exception {
                IndexingService indexing = (IndexingService)otherDependencies.resolveDependency(IndexingService.class);
                boolean add = random.nextBoolean();
                long[] indexIds = indexing.getIndexIds().toArray();
                long indexId = indexIds[random.nextInt(indexIds.length)];
                IndexProxy indexProxy = indexing.getIndexProxy(indexId);
                while (indexProxy instanceof AbstractDelegatingIndexProxy) {
                    indexProxy = ((AbstractDelegatingIndexProxy)indexProxy).getDelegate();
                }
                IndexAccessor accessor = ((OnlineIndexProxy)indexProxy).accessor();
                long selectedEntityId = -1L;
                Object[] selectedValues = null;
                try (IndexEntriesReader reader = accessor.newAllIndexEntriesReader(1, PageCursorTracer.NULL)[0];){
                    long entityId = -1L;
                    Object[] values = null;
                    while (reader.hasNext()) {
                        entityId = reader.next();
                        values = reader.values();
                        if (!((double)random.nextFloat() < 0.01)) continue;
                        selectedEntityId = entityId;
                        selectedValues = values;
                    }
                    if (selectedValues == null && entityId != -1L) {
                        selectedEntityId = entityId;
                        selectedValues = values;
                    }
                }
                if (selectedEntityId == -1L) {
                    throw new UnsupportedOperationException("Something is wrong with the test, could not find index entry to sabotage");
                }
                try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE_IDEMPOTENT, PageCursorTracer.NULL);){
                    if (add) {
                        selectedEntityId = random.nextLong(10000000L);
                        updater.process(IndexEntryUpdate.add((long)selectedEntityId, (SchemaDescriptorSupplier)indexProxy.getDescriptor(), (Value[])selectedValues));
                    } else {
                        updater.process(IndexEntryUpdate.remove((long)selectedEntityId, (SchemaDescriptorSupplier)indexProxy.getDescriptor(), (Value[])selectedValues));
                    }
                }
                TokenNameLookup tokenNameLookup = (TokenNameLookup)otherDependencies.resolveDependency(TokenNameLookup.class);
                String userDescription = indexProxy.getDescriptor().userDescription(tokenNameLookup);
                return new Sabotage(String.format("%s entityId:%d values:%s index:%s", add ? "Add" : "Remove", selectedEntityId, Arrays.toString(selectedValues), userDescription), userDescription);
            }
        }
        ,
        LABEL_INDEX_ENTRY{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) throws Exception {
                int labelId;
                LabelScanStore labelIndex = (LabelScanStore)otherDependencies.resolveDependency(LabelScanStore.class);
                boolean add = random.nextBoolean();
                NodeStore store = stores.getNodeStore();
                NodeRecord nodeRecord = this.randomRecord(random, store, r -> add || r.inUse() && r.getLabelField() != Record.NO_LABELS_FIELD.longValue());
                TokenHolders tokenHolders = (TokenHolders)otherDependencies.resolveDependency(TokenHolders.class);
                HashSet<String> labelNames = new HashSet<String>(Arrays.asList(TOKEN_NAMES));
                try (TokenScanWriter writer = labelIndex.newWriter(PageCursorTracer.NULL);){
                    if (nodeRecord.inUse()) {
                        long[] labelsBefore;
                        NodeLabels labelsField = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
                        for (long labelIdBefore : labelsBefore = labelsField.get(store, PageCursorTracer.NULL)) {
                            labelNames.remove(tokenHolders.labelTokens().getTokenById((int)labelIdBefore).name());
                        }
                        if (add) {
                            labelId = labelNames.isEmpty() ? 9999 : tokenHolders.labelTokens().getIdByName((String)random.among(new ArrayList<String>(labelNames)));
                            long[] labelsAfter = Arrays.copyOf(labelsBefore, labelsBefore.length + 1);
                            labelsAfter[labelsBefore.length] = labelId;
                            Arrays.sort(labelsAfter);
                            writer.write(EntityTokenUpdate.tokenChanges((long)nodeRecord.getId(), (long[])labelsBefore, (long[])labelsAfter));
                        } else {
                            MutableLongList labels = LongLists.mutable.of(Arrays.copyOf(labelsBefore, labelsBefore.length));
                            labelId = (int)labels.removeAtIndex(random.nextInt(labels.size()));
                            long[] labelsAfter = labels.toSortedArray();
                            writer.write(EntityTokenUpdate.tokenChanges((long)nodeRecord.getId(), (long[])labelsBefore, (long[])labelsAfter));
                        }
                    } else {
                        labelId = tokenHolders.labelTokens().getIdByName((String)random.among((Object[])TOKEN_NAMES));
                        writer.write(EntityTokenUpdate.tokenChanges((long)nodeRecord.getId(), (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{labelId}));
                    }
                }
                return new Sabotage(String.format("%s labelId:%d node:%s", add ? "Add" : "Remove", labelId, nodeRecord), nodeRecord.toString());
            }
        }
        ,
        RELATIONSHIP_TYPE_INDEX_ENTRY{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) throws Exception {
                String operation;
                int typeId;
                RelationshipTypeScanStore relationshipTypeIndex = (RelationshipTypeScanStore)otherDependencies.resolveDependency(RelationshipTypeScanStore.class);
                RelationshipStore store = stores.getRelationshipStore();
                RelationshipRecord relationshipRecord = this.randomRecord(random, store, r -> true);
                TokenHolders tokenHolders = (TokenHolders)otherDependencies.resolveDependency(TokenHolders.class);
                HashSet<String> relationshipTypeNames = new HashSet<String>(Arrays.asList(TOKEN_NAMES));
                int typeBefore = relationshipRecord.getType();
                long[] typesBefore = new long[]{typeBefore};
                try (TokenScanWriter writer = relationshipTypeIndex.newWriter(PageCursorTracer.NULL);){
                    if (relationshipRecord.inUse()) {
                        long[] typesAfter;
                        int mode = random.nextInt(3);
                        if (mode < 2) {
                            relationshipTypeNames.remove(tokenHolders.relationshipTypeTokens().getTokenById(typeBefore).name());
                            typeId = tokenHolders.relationshipTypeTokens().getIdByName((String)random.among(new ArrayList<String>(relationshipTypeNames)));
                            if (mode == 0) {
                                operation = "Replace relationship type in index with a new type";
                                typesAfter = new long[]{typeId};
                            } else {
                                operation = "Add additional relationship type in index";
                                typesAfter = new long[]{typeId, typeBefore};
                                Arrays.sort(typesAfter);
                            }
                        } else {
                            operation = "Remove relationship type from index";
                            typeId = typeBefore;
                            typesAfter = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
                        }
                        writer.write(EntityTokenUpdate.tokenChanges((long)relationshipRecord.getId(), (long[])typesBefore, (long[])typesAfter));
                    } else {
                        operation = "Add relationship type to a non-existing relationship (in relationship type index only)";
                        typeId = tokenHolders.labelTokens().getIdByName((String)random.among((Object[])TOKEN_NAMES));
                        writer.write(EntityTokenUpdate.tokenChanges((long)relationshipRecord.getId(), (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])new long[]{typeId}));
                    }
                }
                String description = String.format("%s relationshipTypeId:%d relationship:%s", operation, typeId, relationshipRecord);
                return new Sabotage(description, relationshipRecord.toString());
            }
        }
        ,
        GRAPH_ENTITY_USES_INTERNAL_TOKEN{

            @Override
            Sabotage run(RandomRule random, NeoStores stores, DependencyResolver otherDependencies) throws Exception {
                TokenHolders tokenHolders = (TokenHolders)otherDependencies.resolveDependency(TokenHolders.class);
                String tokenName = "Token-" + System.currentTimeMillis();
                int[] tokenId = new int[1];
                switch (random.nextInt(3)) {
                    case 0: {
                        tokenHolders.labelTokens().getOrCreateInternalIds(new String[]{tokenName}, tokenId);
                        NodeRecord node = (NodeRecord)this.randomRecord(random, stores.getNodeStore(), SabotageType.usedRecord());
                        NodeLabelsField.parseLabelsField((NodeRecord)node).add((long)tokenId[0], stores.getNodeStore(), (DynamicRecordAllocator)stores.getNodeStore().getDynamicLabelStore(), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                        stores.getNodeStore().updateRecord((AbstractBaseRecord)node, PageCursorTracer.NULL);
                        return new Sabotage("Node has label token which is internal", node.toString());
                    }
                    case 1: {
                        tokenHolders.propertyKeyTokens().getOrCreateInternalIds(new String[]{tokenName}, tokenId);
                        PropertyRecord property = (PropertyRecord)this.randomRecord(random, stores.getPropertyStore(), SabotageType.usedRecord());
                        PropertyBlock block = (PropertyBlock)property.iterator().next();
                        property.removePropertyBlock(block.getKeyIndexId());
                        PropertyBlock newBlock = new PropertyBlock();
                        stores.getPropertyStore().encodeValue(newBlock, tokenId[0], (Value)Values.intValue((int)11), PageCursorTracer.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                        property.addPropertyBlock(newBlock);
                        stores.getPropertyStore().updateRecord((AbstractBaseRecord)property, PageCursorTracer.NULL);
                        return new Sabotage("Property has key which is internal", property.toString());
                    }
                }
                tokenHolders.relationshipTypeTokens().getOrCreateInternalIds(new String[]{tokenName}, tokenId);
                RelationshipRecord relationship = (RelationshipRecord)this.randomRecord(random, stores.getRelationshipStore(), SabotageType.usedRecord());
                relationship.setType(tokenId[0]);
                stores.getRelationshipStore().updateRecord((AbstractBaseRecord)relationship, PageCursorTracer.NULL);
                return new Sabotage("Relationship has type which is internal", relationship.toString());
            }
        };


        protected <T extends AbstractBaseRecord> Sabotage setRandomRecordNotInUse(RandomRule random, RecordStore<T> store) {
            T before = this.randomRecord(random, store, SabotageType.usedRecord());
            AbstractBaseRecord record = store.getRecord(before.getId(), store.newRecord(), RecordLoad.NORMAL, PageCursorTracer.NULL);
            record.setInUse(false);
            store.updateRecord(record, PageCursorTracer.NULL);
            return SabotageType.recordSabotage(before, record);
        }

        private static <T extends AbstractBaseRecord> Predicate<T> usedRecord() {
            return AbstractBaseRecord::inUse;
        }

        protected <T extends AbstractBaseRecord> Sabotage loadChangeUpdate(RandomRule random, RecordStore<T> store, Predicate<T> filter, ToLongFunction<T> idGetter, BiConsumer<T, Long> idSetter) {
            return this.loadChangeUpdate(random, store, filter, idGetter, idSetter, () -> this.randomIdOrSometimesDefault(random, Record.NULL_REFERENCE.longValue(), id -> true));
        }

        protected <T extends AbstractBaseRecord> Sabotage loadChangeUpdate(RandomRule random, RecordStore<T> store, Predicate<T> filter, ToLongFunction<T> idGetter, BiConsumer<T, Long> idSetter, LongSupplier rng) {
            T before = this.randomRecord(random, store, filter);
            AbstractBaseRecord record = store.getRecord(before.getId(), store.newRecord(), RecordLoad.NORMAL, PageCursorTracer.NULL);
            this.guaranteedChangedId(() -> idGetter.applyAsLong(record), changedId -> idSetter.accept(record, changedId), rng);
            store.updateRecord(record, PageCursorTracer.NULL);
            return SabotageType.recordSabotage(before, record);
        }

        private static <T extends AbstractBaseRecord> Sabotage recordSabotage(T before, T after) {
            return new Sabotage(String.format("%s --> %s", before, after), after.toString());
        }

        protected void guaranteedChangedId(LongSupplier getter, LongConsumer setter, LongSupplier rng) {
            long nextProp = getter.getAsLong();
            while (getter.getAsLong() == nextProp) {
                setter.accept(rng.getAsLong());
            }
        }

        /*
         * Unable to fully structure code
         */
        private static Sabotage loadChangeUpdateDynamicChain(RandomRule random, PropertyStore propertyStore, AbstractDynamicStore dynamicStore, PropertyType valueType, Consumer<DynamicRecord> vandal, Predicate<Value> checkability) {
            propertyRecord = propertyStore.newRecord();
            block0: while (true) {
                propertyStore.getRecord(random.nextLong(propertyStore.getHighId()), (AbstractBaseRecord)propertyRecord, RecordLoad.CHECK, PageCursorTracer.NULL);
                if (!propertyRecord.inUse()) continue;
                var7_7 = propertyRecord.iterator();
                while (true) {
                    if (var7_7.hasNext()) ** break;
                    continue block0;
                    block = (PropertyBlock)var7_7.next();
                    if (block.getType() != valueType || !checkability.test(block.getType().value(block, propertyStore, PageCursorTracer.NULL))) continue;
                    propertyStore.ensureHeavy(block, PageCursorTracer.NULL);
                    if (block.getValueRecords().size() > 1) break block0;
                }
                break;
            }
            dynamicRecord = (DynamicRecord)block.getValueRecords().get(random.nextInt(block.getValueRecords().size() - 1));
            before = (DynamicRecord)dynamicStore.getRecord(dynamicRecord.getId(), (AbstractBaseRecord)((DynamicRecord)dynamicStore.newRecord()), RecordLoad.NORMAL, PageCursorTracer.NULL);
            vandal.accept(dynamicRecord);
            dynamicStore.updateRecord((AbstractBaseRecord)dynamicRecord, PageCursorTracer.NULL);
            return SabotageType.recordSabotage(before, dynamicRecord);
        }

        protected long randomIdOrSometimesDefault(RandomRule random, long defaultValue, LongPredicate filter) {
            return (double)random.nextFloat() < 0.1 ? defaultValue : this.randomLargeSometimesNegative(random, filter);
        }

        protected long randomLargeSometimesNegative(RandomRule random) {
            return this.randomLargeSometimesNegative(random, id -> true);
        }

        protected long randomLargeSometimesNegative(RandomRule random, LongPredicate filter) {
            long value;
            do {
                value = random.nextLong(10000000L);
            } while (!filter.test(value = (double)random.nextFloat() < 0.2 ? -value : value));
            return value;
        }

        protected <T extends AbstractBaseRecord> T randomRecord(RandomRule random, RecordStore<T> store, Predicate<T> filter) {
            long highId = store.getHighId();
            AbstractBaseRecord record = store.newRecord();
            do {
                store.getRecord(random.nextLong(highId), record, RecordLoad.FORCE, PageCursorTracer.NULL);
            } while (!filter.test(record));
            return (T)record;
        }

        abstract Sabotage run(RandomRule var1, NeoStores var2, DependencyResolver var3) throws Exception;
    }

    @FunctionalInterface
    protected static interface SetConfigAction<TARGET> {
        public <VALUE> void setConfig(TARGET var1, Setting<VALUE> var2, VALUE var3);
    }
}

