/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.newchecker;

import java.io.IOException;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.newchecker.CheckerContext;
import org.neo4j.consistency.newchecker.CheckerTestBase;
import org.neo4j.consistency.newchecker.RelationshipChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.index.label.RelationshipTypeScanStoreSettings;
import org.neo4j.internal.index.label.TokenScanWriter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.EntityTokenUpdate;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class RelationshipCheckerWithRelationshipTypeScanStoreTest
extends CheckerTestBase {
    private int type;
    private int lowerType;
    private int higherType;
    @Inject
    private RandomRule random;

    RelationshipCheckerWithRelationshipTypeScanStoreTest() {
    }

    @Override
    void configure(TestDatabaseManagementServiceBuilder builder) {
        super.configure(builder);
        builder.setConfig(RelationshipTypeScanStoreSettings.enable_relationship_type_scan_store, (Object)true);
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        this.lowerType = tx.tokenWrite().relationshipTypeGetOrCreateForName("A");
        this.type = tx.tokenWrite().relationshipTypeGetOrCreateForName("B");
        this.higherType = tx.tokenWrite().relationshipTypeGetOrCreateForName("C");
        Assertions.assertThat((int)this.lowerType).isLessThan(this.type);
        Assertions.assertThat((int)this.type).isLessThan(this.higherType);
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void testShouldNotReportAnythingIfDataIsCorrect(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> this.createCompleteEntry((TokenScanWriter)writer, this.type)), null);
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexPointToRelationshipNotInUse(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.notInUse(relationshipId);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.type);
        }), reporter -> reporter.relationshipNotInUse((RelationshipRecord)ArgumentMatchers.any()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasHigherTypeThanRelationshipInStore(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasLowerTypeThanRelationshipInStore(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.lowerType);
        }), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexIsMissingEntryForRelationshipInUse(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> this.createStoreEntry(this.type)), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasMultipleTypesForSameRelationshipOneCorrect(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.type);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.lowerType);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasMultipleTypesForSameRelationshipNoneCorrect(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.lowerType);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasMultipleTypesForSameRelationshipNotInUse(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<TokenScanWriter, IOException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.notInUse(relationshipId);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.type);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.lowerType);
            this.createIndexEntry((TokenScanWriter)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipNotInUse((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void storeHasBigGapButIndexDoesNot() throws Exception {
        try (Transaction tx = this.db.beginTx();
             TokenScanWriter writer = this.relationshipTypeIndex.newWriter(PageCursorTracer.NULL);){
            for (int i = 0; i < 200; ++i) {
                long relationshipId;
                if (i == 0) {
                    this.createCompleteEntry(writer, this.type);
                    continue;
                }
                if (i == 10) {
                    relationshipId = this.createStoreEntry(this.type);
                    this.notInUse(relationshipId);
                    this.createIndexEntry(writer, relationshipId, this.type);
                    continue;
                }
                if (i == 99) {
                    this.createCompleteEntry(writer, this.type);
                    continue;
                }
                relationshipId = this.createStoreEntry(this.type);
                this.notInUse(relationshipId);
            }
            tx.commit();
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipTypeScanConsistencyReport.class, reporter -> reporter.relationshipNotInUse((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldNotCheckRelationshipTypeScanStoreIfNotConfiguredTo() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.createStoreEntry(this.type);
            tx.commit();
        }
        ConsistencyFlags flags = new ConsistencyFlags(true, true, true, true, false, true);
        CheckerContext checkerContext = this.context(flags);
        this.check(checkerContext);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.monitor});
    }

    @SafeVarargs
    private void doVerifyCorrectReport(Density density, ThrowingConsumer<TokenScanWriter, IOException> targetRelationshipAction, Consumer<ConsistencyReport.RelationshipTypeScanConsistencyReport> ... expectedCalls) throws Exception {
        double recordFrequency = this.densityAsFrequency(density);
        int nbrOfRelationships = this.random.nextInt(1, 200);
        int targetRelationshipRelationship = this.random.nextInt(nbrOfRelationships);
        try (Transaction tx = this.db.beginTx();
             TokenScanWriter writer = this.relationshipTypeIndex.newWriter(PageCursorTracer.NULL);){
            for (int i = 0; i < nbrOfRelationships; ++i) {
                if (i == targetRelationshipRelationship) {
                    targetRelationshipAction.accept((Object)writer);
                    continue;
                }
                if (this.random.nextDouble() < recordFrequency) {
                    this.createCompleteEntry(writer, this.type);
                    continue;
                }
                this.notInUse(this.createStoreEntry(this.type));
            }
            tx.commit();
        }
        ConsistencyFlags flags = new ConsistencyFlags(true, true, true, true, true, true);
        this.check(this.context(flags));
        if (expectedCalls != null) {
            for (Consumer<ConsistencyReport.RelationshipTypeScanConsistencyReport> expectedCall : expectedCalls) {
                this.expect(ConsistencyReport.RelationshipTypeScanConsistencyReport.class, expectedCall);
            }
        } else {
            Mockito.verifyNoInteractions((Object[])new Object[]{this.monitor});
        }
    }

    private double densityAsFrequency(Density density) {
        double recordFrequency;
        switch (density) {
            case DENSE: {
                recordFrequency = 1.0;
                break;
            }
            case SPARSE: {
                recordFrequency = 0.0;
                break;
            }
            case RANDOM: {
                recordFrequency = this.random.nextDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't recognize density " + density);
            }
        }
        return recordFrequency;
    }

    private void createCompleteEntry(TokenScanWriter writer, int type) throws IOException {
        long relationshipId = this.createStoreEntry(type);
        this.createIndexEntry(writer, relationshipId, type);
    }

    private void createIndexEntry(TokenScanWriter writer, long relationshipId, int type) throws IOException {
        writer.write(EntityTokenUpdate.tokenChanges((long)relationshipId, (long[])new long[0], (long[])new long[]{type}));
    }

    private long createStoreEntry(int type) {
        long relationship = this.relationshipStore.nextId(PageCursorTracer.NULL);
        long node1 = this.nodePlusCached(this.nodeStore.nextId(PageCursorTracer.NULL), NULL, relationship, new int[0]);
        long node2 = this.nodePlusCached(this.nodeStore.nextId(PageCursorTracer.NULL), NULL, relationship, new int[0]);
        this.relationship(relationship, node1, node2, type, NULL, NULL, NULL, NULL, true, true);
        return relationship;
    }

    private void notInUse(long relationshipId) {
        RelationshipRecord relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        this.relationshipStore.getRecord(relationshipId, (AbstractBaseRecord)relationshipRecord, RecordLoad.NORMAL, PageCursorTracer.NULL);
        relationshipRecord.setInUse(false);
        this.relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord, PageCursorTracer.NULL);
    }

    private void check() throws Exception {
        this.check(this.context(ConsistencyFlags.DEFAULT.withCheckRelationshipTypeScanStore(true)));
    }

    private void check(CheckerContext context) throws Exception {
        new RelationshipChecker(context, this.noMandatoryProperties).check(LongRange.range((long)0L, (long)this.nodeStore.getHighId()), true, true);
    }

    private static enum Density {
        DENSE,
        SPARSE,
        RANDOM;

    }
}

