/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class FullCheckCountsStoreIT {
    @Inject
    private DatabaseManagementService dbms;
    @Inject
    private GraphDatabaseAPI db;

    @Test
    void shouldReportMissingCountsStore() throws Exception {
        this.shouldReportBadCountsStore((ThrowingFunction<Path, Boolean, IOException>)((ThrowingFunction)path -> {
            Files.delete(path);
            return true;
        }), DatabaseLayout::countStore, RecordType.COUNTS);
    }

    @Test
    void shouldReportBrokenCountsStore() throws Exception {
        this.shouldReportBadCountsStore((ThrowingFunction<Path, Boolean, IOException>)((ThrowingFunction)this::corruptFileIfExists), DatabaseLayout::countStore, RecordType.COUNTS);
    }

    @Test
    void shouldReportMissingGroupDegreesStore() throws Exception {
        this.shouldReportBadCountsStore((ThrowingFunction<Path, Boolean, IOException>)((ThrowingFunction)path -> {
            Files.delete(path);
            return true;
        }), DatabaseLayout::relationshipGroupDegreesStore, RecordType.RELATIONSHIP_GROUP);
    }

    @Test
    void shouldReportBrokenGroupDegreesStore() throws Exception {
        this.shouldReportBadCountsStore((ThrowingFunction<Path, Boolean, IOException>)((ThrowingFunction)this::corruptFileIfExists), DatabaseLayout::relationshipGroupDegreesStore, RecordType.RELATIONSHIP_GROUP);
    }

    private void shouldReportBadCountsStore(ThrowingFunction<Path, Boolean, IOException> fileAction, Function<DatabaseLayout, Path> store, RecordType recordType) throws Exception {
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        this.dbms.shutdown();
        boolean corrupted = (Boolean)fileAction.apply((Object)store.apply(databaseLayout));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)corrupted);
        ConsistencyCheckService.Result result = new ConsistencyCheckService().runFullConsistencyCheck(databaseLayout, Config.defaults((Setting)GraphDatabaseSettings.logs_directory, (Object)databaseLayout.databaseDirectory()), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.nullLogProvider(), false, ConsistencyFlags.DEFAULT);
        Assertions.assertThat((int)result.summary().getInconsistencyCountForRecordType(recordType)).isEqualTo(1);
    }

    private boolean corruptFileIfExists(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                ByteBuffer buffer = ByteBuffers.allocate((int)30, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
                while (buffer.hasRemaining()) {
                    buffer.put((byte)9);
                }
                buffer.flip();
                FileUtils.writeAll((FileChannel)channel, (ByteBuffer)buffer);
            }
            return true;
        }
        return false;
    }
}

