/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.CheckerTestBase;
import org.neo4j.consistency.checker.RelationshipChecker;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@ExtendWith(value={RandomExtension.class})
class RelationshipCheckerWithRelationshipTypeIndexTest
extends CheckerTestBase {
    private int type;
    private int lowerType;
    private int higherType;
    private IndexDescriptor rtiDescriptor;
    private IndexProxy rtiProxy;
    @Inject
    private RandomRule random;

    RelationshipCheckerWithRelationshipTypeIndexTest() {
    }

    @BeforeEach
    private void extractRelationshipTypeIndexProxy() {
        IndexingService indexingService = (IndexingService)this.db.getDependencyResolver().resolveDependency(IndexingService.class);
        IndexDescriptor[] indexDescriptors = this.schemaStorage.indexGetForSchema((SchemaDescriptorSupplier)SchemaDescriptor.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP), CursorContext.NULL);
        Assertions.assertThat((int)indexDescriptors.length).isEqualTo(1);
        this.rtiDescriptor = indexDescriptors[0];
        try {
            this.rtiProxy = indexingService.getIndexProxy(this.rtiDescriptor);
        }
        catch (IndexNotFoundKernelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        this.lowerType = tx.tokenWrite().relationshipTypeGetOrCreateForName("A");
        this.type = tx.tokenWrite().relationshipTypeGetOrCreateForName("B");
        this.higherType = tx.tokenWrite().relationshipTypeGetOrCreateForName("C");
        Assertions.assertThat((int)this.lowerType).isLessThan(this.type);
        Assertions.assertThat((int)this.type).isLessThan(this.higherType);
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void testShouldNotReportAnythingIfDataIsCorrect(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> this.createCompleteEntry((IndexUpdater)writer, this.type)), null);
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexPointToRelationshipNotInUse(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.notInUse(relationshipId);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.type);
        }), reporter -> reporter.relationshipNotInUse((RelationshipRecord)ArgumentMatchers.any()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasHigherTypeThanRelationshipInStore(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasLowerTypeThanRelationshipInStore(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.lowerType);
        }), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexIsMissingEntryForRelationshipInUse(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> this.createStoreEntry(this.type)), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasMultipleTypesForSameRelationshipOneCorrect(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.type);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.lowerType);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasMultipleTypesForSameRelationshipNoneCorrect(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.lowerType);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipTypeNotInIndex((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()), reporter -> reporter.relationshipDoesNotHaveExpectedRelationshipType((RelationshipRecord)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
    }

    @ParameterizedTest
    @EnumSource(value=Density.class)
    void indexHasMultipleTypesForSameRelationshipNotInUse(Density density) throws Exception {
        this.doVerifyCorrectReport(density, (ThrowingConsumer<IndexUpdater, IndexEntryConflictException>)((ThrowingConsumer)writer -> {
            long relationshipId = this.createStoreEntry(this.type);
            this.notInUse(relationshipId);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.type);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.lowerType);
            this.createIndexEntry((IndexUpdater)writer, relationshipId, this.higherType);
        }), reporter -> reporter.relationshipNotInUse((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void storeHasBigGapButIndexDoesNot() throws Exception {
        try (Transaction tx = this.db.beginTx();
             IndexUpdater writer = this.relationshipTypeIndexWriter();){
            for (int i = 0; i < 200; ++i) {
                long relationshipId;
                if (i == 0) {
                    this.createCompleteEntry(writer, this.type);
                    continue;
                }
                if (i == 10) {
                    relationshipId = this.createStoreEntry(this.type);
                    this.notInUse(relationshipId);
                    this.createIndexEntry(writer, relationshipId, this.type);
                    continue;
                }
                if (i == 99) {
                    this.createCompleteEntry(writer, this.type);
                    continue;
                }
                relationshipId = this.createStoreEntry(this.type);
                this.notInUse(relationshipId);
            }
            tx.commit();
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipTypeScanConsistencyReport.class, reporter -> reporter.relationshipNotInUse((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void checkShouldBeSuccessfulIfNoRelationshipTypeIndexExist() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            Iterable indexes = tx.schema().getIndexes();
            for (IndexDefinition index : indexes) {
                if (index.getIndexType() != IndexType.LOOKUP || !index.isRelationshipIndex()) continue;
                index.drop();
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            this.createStoreEntry(this.type);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.check();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.monitor});
    }

    @SafeVarargs
    private void doVerifyCorrectReport(Density density, ThrowingConsumer<IndexUpdater, IndexEntryConflictException> targetRelationshipAction, Consumer<ConsistencyReport.RelationshipTypeScanConsistencyReport> ... expectedCalls) throws Exception {
        double recordFrequency = this.densityAsFrequency(density);
        int nbrOfRelationships = this.random.nextInt(1, 200);
        int targetRelationshipRelationship = this.random.nextInt(nbrOfRelationships);
        try (Transaction tx = this.db.beginTx();
             IndexUpdater writer = this.relationshipTypeIndexWriter();){
            for (int i = 0; i < nbrOfRelationships; ++i) {
                if (i == targetRelationshipRelationship) {
                    targetRelationshipAction.accept((Object)writer);
                    continue;
                }
                if (this.random.nextDouble() < recordFrequency) {
                    this.createCompleteEntry(writer, this.type);
                    continue;
                }
                this.notInUse(this.createStoreEntry(this.type));
            }
            tx.commit();
        }
        ConsistencyFlags flags = new ConsistencyFlags(true, true, true);
        this.check(this.context(flags));
        if (expectedCalls != null) {
            for (Consumer<ConsistencyReport.RelationshipTypeScanConsistencyReport> expectedCall : expectedCalls) {
                this.expect(ConsistencyReport.RelationshipTypeScanConsistencyReport.class, expectedCall);
            }
        } else {
            Mockito.verifyNoInteractions((Object[])new Object[]{this.monitor});
        }
    }

    private double densityAsFrequency(Density density) {
        double recordFrequency;
        switch (density) {
            case DENSE: {
                recordFrequency = 1.0;
                break;
            }
            case SPARSE: {
                recordFrequency = 0.0;
                break;
            }
            case RANDOM: {
                recordFrequency = this.random.nextDouble();
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't recognize density " + density);
            }
        }
        return recordFrequency;
    }

    private void createCompleteEntry(IndexUpdater writer, int type) throws IndexEntryConflictException {
        long relationshipId = this.createStoreEntry(type);
        this.createIndexEntry(writer, relationshipId, type);
    }

    private void createIndexEntry(IndexUpdater writer, long relationshipId, int type) throws IndexEntryConflictException {
        writer.process((IndexEntryUpdate)TokenIndexEntryUpdate.change((long)relationshipId, (SchemaDescriptorSupplier)this.rtiDescriptor, (long[])new long[0], (long[])new long[]{type}));
    }

    private long createStoreEntry(int type) {
        long relationship = this.relationshipStore.nextId(CursorContext.NULL);
        long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
        long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, relationship, new int[0]);
        this.relationship(relationship, node1, node2, type, NULL, NULL, NULL, NULL, true, true);
        return relationship;
    }

    private void notInUse(long relationshipId) {
        RelationshipRecord relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        this.relationshipStore.getRecord(relationshipId, (AbstractBaseRecord)relationshipRecord, RecordLoad.NORMAL, CursorContext.NULL);
        relationshipRecord.setInUse(false);
        this.relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord, CursorContext.NULL);
    }

    private void check() throws Exception {
        this.check(this.context());
    }

    private void check(CheckerContext context) throws Exception {
        new RelationshipChecker(context, this.noMandatoryProperties).check(LongRange.range((long)0L, (long)this.nodeStore.getHighId()), true, true);
    }

    private IndexUpdater relationshipTypeIndexWriter() {
        return this.rtiProxy.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
    }

    private static enum Density {
        DENSE,
        SPARSE,
        RANDOM;

    }
}

