/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.GraphStoreFixture;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.mockito.mock.Property;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.time.Clocks;

@TestDirectoryExtension
@Neo4jLayoutExtension
public class ConsistencyCheckServiceIntegrationTest {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private GraphStoreFixture fixture;

    @BeforeEach
    void setUp() {
        this.fixture = new GraphStoreFixture(this.getRecordFormatName(), this.testDirectory){

            @Override
            protected void generateInitialData(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    Node node1 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[0]);
                    Node node2 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"exampleValue")});
                    node1.createRelationshipTo(node2, RelationshipType.withName((String)"C"));
                    tx.commit();
                }
            }

            @Override
            protected Map<Setting<?>, Object> getConfig() {
                return ConsistencyCheckServiceIntegrationTest.this.settings();
            }
        };
    }

    @AfterEach
    void tearDown() {
        this.fixture.close();
    }

    @Test
    void reportNotUsedRelationshipReferencedInChain() throws Exception {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.defaults(this.settings());
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful());
        Path reportFile = result.reportFile();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(reportFile, new LinkOption[0]), (String)"Consistency check report file should be generated.");
        ((AbstractStringAssert)Assertions.assertThat((String)Files.readString(reportFile)).as("Expected to see report about not deleted relationship record present as part of a chain", new Object[0])).contains(new CharSequence[]{"The relationship record is not in use, but referenced from relationships chain."});
    }

    @Test
    void tracePageCacheAccessOnConsistencyCheck() throws ConsistencyCheckIncompleteException {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        ConsistencyCheckService service = new ConsistencyCheckService(new Date());
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        this.fixture.close();
        JobScheduler jobScheduler = JobSchedulerFactory.createScheduler();
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(this.testDirectory.getFileSystem(), Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)"8m"), (PageCacheTracer)pageCacheTracer, (Log)NullLog.getInstance(), jobScheduler, Clocks.nanoClock(), new MemoryPools(false));
        try (Lifespan life = new Lifespan(new Lifecycle[]{jobScheduler});
             PageCache pageCache = pageCacheFactory.getOrCreatePageCache();){
            ConsistencyCheckService.Result result = service.runFullConsistencyCheck(this.fixture.databaseLayout(), Config.defaults(this.settings()), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), this.testDirectory.getFileSystem(), pageCache, false, ConsistencyFlags.DEFAULT, (PageCacheTracer)pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful());
            Assertions.assertThat((long)pageCacheTracer.pins()).isGreaterThanOrEqualTo(74L);
            Assertions.assertThat((long)pageCacheTracer.unpins()).isGreaterThanOrEqualTo(74L);
            Assertions.assertThat((long)pageCacheTracer.hits()).isGreaterThanOrEqualTo(35L);
            Assertions.assertThat((long)pageCacheTracer.faults()).isGreaterThanOrEqualTo(39L);
        }
    }

    @Test
    void shouldFailOnDatabaseInNeedOfRecovery() throws IOException {
        this.nonRecoveredDatabase();
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config defaults = Config.defaults(this.settings());
        ConsistencyCheckIncompleteException e = (ConsistencyCheckIncompleteException)org.junit.jupiter.api.Assertions.assertThrows(ConsistencyCheckIncompleteException.class, () -> this.runFullConsistencyCheck(service, defaults));
        org.junit.jupiter.api.Assertions.assertEquals((Object)e.getCause().getMessage(), (Object)Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Please recover database.", "To perform recovery please start database in single mode and perform clean shutdown."}));
    }

    @Test
    void ableToDeleteDatabaseDirectoryAfterConsistencyCheckRun() throws ConsistencyCheckIncompleteException, IOException {
        this.prepareDbWithDeletedRelationshipPartOfTheChain();
        ConsistencyCheckService service = new ConsistencyCheckService();
        ConsistencyCheckService.Result consistencyCheck = this.runFullConsistencyCheck(service, Config.defaults(this.settings()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)consistencyCheck.isSuccessful());
        org.apache.commons.io.FileUtils.deleteDirectory((File)this.fixture.databaseLayout().databaseDirectory().toFile());
    }

    @Test
    void shouldSucceedIfStoreIsConsistent() throws Exception {
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Config configuration = Config.defaults(this.settings());
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
        Path reportFile = result.reportFile();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)Files.exists(reportFile, new LinkOption[0]), (String)("Unexpected generation of consistency check report file: " + reportFile));
    }

    @Test
    void shouldFailIfTheStoreInNotConsistent() throws Exception {
        this.breakNodeStore();
        Date timestamp = new Date();
        ConsistencyCheckService service = new ConsistencyCheckService(timestamp);
        Path logsDir = this.testDirectory.homePath();
        Config configuration = Config.newBuilder().set(this.settings()).set(GraphDatabaseSettings.logs_directory, (Object)logsDir).build();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isSuccessful());
        String reportFile = String.format("inconsistencies-%s.report", new SimpleDateFormat("yyyy-MM-dd.HH.mm.ss").format(timestamp));
        org.junit.jupiter.api.Assertions.assertEquals((Object)logsDir.resolve(reportFile), (Object)result.reportFile());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(result.reportFile(), new LinkOption[0]), (String)"Inconsistency report file not generated");
    }

    @Test
    void shouldNotReportDuplicateForHugeLongValues() throws Exception {
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings());
        String propertyKey = "itemId";
        Label label = Label.label((String)"Item");
        this.fixture.apply(tx -> tx.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create());
        this.fixture.apply(tx -> {
            Property.set((Entity)tx.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596880L)});
            Property.set((Entity)tx.createNode(new Label[]{label}), (Property[])new Property[]{Property.property((String)propertyKey, (Object)973305894188596864L)});
        });
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    void shouldReportMissingSchemaIndex() throws Exception {
        Label label = Label.label((String)"label");
        String propKey = "propKey";
        this.createIndex(label, propKey);
        this.fixture.close();
        Path schemaDir = ConsistencyCheckServiceIntegrationTest.findFile(this.databaseLayout, "schema");
        FileUtils.deleteDirectory((Path)schemaDir);
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.defaults(this.settings());
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration, this.databaseLayout);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
        Path reportFile = result.reportFile();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(reportFile, new LinkOption[0]), (String)"Consistency check report file should be generated.");
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)Files.readString(reportFile)).as("Expected to see report about schema index not being online", new Object[0])).contains(new CharSequence[]{"schema rule"})).contains(new CharSequence[]{"not online"});
    }

    @Test
    void oldLuceneSchemaIndexShouldBeConsideredConsistentWithFusionProvider() throws Exception {
        Label label = Label.label((String)"label");
        String propKey = "propKey";
        this.createIndex(label, propKey);
        this.fixture.apply(tx -> {
            tx.createNode(new Label[]{label}).setProperty(propKey, (Object)1);
            tx.createNode(new Label[]{label}).setProperty(propKey, (Object)"string");
        });
        ConsistencyCheckService service = new ConsistencyCheckService();
        Config configuration = Config.newBuilder().set(this.settings()).set(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName()).build();
        ConsistencyCheckService.Result result = this.runFullConsistencyCheck(service, configuration, this.databaseLayout);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isSuccessful());
    }

    private void createIndex(Label label, String propKey) {
        this.fixture.apply(tx -> tx.schema().indexFor(label).on(propKey).create());
        this.fixture.apply(tx -> tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES));
    }

    private static Path findFile(DatabaseLayout databaseLayout, String targetFile) {
        Path file = databaseLayout.file(targetFile);
        if (Files.notExists(file, new LinkOption[0])) {
            org.junit.jupiter.api.Assertions.fail((String)("Could not find file " + targetFile));
        }
        return file;
    }

    private void prepareDbWithDeletedRelationshipPartOfTheChain() {
        RelationshipType relationshipType = RelationshipType.withName((String)"testRelationshipType");
        this.fixture.apply(tx -> {
            Node node1 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[0]);
            Node node2 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
            node1.createRelationshipTo(node2, relationshipType);
            node1.createRelationshipTo(node2, relationshipType);
            node1.createRelationshipTo(node2, relationshipType);
            node1.createRelationshipTo(node2, relationshipType);
            node1.createRelationshipTo(node2, relationshipType);
            node1.createRelationshipTo(node2, relationshipType);
        });
        NeoStores neoStores = this.fixture.neoStores();
        RelationshipStore relationshipStore = neoStores.getRelationshipStore();
        RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
        RelationshipRecord record = (RelationshipRecord)relationshipStore.getRecord(4L, (AbstractBaseRecord)relationshipRecord, RecordLoad.FORCE, CursorContext.NULL);
        record.setInUse(false);
        relationshipStore.updateRecord((AbstractBaseRecord)relationshipRecord, CursorContext.NULL);
    }

    private void nonRecoveredDatabase() throws IOException {
        Path[] txLogs;
        Path tmpLogDir = this.testDirectory.homePath().resolve("logs");
        this.fs.mkdir(tmpLogDir);
        RelationshipType relationshipType = RelationshipType.withName((String)"testRelationshipType");
        this.fixture.apply(tx -> {
            Node node1 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[0]);
            Node node2 = (Node)Property.set((Entity)tx.createNode(), (Property[])new Property[]{Property.property((String)"key", (Object)"value")});
            node1.createRelationshipTo(node2, relationshipType);
        });
        for (Path file : txLogs = this.fs.listFiles(LogFilesBuilder.logFilesBasedOnlyBuilder((Path)this.databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fs).withCommandReaderFactory((CommandReaderFactory)RecordStorageCommandReaderFactory.INSTANCE).build().logFilesDirectory())) {
            this.fs.copyToDirectory(file, tmpLogDir);
        }
        this.fixture.close();
        for (Path txLog : txLogs) {
            this.fs.deleteFile(txLog);
        }
        for (Path file : LogFilesBuilder.logFilesBasedOnlyBuilder((Path)tmpLogDir, (FileSystemAbstraction)this.fs).build().logFiles()) {
            this.fs.moveToDirectory(file, this.databaseLayout.getTransactionLogsDirectory());
        }
    }

    protected Map<Setting<?>, Object> settings() {
        HashMap defaults = new HashMap();
        defaults.put(GraphDatabaseSettings.pagecache_memory, "8m");
        defaults.put(GraphDatabaseSettings.logs_directory, this.databaseLayout.databaseDirectory());
        defaults.put(GraphDatabaseSettings.record_format, this.getRecordFormatName());
        return defaults;
    }

    private void breakNodeStore() throws KernelException {
        this.fixture.apply(new GraphStoreFixture.Transaction(){

            @Override
            protected void transactionData(GraphStoreFixture.TransactionDataBuilder tx, GraphStoreFixture.IdGenerator next) {
                tx.create(new NodeRecord(next.node()).initialize(false, -1L, false, next.relationship(), 0L));
            }
        });
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration) throws ConsistencyCheckIncompleteException {
        return this.runFullConsistencyCheck(service, configuration, this.fixture.databaseLayout());
    }

    private ConsistencyCheckService.Result runFullConsistencyCheck(ConsistencyCheckService service, Config configuration, DatabaseLayout databaseLayout) throws ConsistencyCheckIncompleteException {
        this.fixture.close();
        return service.runFullConsistencyCheck(databaseLayout, configuration, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
    }

    protected String getRecordFormatName() {
        return "";
    }
}

