/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.CountsState;
import org.neo4j.consistency.checker.DebugContext;
import org.neo4j.consistency.checker.NodeBasedMemoryLimiter;
import org.neo4j.consistency.checker.NodeChecker;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;

@ExtendWith(value={SoftAssertionsExtension.class})
@DbmsExtension
class NodeCheckerIT {
    private static final String INDEX_NAME = "index";
    private final ParallelExecution execution = new ParallelExecution(10, ParallelExecution.NOOP_EXCEPTION_HANDLER, 100);
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private IndexProviderMap providerMap;
    @Inject
    private Config config;
    @Inject
    private PageCache pageCache;
    @Inject
    private TokenHolders tokenHolders;
    private long nodeId;
    private CheckerContext context;
    private DefaultPageCacheTracer pageCacheTracer;
    @InjectSoftAssertions
    private SoftAssertions softly;

    NodeCheckerIT() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.pageCacheTracer = new DefaultPageCacheTracer();
        Label label = Label.label((String)"any");
        String propertyName = "property";
        try (Transaction tx = this.database.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(propertyName, (Object)"nodeValue");
            this.nodeId = node.getId();
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().indexFor(label).on(propertyName).withName(INDEX_NAME).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(10L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.prepareContext();
    }

    @Test
    void tracePageCacheAccessOnNodeCheck() throws Exception {
        this.prepareContext();
        NodeChecker nodeChecker = new NodeChecker(this.context, (MutableIntObjectMap)new IntObjectHashMap());
        nodeChecker.check(LongRange.range((long)0L, (long)(this.nodeId + 1L)), true, false);
        long pins = this.pageCacheTracer.pins();
        this.softly.assertThat(pins).isGreaterThan(0L);
        this.softly.assertThat(this.pageCacheTracer.unpins()).isEqualTo(pins);
        ((LongAssert)this.softly.assertThat(this.pageCacheTracer.hits()).isGreaterThan(0L)).isLessThanOrEqualTo(pins);
    }

    private void prepareContext() throws Exception {
        NeoStores neoStores = this.storageEngine.testAccessNeoStores();
        IndexAccessors indexAccessors = new IndexAccessors(this.providerMap, neoStores, new IndexSamplingConfig(this.config), PageCacheTracer.NULL, SchemaTestUtil.SIMPLE_NAME_LOOKUP, () -> KernelVersion.LATEST);
        this.context = new CheckerContext(neoStores, indexAccessors, this.execution, (ConsistencyReport.Reporter)Mockito.mock(ConsistencyReport.Reporter.class, (Answer)Mockito.RETURNS_MOCKS), CacheAccess.EMPTY, this.tokenHolders, (RecordLoading)Mockito.mock(RecordLoading.class), (CountsState)Mockito.mock(CountsState.class), (NodeBasedMemoryLimiter)Mockito.mock(NodeBasedMemoryLimiter.class), ProgressMonitorFactory.NONE.multipleParts("test"), this.pageCache, (PageCacheTracer)this.pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE, DebugContext.NO_DEBUG, ConsistencyFlags.DEFAULT);
        this.context.initialize();
    }
}

