/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.neo4j.consistency.checker.CheckerTestBase;
import org.neo4j.consistency.checker.RelationshipChainChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RelationshipChainCheckerTest
extends CheckerTestBase {
    private static final MyRelTypes TYPE = MyRelTypes.TEST;
    private long nodeId1;
    private long nodeId2;
    private long nodeId3;

    RelationshipChainCheckerTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        this.nodeId1 = tx.dataWrite().nodeCreate();
        this.nodeId2 = tx.dataWrite().nodeCreate();
        this.nodeId3 = tx.dataWrite().nodeCreate();
    }

    int numberOfThreads() {
        return 4;
    }

    @Test
    void shouldReportSourcePrevDoesNotReferenceBack() throws Exception {
        this.testRelationshipChainInconsistency((relationship1, relationship2) -> relationship1.setFirstNextRel(NULL), report -> report.sourcePrevDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportSourceNextDoesNotReferenceBack() throws Exception {
        this.testRelationshipChainInconsistency((relationship1, relationship2) -> relationship2.setFirstPrevRel(NULL), report -> report.sourceNextDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportTargetPrevDoesNotReferenceBack() throws Exception {
        this.testRelationshipChainInconsistency((relationship1, relationship2) -> relationship1.setSecondNextRel(NULL), report -> report.targetPrevDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportTargetNextDoesNotReferenceBack() throws Exception {
        this.testRelationshipChainInconsistency((relationship1, relationship2) -> relationship2.setSecondPrevRel(NULL), report -> report.targetNextDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportSourceNextPrevDoesNotReferenceBack() throws Exception {
        this.testRelationshipChainInconsistency((relationship1, relationship2) -> relationship1.setFirstNode(this.nodeId3), report -> {
            report.sourceNextDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
            report.sourcePrevDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
        });
    }

    @Test
    void shouldReportReferencesOtherNodesForward() throws Exception {
        this.shouldReportReferencesOtherNodes(true, relationship -> {
            MutableLongSet set = LongSets.mutable.of(new long[]{this.nodeId1, this.nodeId2, this.nodeId3});
            set.remove(relationship.getFirstNode());
            set.remove(relationship.getSecondNode());
            relationship.setFirstNode(set.longIterator().next());
        }, report -> {
            report.sourceNextDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
            report.sourceNextReferencesOtherNodes((RelationshipRecord)ArgumentMatchers.any());
            report.sourcePrevReferencesOtherNodes((RelationshipRecord)ArgumentMatchers.any());
            report.targetPrevReferencesOtherNodes((RelationshipRecord)ArgumentMatchers.any());
        });
    }

    @Test
    void shouldReportReferencesOtherNodesBackward() throws Exception {
        this.shouldReportReferencesOtherNodes(false, relationship -> {
            MutableLongSet set = LongSets.mutable.of(new long[]{this.nodeId1, this.nodeId2, this.nodeId3});
            set.remove(relationship.getFirstNode());
            set.remove(relationship.getSecondNode());
            relationship.setSecondNode(set.longIterator().next());
        }, report -> {
            report.targetNextDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
            report.targetNextReferencesOtherNodes((RelationshipRecord)ArgumentMatchers.any());
            report.targetPrevReferencesOtherNodes((RelationshipRecord)ArgumentMatchers.any());
            report.sourcePrevReferencesOtherNodes((RelationshipRecord)ArgumentMatchers.any());
        });
    }

    @Test
    void shouldReportNotUsedFirstRelationshipReferencedInChainForSingleRelationshipChain() throws Exception {
        this.testRelationshipChainInconsistency((relationship1, relationship2) -> relationship1.setInUse(false), report -> {
            report.sourcePrevDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
            report.targetPrevDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
        });
    }

    @Test
    void shouldReportNotUsedSecondRelationshipReferencedInChainForSingleRelationshipChain() throws Exception {
        this.testRelationshipChainInconsistency((relationship1, relationship2) -> relationship2.setInUse(false), report -> {
            report.sourceNextDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
            report.targetNextDoesNotReferenceBack((RelationshipRecord)ArgumentMatchers.any());
        });
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldReportNotUsedSecondRelationshipReferencedInChain(boolean forward) throws Exception {
        this.shouldReportReferencesOtherNodes(forward, relationship -> relationship.setInUse(false), report -> report.notUsedRelationshipReferencedInChain((RelationshipRecord)ArgumentMatchers.any()));
    }

    private void shouldReportReferencesOtherNodes(boolean forward, Consumer<RelationshipRecord> vandal, Consumer<ConsistencyReport.RelationshipConsistencyReport> expectedReport) throws Exception {
        long[] relationshipIds = new long[20];
        try (Transaction tx = this.db.beginTx();){
            Node[] nodes = new Node[]{tx.getNodeById(this.nodeId1), tx.getNodeById(this.nodeId2), tx.getNodeById(this.nodeId3)};
            for (int i = 0; i < relationshipIds.length; ++i) {
                Node node1 = nodes[i % nodes.length];
                Node node2 = nodes[(i + 1) % nodes.length];
                Node startNode = forward ? node1 : node2;
                Node endNode = forward ? node2 : node1;
                Relationship relationship = endNode.createRelationshipTo(startNode, (RelationshipType)TYPE);
                relationshipIds[i] = relationship.getId();
            }
            tx.commit();
        }
        RelationshipStore relationshipStore = this.context((int)this.numberOfThreads()).neoStores.getRelationshipStore();
        RelationshipRecord arbitraryRelationship = (RelationshipRecord)relationshipStore.getRecord(relationshipIds[relationshipIds.length / 2], (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        vandal.accept(arbitraryRelationship);
        relationshipStore.updateRecord((AbstractBaseRecord)arbitraryRelationship, CursorContext.NULL);
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, expectedReport);
    }

    void testRelationshipChainInconsistency(BiConsumer<RelationshipRecord, RelationshipRecord> vandal, Consumer<ConsistencyReport.RelationshipConsistencyReport> report) throws Exception {
        long secondRelationshipId;
        long firstRelationshipId;
        try (Object tx = this.db.beginTx();){
            Node node1 = tx.getNodeById(this.nodeId1);
            Node node2 = tx.getNodeById(this.nodeId2);
            Relationship relationship1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship relationship2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            firstRelationshipId = relationship2.getId();
            secondRelationshipId = relationship1.getId();
            tx.commit();
        }
        tx = this.tx();
        try {
            RelationshipRecord first = (RelationshipRecord)this.relationshipStore.getRecord(firstRelationshipId, (AbstractBaseRecord)((RelationshipRecord)this.relationshipStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
            RelationshipRecord second = (RelationshipRecord)this.relationshipStore.getRecord(secondRelationshipId, (AbstractBaseRecord)((RelationshipRecord)this.relationshipStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
            vandal.accept(first, second);
            this.relationshipStore.updateRecord((AbstractBaseRecord)first, CursorContext.NULL);
            this.relationshipStore.updateRecord((AbstractBaseRecord)second, CursorContext.NULL);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipConsistencyReport.class, report);
    }

    private void check() throws Exception {
        new RelationshipChainChecker(this.context(this.numberOfThreads())).check(LongRange.range((long)0L, (long)this.nodeStore.getHighId()), true, true);
    }
}

