/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.neo4j.consistency.checker.CheckerTestBase;
import org.neo4j.consistency.checker.RelationshipGroupChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;

class RelationshipGroupCheckerTest
extends CheckerTestBase {
    private int type1;
    private int type2;
    private int type3;

    RelationshipGroupCheckerTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        this.type1 = tx.tokenWrite().relationshipTypeGetOrCreateForName("A");
        this.type2 = tx.tokenWrite().relationshipTypeGetOrCreateForName("B");
        this.type3 = tx.tokenWrite().relationshipTypeGetOrCreateForName("C");
    }

    @Test
    void shouldReportRelationshipTypeNotInUse() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, 999, NULL, NULL, NULL), report -> report.relationshipTypeNotInUse((RelationshipTypeTokenRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextGroupNotInUse() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), this.relationshipGroupStore.nextId(CursorContext.NULL), owner, this.type1, NULL, NULL, NULL), ConsistencyReport.RelationshipGroupConsistencyReport::nextGroupNotInUse);
    }

    @Test
    void shouldReportInvalidTypeSortOrder() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> {
            long group1 = this.relationshipGroupStore.nextId(CursorContext.NULL);
            long group2 = this.relationshipGroupStore.nextId(CursorContext.NULL);
            long group3 = this.relationshipGroupStore.nextId(CursorContext.NULL);
            this.relationshipGroup(group1, group2, owner, this.type2, NULL, NULL, NULL);
            this.relationshipGroup(group2, group3, owner, this.type3, NULL, NULL, NULL);
            this.relationshipGroup(group3, NULL, owner, this.type1, NULL, NULL, NULL);
        }, ConsistencyReport.RelationshipGroupConsistencyReport::invalidTypeSortOrder);
    }

    @Test
    void shouldReportFirstOutgoingRelationshipNotInUse() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, this.relationshipStore.nextId(CursorContext.NULL), NULL, NULL), ConsistencyReport.RelationshipGroupConsistencyReport::firstOutgoingRelationshipNotInUse);
    }

    @Test
    void shouldReportFirstIncomingRelationshipNotInUse() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, NULL, this.relationshipStore.nextId(CursorContext.NULL), NULL), ConsistencyReport.RelationshipGroupConsistencyReport::firstIncomingRelationshipNotInUse);
    }

    @Test
    void shouldReportFirstLoopRelationshipNotInUse() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, NULL, NULL, this.relationshipStore.nextId(CursorContext.NULL)), ConsistencyReport.RelationshipGroupConsistencyReport::firstLoopRelationshipNotInUse);
    }

    @Test
    void shouldReportFirstOutgoingRelationshipNotFirstInChain() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> {
            long otherNode = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long relationship = this.relationship(this.relationshipStore.nextId(CursorContext.NULL), owner, otherNode, this.type1, NULL, NULL, NULL, NULL, false, true);
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, relationship, NULL, NULL);
        }, ConsistencyReport.RelationshipGroupConsistencyReport::firstOutgoingRelationshipNotFirstInChain);
    }

    @Test
    void shouldReportFirstIncomingRelationshipNotFirstInChain() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> {
            long otherNode = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long relationship = this.relationship(this.relationshipStore.nextId(CursorContext.NULL), owner, otherNode, this.type1, NULL, NULL, NULL, NULL, true, false);
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, NULL, relationship, NULL);
        }, ConsistencyReport.RelationshipGroupConsistencyReport::firstIncomingRelationshipNotFirstInChain);
    }

    @Test
    void shouldReportFirstLoopRelationshipNotFirstInChain() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> {
            long otherNode = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long relationship = this.relationship(this.relationshipStore.nextId(CursorContext.NULL), owner, otherNode, this.type1, NULL, NULL, NULL, NULL, false, false);
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, NULL, NULL, relationship);
        }, ConsistencyReport.RelationshipGroupConsistencyReport::firstLoopRelationshipNotFirstInChain);
    }

    @Test
    void shouldReportFirstOutgoingRelationshipOfOfOtherType() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> {
            long otherNode = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long relationship = this.relationship(this.relationshipStore.nextId(CursorContext.NULL), owner, otherNode, this.type2, NULL, NULL, NULL, NULL, true, true);
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, relationship, NULL, NULL);
        }, ConsistencyReport.RelationshipGroupConsistencyReport::firstOutgoingRelationshipOfOtherType);
    }

    @Test
    void shouldReportFirstIncomingRelationshipOfOfOtherType() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> {
            long otherNode = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long relationship = this.relationship(this.relationshipStore.nextId(CursorContext.NULL), owner, otherNode, this.type2, NULL, NULL, NULL, NULL, true, true);
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, NULL, relationship, NULL);
        }, ConsistencyReport.RelationshipGroupConsistencyReport::firstIncomingRelationshipOfOtherType);
    }

    @Test
    void shouldReportFirstLoopRelationshipOfOfOtherType() throws Exception {
        this.testRelationshipGroupInconsistency(owner -> {
            long otherNode = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long relationship = this.relationship(this.relationshipStore.nextId(CursorContext.NULL), owner, otherNode, this.type2, NULL, NULL, NULL, NULL, true, true);
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, owner, this.type1, NULL, NULL, relationship);
        }, ConsistencyReport.RelationshipGroupConsistencyReport::firstLoopRelationshipOfOtherType);
    }

    @Test
    void shouldReportOwnerNotInUse() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, this.nodeStore.nextId(CursorContext.NULL), this.type1, NULL, NULL, NULL);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipGroupConsistencyReport.class, ConsistencyReport.RelationshipGroupConsistencyReport::ownerNotInUse);
    }

    @Test
    void shouldReportIllegalOwner() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            this.relationshipGroup(this.relationshipGroupStore.nextId(CursorContext.NULL), NULL, -1L, this.type1, NULL, NULL, NULL);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipGroupConsistencyReport.class, ConsistencyReport.RelationshipGroupConsistencyReport::illegalOwner);
    }

    @Test
    void shouldReportNextHasOtherOwner() throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long node1 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long node2 = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            long group1 = this.relationshipGroupStore.nextId(CursorContext.NULL);
            long group2 = this.relationshipGroupStore.nextId(CursorContext.NULL);
            this.relationshipGroup(group1, group2, node1, this.type1, NULL, NULL, NULL);
            this.relationshipGroup(group2, NULL, node2, this.type2, NULL, NULL, NULL);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipGroupConsistencyReport.class, report -> report.nextHasOtherOwner((RelationshipGroupRecord)ArgumentMatchers.any()));
    }

    private void testRelationshipGroupInconsistency(LongConsumer groupCreator, Consumer<ConsistencyReport.RelationshipGroupConsistencyReport> report) throws Exception {
        try (AutoCloseable ignored = this.tx();){
            long owner = this.nodePlusCached(this.nodeStore.nextId(CursorContext.NULL), NULL, NULL, new int[0]);
            groupCreator.accept(owner);
        }
        this.check();
        this.expect(ConsistencyReport.RelationshipGroupConsistencyReport.class, report);
    }

    private void check() throws Exception {
        new RelationshipGroupChecker(this.context()).check(LongRange.range((long)0L, (long)this.nodeStore.getHighId()), true, true);
    }
}

