/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.consistency.checker.CheckerTestBase;
import org.neo4j.consistency.checker.SafePropertyChainReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SafePropertyChainReaderTest
extends CheckerTestBase {
    private int propertyKey1;
    private int propertyKey2;
    private int propertyKey3;

    SafePropertyChainReaderTest() {
    }

    @Override
    void initialData(KernelTransaction tx) throws KernelException {
        TokenWrite tokenWrite = tx.tokenWrite();
        this.propertyKey1 = tokenWrite.propertyKeyGetOrCreateForName("1");
        this.propertyKey2 = tokenWrite.propertyKeyGetOrCreateForName("2");
        this.propertyKey3 = tokenWrite.propertyKeyGetOrCreateForName("3");
    }

    @Test
    void shouldReportCircularPropertyRecordChain() throws Exception {
        long nodeId2;
        long nodeId1;
        try (AutoCloseable ignored = this.tx();){
            long firstPropId = this.propertyStore.nextId(CursorContext.NULL);
            long secondPropId = this.propertyStore.nextId(CursorContext.NULL);
            nodeId1 = this.node(this.nodeStore.nextId(CursorContext.NULL), firstPropId, NULL, new int[0]);
            this.property(firstPropId, NULL, secondPropId, this.propertyValue(this.propertyKey1, (Value)Values.intValue((int)1)));
            this.property(secondPropId, firstPropId, firstPropId, this.propertyValue(this.propertyKey2, (Value)Values.intValue((int)1)));
            nodeId2 = this.nodeStore.nextId(CursorContext.NULL);
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            this.node(nodeId2, propId, NULL, new int[0]);
            this.property(propId, NULL, propId, this.propertyValue(this.propertyKey1, (Value)Values.intValue((int)1)));
        }
        this.checkNode(nodeId1);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.propertyChainContainsCircularReference((PropertyRecord)ArgumentMatchers.any()));
        Mockito.reset((Object[])new ConsistencyReporter.Monitor[]{this.monitor});
        this.checkNode(nodeId2);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.propertyChainContainsCircularReference((PropertyRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextPropertyRecordNotInUse() throws Exception {
        long nodeId2;
        long nodeId1;
        try (AutoCloseable ignored = this.tx();){
            nodeId1 = this.node(this.nodeStore.nextId(CursorContext.NULL), this.propertyStore.nextId(CursorContext.NULL), NULL, new int[0]);
            long propId1 = this.propertyStore.nextId(CursorContext.NULL);
            long propId2 = this.propertyStore.nextId(CursorContext.NULL);
            nodeId2 = this.node(this.nodeStore.nextId(CursorContext.NULL), propId1, NULL, new int[0]);
            this.property(propId1, NULL, propId2, this.propertyValue(this.propertyKey1, (Value)Values.longValue((long)10L)));
        }
        this.checkNode(nodeId1);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.propertyNotInUse((PropertyRecord)ArgumentMatchers.any()));
        this.expect(ConsistencyReport.PropertyConsistencyReport.class, report -> report.nextNotInUse((PropertyRecord)ArgumentMatchers.any()));
        Mockito.reset((Object[])new ConsistencyReporter.Monitor[]{this.monitor});
        this.checkNode(nodeId2);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.propertyNotInUse((PropertyRecord)ArgumentMatchers.any()));
        this.expect(ConsistencyReport.PropertyConsistencyReport.class, report -> report.nextNotInUse((PropertyRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportPropertyNotFirstInChain() throws Exception {
        long nodeId;
        try (AutoCloseable ignored = this.tx();){
            long prop0Id = this.propertyStore.nextId(CursorContext.NULL);
            long prop1Id = this.propertyStore.nextId(CursorContext.NULL);
            long prop2Id = this.propertyStore.nextId(CursorContext.NULL);
            nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), prop1Id, NULL, new int[0]);
            this.property(prop0Id, NULL, prop1Id, this.propertyValue(this.propertyKey1, (Value)Values.stringValue((String)"a")));
            this.property(prop1Id, prop0Id, prop2Id, this.propertyValue(this.propertyKey2, (Value)Values.stringValue((String)"b")));
            this.property(prop2Id, prop1Id, NULL, this.propertyValue(this.propertyKey3, (Value)Values.stringValue((String)"c")));
        }
        this.checkNode(nodeId);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, report -> report.propertyNotFirstInChain((PropertyRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextDoesNotReferenceBack() throws Exception {
        long nodeId;
        try (AutoCloseable ignored = this.tx();){
            long prop1Id = this.propertyStore.nextId(CursorContext.NULL);
            long prop2Id = this.propertyStore.nextId(CursorContext.NULL);
            long prop3Id = this.propertyStore.nextId(CursorContext.NULL);
            nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), prop1Id, NULL, new int[0]);
            this.property(prop1Id, NULL, prop2Id, this.propertyValue(this.propertyKey1, (Value)Values.stringValue((String)"a")));
            this.property(prop2Id, prop3Id, NULL, this.propertyValue(this.propertyKey2, (Value)Values.stringValue((String)"b")));
            this.property(prop3Id, NULL, NULL, this.propertyValue(this.propertyKey3, (Value)Values.stringValue((String)"c")));
        }
        this.checkNode(nodeId);
        this.expect(ConsistencyReport.PropertyConsistencyReport.class, report -> report.nextDoesNotReferenceBack((PropertyRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportKeyNotInUse() throws Exception {
        long nodeId;
        try (AutoCloseable ignored = this.tx();){
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, new int[0]);
            this.property(propId, NULL, NULL, this.propertyValue(99, (Value)Values.intValue((int)1)));
        }
        this.checkNode(nodeId);
        this.expect(ConsistencyReport.PropertyConsistencyReport.class, report -> report.keyNotInUse((PropertyBlock)ArgumentMatchers.any(), (PropertyKeyTokenRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportStringRecordNotInUse() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.stringValueOfLength(60), block -> ((DynamicRecord)Iterables.single((Iterable)block.getValueRecords())).setInUse(false), ConsistencyReport.PropertyConsistencyReport.class, report -> report.stringNotInUse((PropertyBlock)ArgumentMatchers.any(), (DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextStringRecordNotInUse() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.stringValueOfLength(160), block -> ((DynamicRecord)block.getValueRecords().get(1)).setInUse(false), ConsistencyReport.DynamicConsistencyReport.class, report -> report.nextNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicStringEmpty() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.stringValueOfLength(60), block -> ((DynamicRecord)Iterables.single((Iterable)block.getValueRecords())).setData(new byte[0]), ConsistencyReport.PropertyConsistencyReport.class, report -> report.stringEmpty((PropertyBlock)ArgumentMatchers.any(), (DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicStringRecordNotFullReferencesNext() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.stringValueOfLength(160), block -> {
            byte[] data = ((DynamicRecord)block.getValueRecords().get(0)).getData();
            ((DynamicRecord)block.getValueRecords().get(0)).setData(Arrays.copyOf(data, data.length / 2));
        }, ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::recordNotFullReferencesNext);
    }

    @Test
    void shouldReportArrayRecordNotInUse() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.intArrayValueOfLength(30), block -> ((DynamicRecord)Iterables.single((Iterable)block.getValueRecords())).setInUse(false), ConsistencyReport.PropertyConsistencyReport.class, report -> report.arrayNotInUse((PropertyBlock)ArgumentMatchers.any(), (DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportNextArrayRecordNotInUse() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.intArrayValueOfLength(80), block -> ((DynamicRecord)block.getValueRecords().get(1)).setInUse(false), ConsistencyReport.DynamicConsistencyReport.class, report -> report.nextNotInUse((DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicArrayEmpty() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.intArrayValueOfLength(30), block -> ((DynamicRecord)Iterables.single((Iterable)block.getValueRecords())).setData(new byte[0]), ConsistencyReport.PropertyConsistencyReport.class, report -> report.arrayEmpty((PropertyBlock)ArgumentMatchers.any(), (DynamicRecord)ArgumentMatchers.any()));
    }

    @Test
    void shouldReportDynamicArrayRecordNotFullReferencesNext() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.intArrayValueOfLength(80), block -> {
            byte[] data = ((DynamicRecord)block.getValueRecords().get(0)).getData();
            ((DynamicRecord)block.getValueRecords().get(0)).setData(Arrays.copyOf(data, data.length / 2));
        }, ConsistencyReport.DynamicConsistencyReport.class, ConsistencyReport.DynamicConsistencyReport::recordNotFullReferencesNext);
    }

    @Test
    void shouldReportInvalidPropertyValue() throws Exception {
        this.testPropertyValueInconsistency((Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.34, 56.78}), block -> {
            long[] lArray = block.getValueBlocks();
            lArray[0] = lArray[0] | 0x100000000000000L;
        }, ConsistencyReport.PropertyConsistencyReport.class, report -> report.invalidPropertyValue(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt()));
    }

    @Test
    void shouldReportInvalidPropertyValueForDynamicArrayValue() throws Exception {
        this.testPropertyValueInconsistency(SafePropertyChainReaderTest.stringArrayValueOfLength(20, 50), block -> {
            Assertions.assertTrue((block.getValueRecords().size() > 2 ? 1 : 0) != 0);
            ((DynamicRecord)block.getValueRecords().get(1)).setNextBlock(NULL);
        }, ConsistencyReport.PropertyConsistencyReport.class, report -> report.invalidPropertyValue(ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt()));
    }

    private <T extends ConsistencyReport> void testPropertyValueInconsistency(Value consistentValue, Consumer<PropertyBlock> vandal, Class<T> expectedReportClass, Consumer<T> report) throws Exception {
        long nodeId;
        try (AutoCloseable ignored = this.tx();){
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            nodeId = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, new int[0]);
            PropertyBlock dynamicBlock = this.propertyValue(this.propertyKey1, consistentValue);
            this.property(propId, NULL, NULL, dynamicBlock);
            vandal.accept(dynamicBlock);
            this.property(propId, NULL, NULL, dynamicBlock);
        }
        this.checkNode(nodeId);
        this.expect(expectedReportClass, report);
    }

    @Test
    void shouldReportPropertyKeyNotUniqueInChain() throws Exception {
        long nodeId2;
        long nodeId1;
        try (AutoCloseable ignored = this.tx();){
            long propId = this.propertyStore.nextId(CursorContext.NULL);
            this.property(propId, NULL, NULL, this.propertyValue(this.propertyKey1, (Value)Values.intValue((int)1)), this.propertyValue(this.propertyKey1, (Value)Values.intValue((int)2)));
            nodeId1 = this.node(this.nodeStore.nextId(CursorContext.NULL), propId, NULL, new int[0]);
            long propId1 = this.propertyStore.nextId(CursorContext.NULL);
            long propId2 = this.propertyStore.nextId(CursorContext.NULL);
            this.property(propId1, NULL, propId2, this.propertyValue(this.propertyKey1, (Value)Values.intValue((int)1)));
            this.property(propId2, propId1, NULL, this.propertyValue(this.propertyKey1, (Value)Values.intValue((int)2)));
            nodeId2 = this.node(this.nodeStore.nextId(CursorContext.NULL), propId1, NULL, new int[0]);
        }
        this.checkNode(nodeId1);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, ConsistencyReport.PrimitiveConsistencyReport::propertyKeyNotUniqueInChain);
        Mockito.reset((Object[])new ConsistencyReporter.Monitor[]{this.monitor});
        this.checkNode(nodeId2);
        this.expect(ConsistencyReport.NodeConsistencyReport.class, ConsistencyReport.PrimitiveConsistencyReport::propertyKeyNotUniqueInChain);
    }

    private void checkNode(long nodeId) throws Exception {
        try (SafePropertyChainReader checker = new SafePropertyChainReader(this.context(), CursorContext.NULL);){
            this.checkNode(checker, nodeId);
        }
    }

    private void checkNode(SafePropertyChainReader checker, long nodeId) {
        boolean chainOk = checker.read((MutableIntObjectMap)new IntObjectHashMap(), (PrimitiveRecord)this.loadNode(nodeId), arg_0 -> ((ConsistencyReporter)this.reporter).forNode(arg_0), CursorContext.NULL);
        Assertions.assertFalse((boolean)chainOk);
    }
}

